/*
 * Decompiled with CFR 0.152.
 */
package org.icij.extract;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayDeque;
import java.util.EnumSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import org.icij.concurrent.SealableLatch;
import org.icij.event.Notifiable;
import org.icij.extract.document.DocumentFactory;
import org.icij.extract.document.TikaDocument;
import org.icij.task.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScannerVisitor
extends SimpleFileVisitor<Path>
implements Callable<Long> {
    public static final String FOLLOW_SYMLINKS = "followSymlinks";
    public static final String MAX_DEPTH = "maxDepth";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ArrayDeque<PathMatcher> includeMatchers = new ArrayDeque();
    private final ArrayDeque<PathMatcher> excludeMatchers = new ArrayDeque();
    private final Path path;
    private final BlockingQueue<TikaDocument> queue;
    private final DocumentFactory factory;
    private boolean followLinks = false;
    private int maxDepth = Integer.MAX_VALUE;
    private SealableLatch latch;
    private Notifiable notifiable;
    private long queued = 0L;

    public ScannerVisitor(Path path, BlockingQueue<TikaDocument> queue, DocumentFactory factory, Options<String> options) {
        this.path = path;
        this.queue = queue;
        this.factory = factory;
        options.ifPresent(FOLLOW_SYMLINKS, o -> o.parse().asBoolean()).ifPresent(this::followSymLinks);
        options.ifPresent(MAX_DEPTH, o -> o.parse().asInteger()).ifPresent(this::setMaxDepth);
    }

    public ScannerVisitor withMonitor(Notifiable monitor) {
        this.notifiable = monitor;
        return this;
    }

    public ScannerVisitor withLatch(SealableLatch latch) {
        this.latch = latch;
        return this;
    }

    @Override
    public Long call() throws Exception {
        EnumSet<FileVisitOption> options = this.followLinks ? EnumSet.of(FileVisitOption.FOLLOW_LINKS) : EnumSet.noneOf(FileVisitOption.class);
        this.logger.info(String.format("Starting scan of: \"%s\".", this.path));
        try {
            Files.walkFileTree(this.path, options, this.maxDepth, this);
        }
        catch (IOException e) {
            this.logger.error(String.format("Error while scanning path: \"%s\".", this.path), (Throwable)e);
            throw e;
        }
        finally {
            if (null != this.latch) {
                this.latch.seal();
                this.latch.signal();
            }
        }
        this.logger.info(String.format("Completed scan of: \"%s\".", this.path));
        return this.queued;
    }

    void queue(Path file, BasicFileAttributes attributes) throws InterruptedException {
        TikaDocument tikaDocument = this.factory.create(file, attributes);
        this.queue.put(tikaDocument);
        ++this.queued;
        if (null != this.latch) {
            this.latch.signal();
        }
        if (null != this.notifiable) {
            this.notifiable.notifyListeners(file);
        }
    }

    void exclude(PathMatcher matcher) {
        this.excludeMatchers.add(matcher);
    }

    void include(PathMatcher matcher) {
        this.includeMatchers.add(matcher);
    }

    boolean shouldExclude(Path path) {
        return this.matches(path, this.excludeMatchers);
    }

    boolean shouldInclude(Path path) {
        return this.includeMatchers.size() == 0 || this.matches(path, this.includeMatchers);
    }

    private boolean matches(Path path, ArrayDeque<PathMatcher> matchers) {
        for (PathMatcher matcher : matchers) {
            if (!matcher.matches(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path directory, BasicFileAttributes attributes) throws IOException {
        if (Thread.currentThread().isInterrupted()) {
            this.logger.warn("Scanner interrupted. Terminating job.");
            return FileVisitResult.TERMINATE;
        }
        if (this.shouldExclude(directory)) {
            return FileVisitResult.SKIP_SUBTREE;
        }
        this.logger.info(String.format("Entering directory: \"%s\".", directory));
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
        if (Thread.currentThread().isInterrupted()) {
            this.logger.warn("Scanner interrupted. Terminating job.");
            return FileVisitResult.TERMINATE;
        }
        if (attributes.isSymbolicLink()) {
            if (this.followLinks) {
                this.logger.warn(String.format("Unable to read attributes of symlink target: \"%s\". Skipping.", file));
            }
            return FileVisitResult.CONTINUE;
        }
        if (!this.shouldInclude(file)) {
            return FileVisitResult.CONTINUE;
        }
        if (this.shouldExclude(file)) {
            return FileVisitResult.CONTINUE;
        }
        try {
            this.queue(file, attributes);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.warn("Interrupted. Terminating scanner.");
            return FileVisitResult.TERMINATE;
        }
        catch (Exception e) {
            this.logger.error(String.format("Exception while queuing file: \"%s\".", file), (Throwable)e);
            throw e;
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException e) throws IOException {
        if (!this.shouldExclude(file)) {
            this.logger.error(String.format("Unable to read attributes of file: \"%s\".", file), (Throwable)e);
        }
        return FileVisitResult.CONTINUE;
    }

    private void setMaxDepth(Integer max) {
        this.maxDepth = max;
    }

    private void followSymLinks(Boolean follow) {
        this.followLinks = follow;
    }
}

