/*
 * Decompiled with CFR 0.152.
 */
package org.icij.extract.document;

import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Objects;
import java.util.Optional;
import org.apache.tika.metadata.Metadata;
import org.icij.extract.document.DigestIdentifier;
import org.icij.extract.document.Identifier;
import org.icij.extract.document.PathDigestIdentifier;
import org.icij.extract.document.PathIdentifier;
import org.icij.extract.document.TikaDocument;
import org.icij.task.Options;
import org.icij.task.annotation.Option;

@org.icij.task.annotation.Options(value={@Option(name="idMethod", description="The method for determining document IDs, for queues that use them. Defaults to using the path as an ID.", parameter="name"), @Option(name="idDigestMethod", description="For calculating document ID digests, where applicable depending on the ID method.", parameter="name"), @Option(name="charset", description="Set the output encoding for text and document attributes. Defaults to UTF-8.", parameter="name")})
public class DocumentFactory {
    private Identifier identifier = null;

    public DocumentFactory(Options<String> options) {
        this.configure(options);
    }

    public DocumentFactory() {
    }

    public DocumentFactory configure(Options<String> options) {
        String algorithm = options.valueIfPresent("idDigestMethod").orElse("SHA-256");
        Charset charset = Charset.forName(options.valueIfPresent("charset").orElse("UTF-8"));
        Optional<String> method = options.valueIfPresent("idMethod");
        if (method.isPresent()) {
            switch (method.get()) {
                case "path": {
                    this.identifier = new PathIdentifier();
                    break;
                }
                case "path-digest": {
                    this.identifier = new PathDigestIdentifier(algorithm, charset);
                    break;
                }
                case "tika-digest": {
                    this.identifier = new DigestIdentifier(algorithm, charset);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("\"%s\" is not a valid identifier.", method.get()));
                }
            }
        } else {
            this.identifier = new DigestIdentifier(algorithm, charset);
        }
        return this;
    }

    public DocumentFactory withIdentifier(Identifier identifier) {
        Objects.requireNonNull(identifier, "Identifier generator must not be null.");
        this.identifier = identifier;
        return this;
    }

    public TikaDocument create(String id, Path path) {
        return new TikaDocument(id, this.identifier, path);
    }

    public TikaDocument create(String id, Path path, long size) {
        Metadata metadata = new Metadata();
        metadata.set("Content-Length", Long.toString(size));
        return new TikaDocument(id, this.identifier, path, metadata);
    }

    public TikaDocument create(String id, Path path, Metadata metadata) {
        return new TikaDocument(id, this.identifier, path, metadata);
    }

    public TikaDocument create(Path path) {
        return new TikaDocument(this.identifier, path);
    }

    public TikaDocument create(Path path, BasicFileAttributes attributes) {
        return this.create(path, attributes.size());
    }

    public TikaDocument create(Path path, long size) {
        Metadata metadata = new Metadata();
        metadata.set("Content-Length", Long.toString(size));
        return new TikaDocument(this.identifier, path, metadata);
    }

    public TikaDocument create(String path) {
        return this.create(Paths.get(path, new String[0]));
    }

    public TikaDocument create(String id, String path) {
        return this.create(id, Paths.get(path, new String[0]));
    }

    public TikaDocument create(Path path, Metadata metadata) {
        return new TikaDocument(this.identifier, path, metadata);
    }

    public TikaDocument create(URL url) throws URISyntaxException {
        return this.create(Paths.get(url.toURI()));
    }
}

