/*
 * Decompiled with CFR 0.152.
 */
package org.icij.extract.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.tika.detect.AutoDetectReader;
import org.apache.tika.detect.DefaultDetector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.icij.extract.io.URLEncodingInputStream;

public class DataURIEncodingInputStream
extends InputStream {
    private final InputStream encoder;
    private final byte[] prepend;
    private int position = 0;

    private static MediaType detectType(Path path, Metadata metadata) throws IOException {
        MediaType type = null;
        String orig = metadata.get("Content-Type");
        if (null == orig || orig.isEmpty()) {
            orig = metadata.get(TikaCoreProperties.TYPE);
        }
        if (null != orig) {
            type = MediaType.parse((String)orig);
        }
        if (null == type) {
            try (BufferedInputStream input = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
                type = new DefaultDetector().detect((InputStream)input, metadata);
            }
        }
        if (type.getType().equals("text")) {
            Map parameters = type.getParameters();
            if (null != parameters.get("charset")) {
                return type;
            }
            Charset charset = DataURIEncodingInputStream.detectCharset(path, metadata);
            if (null != charset) {
                parameters.put("charset", charset.name());
                type = new MediaType(type.getBaseType(), parameters);
            }
        }
        return type;
    }

    private static Charset detectCharset(Path path, Metadata metadata) throws IOException {
        Charset charset;
        String orig = metadata.get("Content-Encoding");
        if (null != orig && Charset.isSupported(orig)) {
            return Charset.forName(orig);
        }
        try (BufferedInputStream input = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
             AutoDetectReader detector = new AutoDetectReader((InputStream)input, metadata);){
            charset = detector.getCharset();
        }
        catch (TikaException e) {
            throw new IOException("Unable to detect charset.", e);
        }
        return charset;
    }

    public static Reader createReader(Path path, Metadata metadata) throws IOException {
        return new InputStreamReader((InputStream)new DataURIEncodingInputStream(path, metadata), StandardCharsets.US_ASCII);
    }

    public DataURIEncodingInputStream(Path path, Metadata metadata) throws IOException {
        this(new BufferedInputStream(Files.newInputStream(path, new OpenOption[0])), DataURIEncodingInputStream.detectType(path, metadata));
    }

    public DataURIEncodingInputStream(InputStream in, MediaType type) {
        if (type.getType().equals("text")) {
            this.prepend = ("data:" + type + ",").getBytes(StandardCharsets.US_ASCII);
            this.encoder = new URLEncodingInputStream(in);
        } else {
            this.prepend = ("data:" + type + ";base64,").getBytes(StandardCharsets.US_ASCII);
            this.encoder = new Base64InputStream(in, true, -1, null);
        }
    }

    @Override
    public int read() throws IOException {
        if (this.position < this.prepend.length) {
            return this.prepend[this.position++];
        }
        return this.encoder.read();
    }

    @Override
    public int available() throws IOException {
        if (this.position < this.prepend.length) {
            return this.prepend.length - this.position;
        }
        return this.encoder.available();
    }

    @Override
    public void close() throws IOException {
        this.encoder.close();
    }
}

