/*
 * Decompiled with CFR 0.152.
 */
package org.icij.extract.queue;

import java.util.concurrent.ArrayBlockingQueue;
import org.icij.extract.document.TikaDocument;
import org.icij.extract.queue.DocumentQueue;
import org.icij.task.Options;
import org.icij.task.annotation.Option;

@Option(name="queueBuffer", description="The size of the internal file path buffer used by the queue.", parameter="size")
public class ArrayDocumentQueue
extends ArrayBlockingQueue<TikaDocument>
implements DocumentQueue {
    private static final long serialVersionUID = -7491630465350342533L;

    ArrayDocumentQueue(Options<String> options) {
        this(options.get("queueBuffer").parse().asInteger().orElse(1024));
    }

    public ArrayDocumentQueue(int capacity) {
        super(capacity);
    }

    @Override
    public void close() {
        this.clear();
    }

    @Override
    public DocumentQueue newQueue() {
        return new ArrayDocumentQueue(this.size());
    }
}

