/*
 * Decompiled with CFR 0.152.
 */
package org.icij.extract.redis;

import org.icij.task.Options;
import org.icij.task.annotation.Option;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;

@org.icij.task.annotation.Options(value={@Option(name="redisAddress", description="Set the Redis backend address. Defaults to 127.0.0.1:6379.", parameter="address"), @Option(name="redisTimeout", description="The client timeout for Redis operations.", parameter="timeout")})
public class RedissonClientFactory {
    private String address = null;
    private int timeout = -1;

    public RedissonClientFactory withOptions(Options<String> options) {
        this.withAddress(options.valueIfPresent("redisAddress").orElse(null));
        options.ifPresent("redisTimeout", o -> o.parse().asInteger()).ifPresent(this::withTimeout);
        return this;
    }

    private RedissonClientFactory withAddress(String address) {
        this.address = address;
        return this;
    }

    private RedissonClientFactory withTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public RedissonClient create() {
        String address = null == this.address ? "redis://127.0.0.1:6379" : this.address;
        int timeout = this.timeout < 0 ? 60000 : this.timeout;
        Config config = new Config();
        config.useSingleServer().setAddress(address).setTimeout(timeout);
        return Redisson.create((Config)config);
    }
}

