/*
 * Decompiled with CFR 0.152.
 */
package org.icij.extract;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.icij.concurrent.ExecutorProxy;
import org.icij.concurrent.SealableLatch;
import org.icij.event.Notifiable;
import org.icij.extract.ScannerVisitor;
import org.icij.extract.document.DocumentFactory;
import org.icij.extract.document.TikaDocument;
import org.icij.extract.io.file.DosHiddenFileMatcher;
import org.icij.extract.io.file.PosixHiddenFileMatcher;
import org.icij.extract.io.file.SystemFileMatcher;
import org.icij.task.Option;
import org.icij.task.Options;
import org.icij.task.StringOptionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.icij.task.annotation.Options(value={@org.icij.task.annotation.Option(name="includeHiddenFiles", description="Don't ignore hidden files. On DOS file systems, this means all files or directories with the \"hidden\" file attribute. On all other file systems, this means all file or directories starting with a dot. Hidden files are ignored by default."), @org.icij.task.annotation.Option(name="includeOSFiles", description="Include files and directories generated by common operating systems. This includes \"Thumbs.db\" and \".DS_Store\". The list is not determined by the current operating system. OS-generated files are ignored by default."), @org.icij.task.annotation.Option(name="includePattern", description="Glob pattern for matching files e.g. \"**/*.{tif,pdf}\". Files not matching the pattern will be ignored.", parameter="pattern"), @org.icij.task.annotation.Option(name="excludePattern", description="Glob pattern for excluding files and directories. Files and directories matching the pattern will be ignored.", parameter="pattern"), @org.icij.task.annotation.Option(name="followSymlinks", description="Follow symbolic links, which are not followed by default."), @org.icij.task.annotation.Option(name="maxDepth", description="The maximum depth to which the scanner will recurse.", parameter="integer")})
public class Scanner
extends ExecutorProxy {
    private static final Logger logger = LoggerFactory.getLogger(Scanner.class);
    protected final BlockingQueue<TikaDocument> queue;
    private final ArrayDeque<String> includeGlobs = new ArrayDeque();
    private final ArrayDeque<String> excludeGlobs = new ArrayDeque();
    private final DocumentFactory factory;
    private final SealableLatch latch;
    private final Notifiable notifiable;
    private long queued = 0L;
    private boolean ignoreHiddenFiles = false;
    private boolean ignoreSystemFiles = true;
    private Options<String> options = new Options();

    public Scanner(DocumentFactory factory, BlockingQueue<TikaDocument> queue) {
        this(factory, queue, null, null);
    }

    public Scanner(DocumentFactory factory, BlockingQueue<TikaDocument> queue, SealableLatch latch) {
        this(factory, queue, latch, null);
    }

    public Scanner(DocumentFactory factory, BlockingQueue<TikaDocument> queue, SealableLatch latch, Notifiable notifiable) {
        super(Executors.newSingleThreadExecutor());
        this.factory = factory;
        this.queue = queue;
        this.notifiable = notifiable;
        this.latch = latch;
    }

    public Scanner configure(Options<String> options) {
        options.get("includeOSFiles").parse().asBoolean().ifPresent(this::ignoreSystemFiles);
        options.get("includeHiddenFiles").parse().asBoolean().ifPresent(this::ignoreHiddenFiles);
        options.get("includePattern").values().forEach(this::include);
        options.get("excludePattern").values().forEach(this::exclude);
        this.options = options;
        return this;
    }

    public void include(String pattern) {
        this.includeGlobs.add("glob:" + pattern);
    }

    public void exclude(String pattern) {
        this.excludeGlobs.add("glob:" + pattern);
    }

    public void followSymLinks(boolean followLinks) {
        this.options.add(new Option<String>("followSymlinks", StringOptionParser::new).update(Boolean.toString(followLinks)));
    }

    public boolean followSymLinks() {
        return this.options.ifPresent("followSymlinks", o -> o.parse().asBoolean()).orElse(false);
    }

    public void ignoreHiddenFiles(boolean ignoreHiddenFiles) {
        this.ignoreHiddenFiles = ignoreHiddenFiles;
    }

    public boolean ignoreHiddenFiles() {
        return this.ignoreHiddenFiles;
    }

    public void ignoreSystemFiles(boolean ignoreSystemFiles) {
        this.ignoreSystemFiles = ignoreSystemFiles;
    }

    public boolean ignoreSystemFiles() {
        return this.ignoreSystemFiles;
    }

    public void setMaxDepth(int maxDepth) {
        this.options.add(new Option<String>("maxDepth", StringOptionParser::new).update(Integer.toString(maxDepth)));
    }

    public int getMaxDepth() {
        return this.options.ifPresent("maxDepth", o -> o.parse().asInteger()).orElse(Integer.MAX_VALUE);
    }

    public SealableLatch getLatch() {
        return this.latch;
    }

    public long queued() {
        return this.queued;
    }

    public Future<Path> scan(Path path) {
        return this.executor.submit(this.createScannerVisitor(path));
    }

    public ScannerVisitor createScannerVisitor(Path path) {
        ScannerVisitor visitor = new ScannerVisitor(path, this.queue, this.factory, this.options).withMonitor(this.notifiable).withLatch(this.latch);
        this.configureScannerVisitor(path, visitor);
        return visitor;
    }

    private void configureScannerVisitor(Path path, ScannerVisitor visitor) {
        FileSystem fileSystem = path.getFileSystem();
        if (this.ignoreHiddenFiles) {
            visitor.exclude(new PosixHiddenFileMatcher());
            if (fileSystem.supportedFileAttributeViews().contains("dos")) {
                visitor.exclude(new DosHiddenFileMatcher());
            }
        }
        if (this.ignoreSystemFiles) {
            visitor.exclude(new SystemFileMatcher());
        }
        for (String excludeGlob : this.excludeGlobs) {
            visitor.exclude(fileSystem.getPathMatcher(excludeGlob));
        }
        for (String includeGlob : this.includeGlobs) {
            visitor.include(fileSystem.getPathMatcher(includeGlob));
        }
        logger.info(String.format("Queuing scan of: \"%s\".", path));
    }

    public List<Future<Path>> scan(Path[] paths) {
        ArrayList<Future<Path>> futures = new ArrayList<Future<Path>>();
        for (Path path : paths) {
            futures.add(this.scan(path));
        }
        return futures;
    }

    public List<Future<Path>> scan(String[] paths) {
        Path[] _paths = new Path[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            _paths[i] = Paths.get(paths[i], new String[0]);
        }
        return this.scan(_paths);
    }

    public long getNumberOfFiles(Path path) throws IOException {
        CountingVisitor scannerVisitor = new CountingVisitor(path, null, null, this.options);
        this.configureScannerVisitor(path, scannerVisitor);
        Files.walkFileTree(path, scannerVisitor);
        return scannerVisitor.nbFiles.get();
    }

    static class CountingVisitor
    extends ScannerVisitor {
        final AtomicLong nbFiles = new AtomicLong(0L);

        public CountingVisitor(Path path, BlockingQueue<TikaDocument> queue, DocumentFactory factory, Options<String> options) {
            super(path, queue, factory, options);
        }

        @Override
        void queue(Path file, BasicFileAttributes attributes) {
            this.nbFiles.incrementAndGet();
        }
    }
}

