/*
 * Decompiled with CFR 0.152.
 */
package org.icij.extract.redis;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.icij.extract.document.DocumentFactory;
import org.icij.extract.document.PathIdentifier;
import org.icij.extract.document.TikaDocument;
import org.icij.extract.queue.DocumentQueue;
import org.icij.extract.redis.DocumentDecoder;
import org.icij.extract.redis.DocumentEncoder;
import org.icij.extract.redis.RedissonClientFactory;
import org.icij.task.Options;
import org.icij.task.annotation.Option;
import org.icij.task.annotation.OptionsClass;
import org.redisson.Redisson;
import org.redisson.RedissonBlockingQueue;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.BaseCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandSyncService;

@org.icij.task.annotation.Options(value={@Option(name="queueName", description="The name of the queue.", parameter="name"), @Option(name="charset", description="Set the output encoding for strings. Defaults to UTF-8.", parameter="name")})
@OptionsClass(value=RedissonClientFactory.class)
public class RedisDocumentQueue
extends RedissonBlockingQueue<TikaDocument>
implements DocumentQueue {
    private static final String DEFAULT_NAME = "extract:queue";
    private final RedissonClient redissonClient;

    public RedisDocumentQueue(final String queueName, final String redisAddress) {
        this(new DocumentFactory().withIdentifier(new PathIdentifier()), Options.from((Map<String, String>)new HashMap<String, String>(){
            {
                this.put("redisAddress", redisAddress);
                this.put("queueName", queueName);
            }
        }));
    }

    public RedisDocumentQueue(DocumentFactory factory, Options<String> options) {
        this(factory, new RedissonClientFactory().withOptions(options).create(), options.valueIfPresent("queueName").orElse(DEFAULT_NAME), Charset.forName(options.valueIfPresent("charset").orElse("UTF-8")));
    }

    private RedisDocumentQueue(DocumentFactory factory, RedissonClient redissonClient, String name, Charset charset) {
        this((Codec)new DocumentQueueCodec(factory, charset), (CommandAsyncExecutor)new CommandSyncService(((Redisson)redissonClient).getConnectionManager()), null == name ? DEFAULT_NAME : name, redissonClient);
    }

    private RedisDocumentQueue(Codec codec, CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(codec, commandExecutor, name, redisson);
        this.redissonClient = redisson;
    }

    @Override
    public DocumentQueue newQueue() {
        return new RedisDocumentQueue(this.codec, (CommandAsyncExecutor)new CommandSyncService(((Redisson)this.redissonClient).getConnectionManager()), this.getName() + ":filtered", this.redissonClient);
    }

    @Override
    public boolean remove(Object o, int count) {
        return super.remove(o, count);
    }

    @Override
    public void close() throws IOException {
        this.redissonClient.shutdown();
    }

    static class DocumentQueueCodec
    extends BaseCodec {
        private final Decoder<Object> documentDecoder;
        private final Encoder documentEncoder;

        DocumentQueueCodec(DocumentFactory factory, Charset charset) {
            this.documentDecoder = new DocumentDecoder(factory, charset);
            this.documentEncoder = new DocumentEncoder(charset);
        }

        public Decoder<Object> getValueDecoder() {
            return this.documentDecoder;
        }

        public Decoder<Object> getMapValueDecoder() {
            return this.documentDecoder;
        }

        public Decoder<Object> getMapKeyDecoder() {
            return this.documentDecoder;
        }

        public Encoder getMapValueEncoder() {
            return this.documentEncoder;
        }

        public Encoder getMapKeyEncoder() {
            return this.documentEncoder;
        }

        public Encoder getValueEncoder() {
            return this.documentEncoder;
        }
    }
}

