/*
 * Decompiled with CFR 0.152.
 */
package org.icij.concurrent;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.icij.concurrent.Shutdownable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExecutorProxy
implements Shutdownable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final ExecutorService executor;

    public ExecutorProxy(ExecutorService executor) {
        this.executor = executor;
    }

    @Override
    public void shutdown() {
        this.logger.info("Shutting down.");
        this.executor.shutdown();
    }

    public List<Runnable> shutdownNow() {
        this.logger.info("Shutting down immediately.");
        return this.executor.shutdownNow();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        this.logger.info(String.format("Awaiting completion up to %d %s.", new Object[]{timeout, unit}));
        if (!this.executor.awaitTermination(timeout, unit)) {
            this.logger.warn(String.format("Executor failed to terminate in %d %s.", new Object[]{timeout, unit}));
            return false;
        }
        this.logger.info("Terminated.");
        return true;
    }
}

