/*
 * Decompiled with CFR 0.152.
 */
package org.icij.extract.extractor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.icij.extract.document.EmbeddedTikaDocument;
import org.icij.extract.document.PathIdentifier;
import org.icij.extract.document.TikaDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class EmbedLinker
implements EmbeddedDocumentExtractor {
    private static final Logger logger = LoggerFactory.getLogger(EmbedLinker.class);
    private final TikaDocument parent;
    private final TemporaryResources tmp;
    private final String open;
    private final String close;
    private int untitled = 0;

    EmbedLinker(TikaDocument parent, TemporaryResources tmp, String open, String close) {
        this.parent = parent;
        this.tmp = tmp;
        this.open = open;
        this.close = close;
    }

    public boolean shouldParseEmbedded(Metadata metadata) {
        return true;
    }

    public void parseEmbedded(InputStream input, ContentHandler handler, Metadata metadata, boolean outputHtml) throws SAXException, IOException {
        AttributesImpl attributes;
        String name = metadata.get("resourceName");
        if (null == name || name.isEmpty()) {
            name = String.format("untitled file %d", ++this.untitled);
        }
        EmbeddedTikaDocument embed = this.saveEmbedded(name, input, metadata);
        if (outputHtml) {
            attributes = new AttributesImpl();
            attributes.addAttribute("", "class", "class", "CDATA", "package-entry");
            handler.startElement("http://www.w3.org/1999/xhtml", "div", "div", attributes);
        }
        attributes = new AttributesImpl();
        String type = metadata.get("Content-Type");
        String path = embed.getPath().toString();
        attributes.addAttribute("", "href", "href", "CDATA", this.open + path + this.close);
        attributes.addAttribute("", "title", "title", "CDATA", name);
        attributes.addAttribute("", "download", "download", "CDATA", name);
        if (null != type) {
            attributes.addAttribute("", "type", "type", "CDATA", type);
        }
        char[] chars = name.toCharArray();
        handler.startElement("http://www.w3.org/1999/xhtml", "a", "a", attributes);
        handler.characters(chars, 0, chars.length);
        handler.endElement("http://www.w3.org/1999/xhtml", "a", "a");
        if (outputHtml) {
            handler.endElement("http://www.w3.org/1999/xhtml", "div", "div");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EmbeddedTikaDocument saveEmbedded(String name, InputStream input, Metadata metadata) throws IOException {
        long copied;
        Path path = this.tmp.createTemporaryFile().toPath();
        EmbeddedTikaDocument embed = this.parent.addEmbed(path.toString(), new PathIdentifier(), path, metadata);
        if (input instanceof TikaInputStream && ((TikaInputStream)input).getOpenContainer() != null && ((TikaInputStream)input).getOpenContainer() instanceof DirectoryEntry) {
            POIFSFileSystem fs = new POIFSFileSystem();
            this.saveEntries((DirectoryEntry)((TikaInputStream)input).getOpenContainer(), (DirectoryEntry)fs.getRoot());
            try (OutputStream output = Files.newOutputStream(path, new OpenOption[0]);){
                fs.writeFilesystem(output);
            }
            return embed;
        }
        try {
            copied = Files.copy(input, path, StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            input.close();
        }
        if (copied > 0L) {
            logger.info("Copied {} bytes from embedded document \"{}\" in \"{}\" to file.", new Object[]{copied, name, this.parent});
        } else {
            logger.warn("No bytes copied for embedded document \"{}\" in \"{}\". This could indicate a downstream error.", (Object)name, (Object)this.parent);
        }
        return embed;
    }

    private void saveEntries(DirectoryEntry source, DirectoryEntry destination) throws IOException {
        for (Entry entry : source) {
            if (entry instanceof DirectoryEntry) {
                this.saveEntries((DirectoryEntry)entry, destination.createDirectory(entry.getName()));
                continue;
            }
            try {
                DocumentInputStream contents = new DocumentInputStream((DocumentEntry)entry);
                Throwable throwable = null;
                try {
                    destination.createDocument(entry.getName(), (InputStream)contents);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (contents == null) continue;
                    if (throwable != null) {
                        try {
                            contents.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    contents.close();
                }
            }
            catch (IOException e) {
                logger.error("Unable to save embedded document \"{}\" in document: \"{}\".", new Object[]{entry.getName(), this.parent, e});
            }
        }
    }
}

