/*
 * Decompiled with CFR 0.152.
 */
package org.icij.extract.extractor;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import java.util.Optional;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.DigestingParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.icij.extract.document.DigestIdentifier;
import org.icij.extract.document.EmbeddedTikaDocument;
import org.icij.extract.document.TikaDocument;
import org.icij.extract.document.TikaDocumentSource;
import org.icij.extract.extractor.EmbedParser;
import org.icij.extract.extractor.UpdatableDigester;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class EmbeddedDocumentMemoryExtractor {
    private final Parser parser;
    private final DigestingParser.Digester digester;
    private final String algorithm;

    public EmbeddedDocumentMemoryExtractor(UpdatableDigester digester) {
        this((DigestingParser.Digester)digester, digester.algorithm);
    }

    public EmbeddedDocumentMemoryExtractor(DigestingParser.Digester digester, String algorithm) {
        this.parser = new DigestingParser((Parser)new AutoDetectParser(), digester);
        this.digester = digester;
        this.algorithm = algorithm;
    }

    public TikaDocumentSource extract(TikaDocument rootDocument, String embeddedDocumentDigest) throws SAXException, TikaException, IOException {
        ParseContext context = new ParseContext();
        BodyContentHandler handler = new BodyContentHandler(-1);
        context.set(Parser.class, (Object)this.parser);
        DigestEmbeddedDocumentExtractor extractor = new DigestEmbeddedDocumentExtractor(rootDocument, embeddedDocumentDigest, context, this.digester, this.algorithm);
        context.set(EmbeddedDocumentExtractor.class, (Object)extractor);
        this.parser.parse((InputStream)new FileInputStream(rootDocument.getPath().toFile()), (ContentHandler)handler, rootDocument.getMetadata(), context);
        return extractor.getDocument();
    }

    static class ContentNotFoundException
    extends NullPointerException {
        ContentNotFoundException(String rootId, String embedId) {
            super("<" + embedId + "> embedded document not found in root document " + rootId);
        }
    }

    static class DigestEmbeddedDocumentExtractor
    extends EmbedParser {
        private final String digestToFind;
        private final DigestingParser.Digester digester;
        private final String algorithm;
        private TikaDocumentSource document = null;
        private LinkedList<TikaDocument> documentStack = new LinkedList();

        private DigestEmbeddedDocumentExtractor(TikaDocument rootDocument, String digest, ParseContext context, DigestingParser.Digester digester, String algorithm) {
            super(rootDocument, context);
            this.digestToFind = digest;
            this.digester = digester;
            this.algorithm = algorithm;
            this.documentStack.add(rootDocument);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void delegateParsing(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException {
            if (this.document != null) {
                return;
            }
            EmbeddedTikaDocument embed = this.documentStack.getLast().addEmbed(metadata);
            try (TikaInputStream tis = TikaInputStream.get((InputStream)new CloseShieldInputStream(stream));){
                String digest;
                this.digester.digest((InputStream)tis, metadata, this.context);
                tis.reset();
                try {
                    digest = new DigestIdentifier(this.algorithm, Charset.defaultCharset()).generateForEmbed(embed);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
                if (this.digestToFind.equals(digest)) {
                    int nbTmpBytesRead;
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    byte[] tmp = new byte[8192];
                    while ((nbTmpBytesRead = tis.read(tmp)) > 0) {
                        buffer.write(tmp, 0, nbTmpBytesRead);
                    }
                    this.document = new TikaDocumentSource(metadata, buffer.toByteArray());
                } else {
                    this.documentStack.add(embed);
                    super.delegateParsing((InputStream)tis, handler, metadata);
                }
            }
            finally {
                this.documentStack.removeLast();
            }
        }

        public TikaDocumentSource getDocument() {
            return Optional.ofNullable(this.document).orElseThrow(() -> new ContentNotFoundException(this.documentStack.get(0).getPath().toString(), this.digestToFind));
        }
    }
}

