/*
 * Decompiled with CFR 0.152.
 */
package org.icij.spewer;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.TaggedIOException;
import org.apache.commons.io.output.TaggedOutputStream;
import org.apache.tika.metadata.Metadata;
import org.icij.extract.document.TikaDocument;
import org.icij.extract.extractor.Extractor;
import org.icij.spewer.FieldNames;
import org.icij.spewer.MetadataTransformer;
import org.icij.spewer.Spewer;
import org.icij.task.Options;
import org.icij.task.annotation.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.icij.task.annotation.Options(value={@Option(name="outputDirectory", description="Directory to output extracted text. Defaults to the current directory.", parameter="path"), @Option(name="outputFormat", description="Set the output format. Either \"text\" or \"HTML\". Defaults to text output.", parameter="type")})
public class FileSpewer
extends Spewer
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(FileSpewer.class);
    private static final long serialVersionUID = -6541331052292803766L;
    private Path outputDirectory = Paths.get(".", new String[0]);
    private String outputExtension = "txt";

    public FileSpewer(FieldNames fields) {
        super(fields);
    }

    @Override
    public FileSpewer configure(Options<String> options) {
        super.configure(options);
        Extractor.OutputFormat outputFormat = options.get("outputFormat").parse().asEnum(Extractor.OutputFormat::parse).orElse(null);
        if (null != outputFormat && outputFormat.equals((Object)Extractor.OutputFormat.HTML)) {
            this.outputExtension = "html";
        }
        options.get("outputDirectory").parse().asPath().ifPresent(this::setOutputDirectory);
        return this;
    }

    public void setOutputDirectory(Path outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Override
    public void write(TikaDocument tikaDocument, Reader reader) throws IOException {
        File outputFileParent;
        boolean madeDirs;
        Path outputPath = this.getOutputPath(tikaDocument);
        Path contentsOutputPath = null != this.outputExtension ? outputPath.getFileSystem().getPath(outputPath.toString() + "." + this.outputExtension, new String[0]) : outputPath;
        logger.info(String.format("Outputting to file: \"%s\".", contentsOutputPath));
        Path outputParent = contentsOutputPath.getParent();
        if (null != outputParent && !(madeDirs = (outputFileParent = outputParent.toFile()).mkdirs()) && !outputFileParent.isDirectory()) {
            throw new TaggedIOException(new IOException(String.format("Unable to make directories for file: \"%s\".", contentsOutputPath)), (Serializable)this);
        }
        TaggedOutputStream tagged = null;
        try (OutputStream output = Files.newOutputStream(contentsOutputPath, new OpenOption[0]);){
            tagged = new TaggedOutputStream(output);
            this.copy(reader, (OutputStream)tagged);
        }
        catch (IOException e) {
            if (null != tagged && tagged.isCauseOf((Exception)e)) {
                throw new TaggedIOException(new IOException(String.format("Error writing output to file: \"%s\".", contentsOutputPath), e), (Serializable)this);
            }
            throw e;
        }
        if (this.outputMetadata) {
            this.writeMetadata(tikaDocument);
        }
    }

    private void writeMetadata(TikaDocument tikaDocument) throws IOException {
        Metadata metadata = tikaDocument.getMetadata();
        Path outputPath = this.getOutputPath(tikaDocument);
        outputPath = outputPath.getFileSystem().getPath(outputPath.toString() + ".json", new String[0]);
        logger.info(String.format("Outputting metadata to file: \"%s\".", outputPath));
        try (JsonGenerator jsonGenerator = new JsonFactory().createGenerator(outputPath.toFile(), JsonEncoding.UTF8);){
            jsonGenerator.useDefaultPrettyPrinter();
            jsonGenerator.writeStartObject();
            new MetadataTransformer(metadata, this.fields).transform((arg_0, arg_1) -> ((JsonGenerator)jsonGenerator).writeStringField(arg_0, arg_1), (name, values) -> {
                jsonGenerator.writeArrayFieldStart(name);
                jsonGenerator.writeStartArray();
                for (String value : values) {
                    jsonGenerator.writeString(value);
                }
            });
            jsonGenerator.writeEndObject();
            jsonGenerator.writeRaw('\n');
        }
        catch (IOException e) {
            throw new TaggedIOException(new IOException("Unable to output JSON."), (Serializable)this);
        }
    }

    private Path getOutputPath(TikaDocument tikaDocument) {
        Path path = tikaDocument.getPath();
        if (null != this.outputDirectory) {
            if (path.isAbsolute()) {
                return this.outputDirectory.resolve(path.toString().substring(1));
            }
            return this.outputDirectory.resolve(path);
        }
        return path;
    }

    @Override
    protected void writeDocument(TikaDocument doc, Reader reader, TikaDocument parent, TikaDocument root, int level) {
        throw new UnsupportedOperationException("Not implemented.");
    }
}

