/*
 * Decompiled with CFR 0.152.
 */
package org.icij.spewer;

import java.io.IOException;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.io.TaggedIOException;
import org.apache.tika.metadata.DublinCore;
import org.apache.tika.metadata.HttpHeaders;
import org.apache.tika.metadata.MSOffice;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Office;
import org.apache.tika.metadata.PDF;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TIFF;
import org.apache.tika.metadata.TikaCoreProperties;
import org.icij.spewer.FieldNames;

public class MetadataTransformer
implements Serializable {
    private static final List<DateTimeFormatter> dateFormats = new ArrayList<DateTimeFormatter>();
    private static final Map<String, Property> dateProperties = new HashMap<String, Property>();
    private static final List<String> deduplicateProperties = Arrays.asList("Content-Type".toLowerCase(Locale.ENGLISH), TikaCoreProperties.TITLE.getName().toLowerCase(Locale.ENGLISH), "title".toLowerCase(Locale.ENGLISH), "originator", "generator", "progid");
    private static final long serialVersionUID = -6643888792096975746L;
    private final Metadata metadata;
    private final FieldNames fields;
    private final Map<String, String> fieldMap = new HashMap<String, String>();

    public MetadataTransformer(Metadata metadata, FieldNames fields) {
        this.metadata = metadata;
        this.fields = fields;
    }

    public void transform(ValueConsumer single, ValueArrayConsumer multiple) throws IOException {
        HashMap<String, String[]> normalised = new HashMap<String, String[]>();
        for (String name : this.metadata.names()) {
            String[] values = this.metadata.getValues(name);
            if (0 == values.length) continue;
            if (values.length > 1 && name.equals("title")) {
                values = Arrays.copyOfRange(values, 0, 1);
            }
            String normalisedName = this.fields.forMetadata(name);
            this.fieldMap.putIfAbsent(normalisedName, name);
            normalised.merge(normalisedName, values, this::concat);
        }
        try {
            for (Map.Entry entry : normalised.entrySet()) {
                String[] values = (String[])entry.getValue();
                if (values.length > 1) {
                    this.transform((String)entry.getKey(), values, multiple);
                    continue;
                }
                this.transform((String)entry.getKey(), values[0], single);
            }
        }
        catch (IOException e) {
            throw new TaggedIOException(e, this.getClass());
        }
    }

    private String[] concat(String[] a, String[] b) {
        String[] n = new String[a.length + b.length];
        System.arraycopy(a, 0, n, 0, a.length);
        System.arraycopy(b, 0, n, a.length, b.length);
        return n;
    }

    private void transform(String normalisedName, String[] values, ValueArrayConsumer consumer) throws IOException {
        Stream<String> stream = Arrays.stream(values);
        stream = stream.filter(value -> null != value && !value.isEmpty());
        if (values.length > 1 && deduplicateProperties.contains(this.fieldMap.get(normalisedName).toLowerCase(Locale.ENGLISH))) {
            stream = stream.distinct();
        }
        if ((values = (String[])stream.toArray(String[]::new)).length > 0) {
            consumer.accept(normalisedName, values);
        }
    }

    private void transform(String normalisedName, String value, ValueConsumer consumer) throws IOException {
        if (null == value || value.isEmpty()) {
            return;
        }
        consumer.accept(normalisedName, value);
        String name = this.fieldMap.get(normalisedName);
        if (dateProperties.containsKey(name)) {
            this.transformDate(name, consumer);
        }
    }

    private void transformDate(String name, ValueConsumer consumer) throws IOException {
        Date date = this.metadata.getDate(dateProperties.get(name));
        Instant instant = null;
        if (null != date) {
            instant = date.toInstant();
        } else {
            for (DateTimeFormatter format : dateFormats) {
                TemporalAccessor accessor;
                try {
                    accessor = format.parseBest(this.metadata.get(name), Instant::from, LocalDateTime::from);
                }
                catch (DateTimeParseException e) {
                    continue;
                }
                if (accessor instanceof Instant) {
                    instant = (Instant)accessor;
                    break;
                }
                if (!(accessor instanceof LocalDateTime)) break;
                instant = ((LocalDateTime)accessor).toInstant(ZoneOffset.UTC);
                break;
            }
        }
        if (null == instant) {
            throw new IOException(String.format("Unable to parse date \"%s\" from field \"%s\" for ISO 8601 formatting.", this.metadata.get(name), name));
        }
        consumer.accept(this.fields.forMetadataISODate(name), instant.toString());
    }

    static {
        dateFormats.add(DateTimeFormatter.RFC_1123_DATE_TIME);
        dateFormats.add(DateTimeFormatter.ofPattern("EEE MMM d HH:mm:ss uuuu", Locale.ENGLISH));
        Stream.of(DublinCore.DATE, DublinCore.CREATED, DublinCore.MODIFIED, Office.CREATION_DATE, Office.SAVE_DATE, Office.PRINT_DATE, MSOffice.CREATION_DATE, MSOffice.LAST_SAVED, MSOffice.LAST_PRINTED, PDF.DOC_INFO_CREATED, PDF.DOC_INFO_MODIFICATION_DATE, TIFF.ORIGINAL_DATE, Metadata.DATE, Property.externalDate((String)"modified"), HttpHeaders.LAST_MODIFIED).forEach(property -> dateProperties.put(property.getName(), (Property)property));
    }

    @FunctionalInterface
    public static interface ValueArrayConsumer {
        public void accept(String var1, String[] var2) throws IOException;
    }

    @FunctionalInterface
    public static interface ValueConsumer {
        public void accept(String var1, String var2) throws IOException;
    }
}

