/*
 * Decompiled with CFR 0.152.
 */
package org.icij.extract.report;

import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import org.icij.extract.extractor.ExtractionStatus;
import org.icij.extract.report.Report;
import org.icij.extract.report.ReportMap;

public class Reporter
implements AutoCloseable {
    private Set<Class<? extends Exception>> journalableTypes = new HashSet<Class<? extends Exception>>();
    private Map<Path, Report> journal = new ConcurrentHashMap<Path, Report>();
    private Semaphore flushing = new Semaphore(1);
    private final ReportMap reportMap;

    public Reporter(ReportMap reportMap) {
        this.reportMap = reportMap;
        Collection<Class<? extends Exception>> journalableExceptions = reportMap.journalableExceptions();
        if (null != journalableExceptions) {
            journalableExceptions.forEach(this::journalableException);
        }
    }

    public Report report(Path path) {
        return (Report)this.reportMap.get(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Path path, Report report) {
        try {
            this.reportMap.fastPut(path, report);
        }
        catch (Exception e) {
            if (this.journalableTypes.contains(e.getClass())) {
                this.journal.put(path, report);
            }
            throw e;
        }
        if (this.flushing.tryAcquire()) {
            try {
                this.flushJournal();
            }
            finally {
                this.flushing.release();
            }
        }
    }

    public void save(Path path, ExtractionStatus status, Exception exception) {
        this.save(path, new Report(status, exception));
    }

    public void save(Path path, ExtractionStatus status) {
        this.save(path, new Report(status));
    }

    public boolean check(Path path, ExtractionStatus result) {
        Report report = this.report(path);
        return null != report && report.getStatus().equals((Object)result);
    }

    public boolean skip(Path path) {
        return this.check(path, ExtractionStatus.SUCCESS);
    }

    @Override
    public void close() throws Exception {
        this.flushing.acquire();
        try {
            this.flushJournal();
        }
        finally {
            this.flushing.release();
        }
        this.reportMap.close();
    }

    private synchronized void journalableException(Class<? extends Exception> e) {
        this.journalableTypes.add(e);
    }

    private void flushJournal() {
        Iterator<Map.Entry<Path, Report>> iterator = this.journal.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Path, Report> entry = iterator.next();
            this.reportMap.fastPut(entry.getKey(), entry.getValue());
            iterator.remove();
        }
    }
}

