/*
 * Decompiled with CFR 0.152.
 */
package org.icij.spewer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import javax.naming.OperationNotSupportedException;
import org.icij.extract.document.EmbeddedTikaDocument;
import org.icij.extract.document.TikaDocument;
import org.icij.spewer.FieldNames;
import org.icij.spewer.MetadataTransformer;
import org.icij.task.Options;
import org.icij.task.annotation.Option;

@org.icij.task.annotation.Options(value={@Option(name="outputMetadata", description="Output metadata along with extracted text. For the \"file\" output type, a corresponding JSON file is created for every input file. With indexes, metadata fields are set using an optional prefix. On by default."), @Option(name="tag", description="Set the given field to a corresponding value on each document output.", parameter="name-value-pair"), @Option(name="charset", description="Set the output encoding for text and document attributes. Defaults to UTF-8.", parameter="name")})
public abstract class Spewer
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 5169670165236652447L;
    protected boolean outputMetadata = true;
    private Charset outputEncoding = StandardCharsets.UTF_8;
    protected final Map<String, String> tags = new HashMap<String, String>();
    protected final FieldNames fields;

    public Spewer() {
        this(new FieldNames());
    }

    public Spewer(FieldNames fields) {
        this.fields = fields;
    }

    public Spewer configure(Options<String> options) {
        options.get("outputMetadata").parse().asBoolean().ifPresent(this::outputMetadata);
        options.get("charset").value(Charset::forName).ifPresent(this::setOutputEncoding);
        options.get("tag").values().forEach(this::setTag);
        return this;
    }

    protected abstract void writeDocument(TikaDocument var1, TikaDocument var2, TikaDocument var3, int var4) throws IOException;

    public void write(TikaDocument document) throws IOException {
        this.writeDocument(document, null, null, 0);
        for (EmbeddedTikaDocument childDocument : document.getEmbeds()) {
            this.writeTree(childDocument, document, document, 1);
        }
    }

    private void writeTree(TikaDocument doc, TikaDocument parent, TikaDocument root, int level) throws IOException {
        this.writeDocument(doc, parent, root, level);
        for (EmbeddedTikaDocument child : doc.getEmbeds()) {
            this.writeTree(child, doc, root, level + 1);
        }
    }

    public TikaDocument[] write(Path path) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public FieldNames getFields() {
        return this.fields;
    }

    public void setOutputEncoding(Charset outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public Charset getOutputEncoding() {
        return this.outputEncoding;
    }

    public void outputMetadata(boolean outputMetadata) {
        this.outputMetadata = outputMetadata;
    }

    public boolean outputMetadata() {
        return this.outputMetadata;
    }

    public void setTags(Map<String, String> tags) {
        tags.forEach(this::setTag);
    }

    private void setTag(String name, String value) {
        this.tags.put(name, value);
    }

    private void setTag(String tag) {
        String[] pair = tag.split(":", 2);
        if (2 != pair.length) {
            throw new IllegalArgumentException(String.format("Invalid tag pair: \"%s\".", tag));
        }
        this.setTag(pair[0], pair[1]);
    }

    protected void copy(Reader input, OutputStream output) throws IOException {
        Spewer.copy(input, new OutputStreamWriter(output, this.outputEncoding));
    }

    public static void copy(Reader input, Writer output) throws IOException {
        int n;
        char[] buffer = new char[1024];
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        output.flush();
    }

    public static String toString(Reader reader) throws IOException {
        StringWriter writer = new StringWriter(4096);
        Spewer.copy(reader, writer);
        return writer.toString();
    }

    protected Map<String, Object> getMetadata(TikaDocument document) throws IOException {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        new MetadataTransformer(document.getMetadata(), this.fields).transform(new MapValueConsumer(metadata), new MapValuesConsumer(metadata));
        return metadata;
    }

    @Override
    public void close() throws Exception {
        throw new OperationNotSupportedException("not implemented");
    }

    protected static class MapValuesConsumer
    implements MetadataTransformer.ValueArrayConsumer {
        private final Map<String, Object> map;

        MapValuesConsumer(Map<String, Object> jsonDocument) {
            this.map = jsonDocument;
        }

        @Override
        public void accept(String name, String[] values) throws IOException {
            this.map.put(name, String.join((CharSequence)",", values));
        }
    }

    protected static class MapValueConsumer
    implements MetadataTransformer.ValueConsumer {
        private final Map<String, Object> map;

        MapValueConsumer(Map<String, Object> map) {
            this.map = map;
        }

        @Override
        public void accept(String name, String value) throws IOException {
            this.map.put(name, value);
        }
    }
}

