/*
 * Decompiled with CFR 0.152.
 */
package org.icij.kaxxa.io;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import org.icij.kaxxa.io.TokenResolver;

public class TokenReplacingReader
extends Reader {
    private final String start;
    private final String end;
    private final char[] startChars;
    private final char[] endChars;
    private char[] startCharsBuffer;
    private char[] endCharsBuffer;
    private final PushbackReader pushback;
    private final TokenResolver<Reader> resolver;
    private final StringBuilder token = new StringBuilder();
    private Reader resolved = null;

    public TokenReplacingReader(TokenResolver<Reader> resolver, Reader source, String start, String end) {
        if (resolver == null) {
            throw new IllegalArgumentException("Token resolver is null");
        }
        if (start == null || start.length() < 1 || end == null || end.length() < 1) {
            throw new IllegalArgumentException("Token start / end marker is null or empty");
        }
        this.start = start;
        this.end = end;
        this.startChars = start.toCharArray();
        this.endChars = end.toCharArray();
        this.startCharsBuffer = new char[start.length()];
        this.endCharsBuffer = new char[end.length()];
        this.pushback = new PushbackReader(source, Math.max(start.length(), end.length()));
        this.resolver = resolver;
    }

    @Override
    public int read() throws IOException {
        if (this.resolved != null) {
            int c = this.resolved.read();
            if (-1 == c) {
                this.resolved.close();
                this.resolved = null;
            } else {
                return c;
            }
        }
        int countValidChars = this.readChars(this.startCharsBuffer);
        if (!Arrays.equals(this.startCharsBuffer, this.startChars)) {
            if (countValidChars > 0) {
                this.pushback.unread(this.startCharsBuffer, 0, countValidChars);
            }
            return this.pushback.read();
        }
        boolean endOfSource = false;
        this.token.delete(0, this.token.length());
        countValidChars = this.readChars(this.endCharsBuffer);
        while (!Arrays.equals(this.endCharsBuffer, this.endChars)) {
            if (countValidChars == -1) {
                endOfSource = true;
                break;
            }
            this.token.append(this.endCharsBuffer[0]);
            this.pushback.unread(this.endCharsBuffer, 0, countValidChars);
            if (this.pushback.read() == -1) {
                endOfSource = true;
                break;
            }
            countValidChars = this.readChars(this.endCharsBuffer);
        }
        if (endOfSource) {
            this.resolved = new StringReader(this.start + this.token.toString());
        } else {
            this.resolved = this.resolver.resolveToken(this.token.toString());
            if (this.resolved == null) {
                this.resolved = new StringReader(this.start + this.token.toString() + this.end);
            }
        }
        return this.resolved.read();
    }

    private int readChars(char[] tmpChars) throws IOException {
        int countValidChars = -1;
        int length = tmpChars.length;
        int data = this.pushback.read();
        for (int i = 0; i < length; ++i) {
            if (data != -1) {
                tmpChars[i] = (char)data;
                countValidChars = i + 1;
                if (i + 1 >= length) continue;
                data = this.pushback.read();
                continue;
            }
            tmpChars[i] = '\u0000';
        }
        return countValidChars;
    }

    @Override
    public int read(char[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(char[] buffer, int offset, int length) throws IOException {
        int read = 0;
        for (int i = 0; i < length; ++i) {
            int c = this.read();
            if (c == -1) {
                read = i;
                if (read != 0) break;
                read = -1;
                break;
            }
            read = i + 1;
            buffer[offset + i] = (char)c;
        }
        return read;
    }

    @Override
    public void close() throws IOException {
        IOException thrown = null;
        try {
            this.pushback.close();
        }
        catch (IOException e) {
            thrown = e;
        }
        if (null != this.resolved) {
            try {
                this.resolved.close();
            }
            catch (IOException e) {
                thrown = e;
            }
        }
        if (null != thrown) {
            throw thrown;
        }
    }

    @Override
    public boolean ready() throws IOException {
        return this.pushback.ready();
    }

    @Override
    public boolean markSupported() {
        return this.pushback.markSupported();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.pushback.skip(n);
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.pushback.mark(readAheadLimit);
    }

    @Override
    public void reset() throws IOException {
        this.pushback.reset();
    }
}

