/*
 * Decompiled with CFR 0.152.
 */
package org.icij.kaxxa.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;

public class URLEncodingInputStream
extends FilterInputStream {
    private final int[] buffer = new int[3];
    private int offset = 0;

    public URLEncodingInputStream(InputStream in) {
        super(in);
    }

    public static Reader reader(InputStream in) {
        return new InputStreamReader((InputStream)new URLEncodingInputStream(in), StandardCharsets.US_ASCII);
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.offset < 3) {
            return this.buffer[this.offset++];
        }
        int b = this.in.read();
        if (-1 == b) {
            return -1;
        }
        this.encode(b);
        return this.buffer[this.offset++];
    }

    @Override
    public int read(byte[] buff) throws IOException {
        return this.read(buff, 0, buff.length);
    }

    @Override
    public synchronized int read(byte[] buff, int off, int len) throws IOException {
        int b;
        int read = 0;
        while (read < len && -1 != (b = this.read())) {
            buff[read++] = (byte)b;
        }
        if (0 == read) {
            return -1;
        }
        return read;
    }

    private void encode(int b) {
        if (32 == b) {
            this.offset = 2;
            this.buffer[this.offset] = 43;
        } else if (b >= 97 && b <= 122 || b >= 65 && b <= 90 || b >= 48 && b <= 57 || 45 == b || 95 == b || 46 == b || 42 == b) {
            this.offset = 2;
            this.buffer[this.offset] = b;
        } else {
            this.offset = 0;
            this.buffer[0] = 37;
            this.buffer[1] = b >> 4;
            this.buffer[2] = b & 0xF;
        }
    }
}

