/*
 * Copyright 2010-2011. Evgeny Dolgov
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.idevlab.rjc;

import java.util.List;

/**
 * @author Evgeny Dolgov
 */
public interface Session extends SingleRedisOperations {

    String select(int index);

    String multi();

    String discard();

    /**
     * @since 2.1.0
     */
    String watch(String... key);

    /**
     * @since 2.1.0
     */
    String unwatch();

    List<Object> exec();

    void close();
}
