/*
 * Decompiled with CFR 0.152.
 */
package org.idevlab.rjc.ds;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.idevlab.rjc.RedisException;
import org.idevlab.rjc.ds.RedisConnection;
import org.idevlab.rjc.protocol.Protocol;
import org.idevlab.rjc.protocol.RedisInputStream;
import org.idevlab.rjc.protocol.RedisOutputStream;
import org.idevlab.rjc.util.SafeEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RedisConnectionImpl
implements RedisConnection {
    private String host;
    private int port = 6379;
    private Socket socket;
    private Protocol protocol = new Protocol();
    private RedisOutputStream outputStream;
    private RedisInputStream inputStream;
    private int pipelinedCommands = 0;
    private int timeout = 2000;

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public void setTimeoutInfinite() {
        try {
            this.socket.setSoTimeout(0);
        }
        catch (SocketException ex) {
            throw new RedisException(ex);
        }
    }

    @Override
    public void rollbackTimeout() {
        try {
            this.socket.setSoTimeout(this.timeout);
        }
        catch (SocketException ex) {
            throw new RedisException(ex);
        }
    }

    public RedisConnectionImpl(String host) {
        this.host = host;
    }

    public RedisConnectionImpl(String host, int port) {
        this.host = host;
        this.port = port;
    }

    @Override
    public void sendCommand(Protocol.Command cmd, String ... args) {
        byte[][] bargs = new byte[args.length][];
        for (int i = 0; i < args.length; ++i) {
            bargs[i] = SafeEncoder.encode(args[i]);
        }
        this.sendCommand(cmd, bargs);
    }

    @Override
    public void sendCommand(Protocol.Command cmd, byte[] ... args) {
        try {
            this.connect();
        }
        catch (UnknownHostException e) {
            throw new RedisException("Could not connect to redis-server", e);
        }
        catch (IOException e) {
            throw new RedisException("Could not connect to redis-server", e);
        }
        this.protocol.sendCommand(this.outputStream, cmd, args);
        ++this.pipelinedCommands;
    }

    @Override
    public void sendCommand(Protocol.Command cmd) {
        this.sendCommand(cmd, new byte[0][]);
    }

    @Override
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public RedisConnectionImpl() {
    }

    @Override
    public void connect() throws UnknownHostException, IOException {
        if (!this.isConnected()) {
            this.socket = new Socket(this.host, this.port);
            this.socket.setSoTimeout(this.timeout);
            this.outputStream = new RedisOutputStream(this.socket.getOutputStream());
            this.inputStream = new RedisInputStream(this.socket.getInputStream());
        }
    }

    @Override
    public void close() {
        if (this.isConnected()) {
            try {
                this.inputStream.close();
                this.outputStream.close();
                if (!this.socket.isClosed()) {
                    this.socket.close();
                }
            }
            catch (IOException ex) {
                throw new RedisException(ex);
            }
        }
    }

    @Override
    public boolean isConnected() {
        return this.socket != null && this.socket.isBound() && !this.socket.isClosed() && this.socket.isConnected() && !this.socket.isInputShutdown() && !this.socket.isOutputShutdown();
    }

    @Override
    public String getStatusCodeReply() {
        --this.pipelinedCommands;
        byte[] resp = (byte[])this.protocol.read(this.inputStream);
        if (null == resp) {
            return null;
        }
        return SafeEncoder.encode(resp);
    }

    @Override
    public String getBulkReply() {
        byte[] result = this.getBinaryBulkReply();
        if (null != result) {
            return SafeEncoder.encode(result);
        }
        return null;
    }

    @Override
    public byte[] getBinaryBulkReply() {
        --this.pipelinedCommands;
        return (byte[])this.protocol.read(this.inputStream);
    }

    @Override
    public Long getIntegerReply() {
        --this.pipelinedCommands;
        return (Long)this.protocol.read(this.inputStream);
    }

    @Override
    public List<String> getMultiBulkReply() {
        List<byte[]> bresult = this.getBinaryMultiBulkReply();
        if (null == bresult) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(bresult.size());
        for (byte[] barray : bresult) {
            if (barray == null) {
                result.add(null);
                continue;
            }
            result.add(SafeEncoder.encode(barray));
        }
        return result;
    }

    @Override
    public List<byte[]> getBinaryMultiBulkReply() {
        --this.pipelinedCommands;
        return (List)this.protocol.read(this.inputStream);
    }

    @Override
    public List<Object> getObjectMultiBulkReply() {
        --this.pipelinedCommands;
        return (List)this.protocol.read(this.inputStream);
    }

    @Override
    public List<Object> getAll() {
        ArrayList<Object> all = new ArrayList<Object>();
        while (this.pipelinedCommands > 0) {
            all.add(this.protocol.read(this.inputStream));
            --this.pipelinedCommands;
        }
        return all;
    }

    @Override
    public Object getOne() {
        --this.pipelinedCommands;
        return this.protocol.read(this.inputStream);
    }
}

