/*
 * Decompiled with CFR 0.152.
 */
package org.idevlab.rjc.util;

import java.io.UnsupportedEncodingException;

public class KeyUtil {
    private KeyUtil() {
    }

    public static byte[] getKeyBytes(String k) {
        try {
            return k.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toKey(String separator, Object ... blocks) {
        if (blocks.length == 0) {
            throw new IllegalArgumentException("Empty key");
        }
        StringBuilder result = new StringBuilder();
        for (Object block : blocks) {
            result.append(block);
            result.append(separator);
        }
        result.deleteCharAt(result.length() - 1);
        return result.toString();
    }

    public static String toKey(Object ... blocks) {
        return KeyUtil.toKey(":", blocks);
    }
}

