/*
 * Decompiled with CFR 0.152.
 */
package org.idevlab.rjc.message;

import org.idevlab.rjc.message.MessageListener;
import org.idevlab.rjc.message.PMessageListener;
import org.idevlab.rjc.message.RedisNodeSubscriber;
import org.idevlab.rjc.message.RedisSubscriber;
import org.idevlab.rjc.message.SubscribeListener;
import org.idevlab.rjc.sharding.NodeLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShardedRedisSubscriber
implements RedisSubscriber {
    private NodeLocator<RedisNodeSubscriber> locator;

    public ShardedRedisSubscriber() {
    }

    public ShardedRedisSubscriber(NodeLocator<RedisNodeSubscriber> locator) {
        this.locator = locator;
    }

    public void setLocator(NodeLocator<RedisNodeSubscriber> locator) {
        this.locator = locator;
    }

    @Override
    public void subscribe(String channel, MessageListener listener) {
        this.locator.getNode(channel).subscribe(channel, listener);
    }

    @Override
    public void psubscribe(String pattern, PMessageListener listener) {
        for (RedisNodeSubscriber subscriber : this.locator.getNodes()) {
            subscriber.psubscribe(pattern, listener);
        }
    }

    @Override
    public void unsubscribe(String ... channels) {
        for (String channel : channels) {
            this.locator.getNode(channel).unsubscribe(channel);
        }
    }

    @Override
    public void punsubscribe(String ... patterns) {
        for (RedisNodeSubscriber subscriber : this.locator.getNodes()) {
            for (String pattern : patterns) {
                subscriber.punsubscribe(pattern);
            }
        }
    }

    @Override
    public void addListener(SubscribeListener listener) {
        for (RedisNodeSubscriber subscriber : this.locator.getNodes()) {
            subscriber.addListener(listener);
        }
    }

    @Override
    public void removeListener(SubscribeListener listener) {
        for (RedisNodeSubscriber subscriber : this.locator.getNodes()) {
            subscriber.removeListener(listener);
        }
    }

    public void close() {
        for (RedisNodeSubscriber subscriber : this.locator.getNodes()) {
            subscriber.close();
        }
    }
}

