/*
 * Decompiled with CFR 0.152.
 */
package org.idevlab.rjc.sharding;

import java.util.ArrayList;
import java.util.Collection;
import org.idevlab.rjc.NodeFactory;
import org.idevlab.rjc.ds.DataSourceFactory;
import org.idevlab.rjc.sharding.Shard;
import org.idevlab.rjc.sharding.ShardImpl;
import org.idevlab.rjc.sharding.ShardsFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShardsFactoryImpl<T>
implements ShardsFactory<T> {
    private NodeFactory<T> nodeFactory;
    private DataSourceFactory dataSourceFactory;
    private String addresses;
    private String weights;
    private String ids;

    @Override
    public Collection<Shard<T>> create() {
        if (this.addresses == null) {
            throw new IllegalStateException("Addresses must not be null");
        }
        String[] addressesArr = this.addresses.split(",");
        int[] weightsArr = this.extractWeights(addressesArr);
        String[] idsArr = this.extractIds(addressesArr);
        ArrayList<Shard<T>> result = new ArrayList<Shard<T>>(addressesArr.length);
        for (int i = 0; i < addressesArr.length; ++i) {
            String address = addressesArr[i].trim();
            String[] hostPort = address.split(":");
            result.add(new ShardImpl<T>(idsArr[i].trim(), this.nodeFactory.create(this.dataSourceFactory.create(hostPort[0].trim(), Integer.parseInt(hostPort[1].trim()))), weightsArr[i]));
        }
        return result;
    }

    private String[] extractIds(String[] addressesArr) {
        String[] idsArr;
        if (this.ids == null) {
            idsArr = new String[addressesArr.length];
            System.arraycopy(addressesArr, 0, idsArr, 0, idsArr.length);
        } else {
            idsArr = this.ids.split(",");
            if (idsArr.length != addressesArr.length) {
                throw new IllegalStateException("Number of addresses and ids must be equal");
            }
        }
        return idsArr;
    }

    private int[] extractWeights(String[] addressesArr) {
        int[] weightsArr = new int[addressesArr.length];
        if (this.weights == null) {
            for (int i = 0; i < weightsArr.length; ++i) {
                weightsArr[i] = 1;
            }
        } else {
            String[] weightsStrArr = this.weights.split(",");
            if (weightsStrArr.length != addressesArr.length) {
                throw new IllegalStateException("Number of addresses and weights must be equal");
            }
            for (int i = 0; i < weightsStrArr.length; ++i) {
                weightsArr[i] = Integer.parseInt(weightsStrArr[i].trim());
            }
        }
        return weightsArr;
    }

    public String getAddresses() {
        return this.addresses;
    }

    public void setAddresses(String addresses) {
        this.addresses = addresses;
    }

    public String getWeights() {
        return this.weights;
    }

    public void setWeights(String weights) {
        this.weights = weights;
    }

    public String getIds() {
        return this.ids;
    }

    public void setIds(String ids) {
        this.ids = ids;
    }

    public NodeFactory<T> getNodeFactory() {
        return this.nodeFactory;
    }

    public void setNodeFactory(NodeFactory<T> nodeFactory) {
        this.nodeFactory = nodeFactory;
    }

    public DataSourceFactory getDataSourceFactory() {
        return this.dataSourceFactory;
    }

    public void setDataSourceFactory(DataSourceFactory dataSourceFactory) {
        this.dataSourceFactory = dataSourceFactory;
    }
}

