/*
 * Decompiled with CFR 0.152.
 */
package org.idevlab.rjc.ds;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.commons.pool.ObjectPool;
import org.idevlab.rjc.RedisException;
import org.idevlab.rjc.ds.RedisConnection;
import org.idevlab.rjc.protocol.Protocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PoolableRedisConnection
implements RedisConnection {
    private final RedisConnection conn;
    private final ObjectPool pool;

    public PoolableRedisConnection(RedisConnection conn, ObjectPool pool) {
        this.conn = conn;
        this.pool = pool;
    }

    @Override
    public int getTimeout() {
        return this.conn.getTimeout();
    }

    @Override
    public void rollbackTimeout() {
        this.conn.rollbackTimeout();
    }

    @Override
    public String getHost() {
        return this.conn.getHost();
    }

    @Override
    public int getPort() {
        return this.conn.getPort();
    }

    @Override
    public void connect() throws UnknownHostException, IOException {
        this.conn.connect();
    }

    @Override
    public void close() {
        boolean isUnderlyingConnectionClosed;
        try {
            isUnderlyingConnectionClosed = !this.conn.isConnected();
        }
        catch (Exception e) {
            try {
                this.pool.invalidateObject((Object)this);
            }
            catch (IllegalStateException ise) {
                this.conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RedisException("Cannot close connection (isClosed check failed)");
        }
        if (!isUnderlyingConnectionClosed) {
            try {
                this.pool.returnObject((Object)this);
            }
            catch (IllegalStateException e) {
                this.conn.close();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RedisException("Cannot close connection (return to pool failed)", e);
            }
        } else {
            try {
                this.pool.invalidateObject((Object)this);
            }
            catch (IllegalStateException e) {
                this.conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RedisException("Already closed.");
        }
    }

    @Override
    public boolean isConnected() {
        return this.conn.isConnected();
    }

    @Override
    public void setTimeoutInfinite() {
        this.conn.setTimeoutInfinite();
    }

    @Override
    public String getStatusCodeReply() {
        return this.conn.getStatusCodeReply();
    }

    @Override
    public String getBulkReply() {
        return this.conn.getBulkReply();
    }

    @Override
    public byte[] getBinaryBulkReply() {
        return this.conn.getBinaryBulkReply();
    }

    @Override
    public Long getIntegerReply() {
        return this.conn.getIntegerReply();
    }

    @Override
    public List<String> getMultiBulkReply() {
        return this.conn.getMultiBulkReply();
    }

    @Override
    public List<byte[]> getBinaryMultiBulkReply() {
        return this.conn.getBinaryMultiBulkReply();
    }

    @Override
    public List<Object> getObjectMultiBulkReply() {
        return this.conn.getObjectMultiBulkReply();
    }

    @Override
    public List<Object> getAll() {
        return this.conn.getAll();
    }

    @Override
    public Object getOne() {
        return this.conn.getOne();
    }

    @Override
    public void sendCommand(Protocol.Command cmd, String ... args) {
        this.conn.sendCommand(cmd, args);
    }

    @Override
    public void sendCommand(Protocol.Command cmd, byte[] ... args) {
        this.conn.sendCommand(cmd, args);
    }

    @Override
    public void sendCommand(Protocol.Command cmd) {
        this.conn.sendCommand(cmd);
    }

    public void reallyDisconnect() {
        this.conn.close();
    }
}

