/*
 * Decompiled with CFR 0.152.
 */
package org.idevlab.rjc.message;

import java.util.List;
import org.idevlab.rjc.Client;
import org.idevlab.rjc.RedisException;
import org.idevlab.rjc.ds.DataSource;
import org.idevlab.rjc.message.MessageListener;
import org.idevlab.rjc.message.PMessageListener;
import org.idevlab.rjc.message.SubscribeListener;
import org.idevlab.rjc.protocol.Protocol;
import org.idevlab.rjc.util.SafeEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisNodeSubscriber {
    private static final Logger LOG = LoggerFactory.getLogger(RedisNodeSubscriber.class);
    private DataSource dataSource;
    private MessageListener messageListener;
    private PMessageListener pMessageListener;
    private String[] patterns;
    private String[] channels;
    private SubscribeListener subscribeListener;
    private Client client;

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public MessageListener getMessageListener() {
        return this.messageListener;
    }

    public void setMessageListener(MessageListener messageListener) {
        this.messageListener = messageListener;
    }

    public String[] getChannels() {
        return this.channels;
    }

    public void setChannels(String ... channels) {
        this.channels = channels;
    }

    public SubscribeListener getSubscribeListener() {
        return this.subscribeListener;
    }

    public void setSubscribeListener(SubscribeListener subscribeListener) {
        this.subscribeListener = subscribeListener;
    }

    public PMessageListener getPMessageListener() {
        return this.pMessageListener;
    }

    public void setPMessageListener(PMessageListener pMessageListener) {
        this.pMessageListener = pMessageListener;
    }

    public String[] getPatterns() {
        return this.patterns;
    }

    public void setPatterns(String ... patterns) {
        this.patterns = patterns;
    }

    public void unsubscribe(String ... channels) {
        this.client.unsubscribe(channels);
    }

    public void punsubscribe(String ... pattern) {
        this.client.punsubscribe(pattern);
    }

    public void subscribe() {
        this.client = new Client(this.dataSource.getConnection());
        this.client.setTimeoutInfinite();
        if (this.channels != null && this.channels.length > 0) {
            this.client.subscribe(this.channels);
        }
        if (this.patterns != null && this.patterns.length > 0) {
            this.client.psubscribe(this.patterns);
        }
        block10: while (true) {
            List<Object> reply;
            try {
                reply = this.client.getObjectMultiBulkReply();
            }
            catch (Exception e) {
                break;
            }
            Object firstObj = reply.get(0);
            if (!(firstObj instanceof byte[])) {
                throw new RedisException("Unknown message type: " + firstObj);
            }
            Protocol.Keyword keyword = Protocol.Keyword.find((byte[])firstObj);
            if (keyword == null) {
                throw new RedisException("Unknown pub/sub message: " + this.byteToStr((byte[])firstObj));
            }
            switch (keyword) {
                case MESSAGE: {
                    String channel = this.byteToStr((byte[])reply.get(1));
                    String message = this.byteToStr((byte[])reply.get(2));
                    if (this.messageListener == null) continue block10;
                    this.messageListener.onMessage(channel, message);
                    continue block10;
                }
                case PMESSAGE: {
                    String pattern = this.byteToStr((byte[])reply.get(1));
                    String channel = this.byteToStr((byte[])reply.get(2));
                    String message = this.byteToStr((byte[])reply.get(3));
                    if (this.pMessageListener == null) continue block10;
                    this.pMessageListener.onMessage(pattern, channel, message);
                    continue block10;
                }
                case SUBSCRIBE: {
                    String channel = this.byteToStr((byte[])reply.get(1));
                    Long subscribedChannels = (Long)reply.get(2);
                    if (this.subscribeListener == null) continue block10;
                    this.subscribeListener.onSubscribe(channel, subscribedChannels);
                    continue block10;
                }
                case UNSUBSCRIBE: {
                    String channel = this.byteToStr((byte[])reply.get(1));
                    Long subscribedChannels = (Long)reply.get(2);
                    if (this.subscribeListener == null) continue block10;
                    this.subscribeListener.onUnsubscribe(channel, subscribedChannels);
                    continue block10;
                }
                case PSUBSCRIBE: {
                    String pattern = this.byteToStr((byte[])reply.get(1));
                    Long subscribedChannels = (Long)reply.get(2);
                    if (this.subscribeListener == null) continue block10;
                    this.subscribeListener.onPSubscribe(pattern, subscribedChannels);
                    continue block10;
                }
                case PUNSUBSCRIBE: {
                    String pattern = this.byteToStr((byte[])reply.get(1));
                    Long subscribedChannels = (Long)reply.get(2);
                    if (this.subscribeListener == null) continue block10;
                    this.subscribeListener.onPUnsubscribe(pattern, subscribedChannels);
                    continue block10;
                }
            }
            LOG.warn("Unknown message: {}", (Object)keyword.toString());
        }
        LOG.debug("Subscriber is going out");
        this.close();
    }

    public void close() {
        this.client.unsubscribe();
        this.client.punsubscribe();
        this.client.rollbackTimeout();
        this.client.close();
        LOG.debug("Subscriber is  closed");
    }

    private String byteToStr(byte[] bytes) {
        return bytes == null ? null : SafeEncoder.encode(bytes);
    }
}

