/*
 * Decompiled with CFR 0.152.
 */
package org.idevlab.rjc;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.idevlab.rjc.DebugParams;
import org.idevlab.rjc.ElementScore;
import org.idevlab.rjc.ListPosition;
import org.idevlab.rjc.Pipeline;
import org.idevlab.rjc.RedisCallback;
import org.idevlab.rjc.RedisMonitor;
import org.idevlab.rjc.RedisTemplate;
import org.idevlab.rjc.Session;
import org.idevlab.rjc.SessionFactoryImpl;
import org.idevlab.rjc.SingleRedisOperations;
import org.idevlab.rjc.SortingParams;
import org.idevlab.rjc.ZParams;
import org.idevlab.rjc.ds.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedisNode
implements SingleRedisOperations {
    private RedisTemplate template;

    public RedisNode() {
    }

    public RedisNode(DataSource dataSource) {
        this.template = new RedisTemplate(new SessionFactoryImpl(dataSource));
    }

    public void setDataSource(DataSource dataSource) {
        this.template = new RedisTemplate(new SessionFactoryImpl(dataSource));
    }

    @Override
    public String ping() {
        return this.execute(new RedisCallback<String>(){

            @Override
            public String doIt(Session session) {
                return session.ping();
            }
        });
    }

    @Override
    public String randomKey() {
        return this.execute(new RedisCallback<String>(){

            @Override
            public String doIt(Session session) {
                return session.randomKey();
            }
        });
    }

    @Override
    public String set(final String key, final String value) {
        return this.execute(new RedisCallback<String>(){

            @Override
            public String doIt(Session session) {
                return session.set(key, value);
            }
        });
    }

    @Override
    public String get(final String key) {
        return this.execute(new RedisCallback<String>(){

            @Override
            public String doIt(Session session) {
                return session.get(key);
            }
        });
    }

    @Override
    public void quit() {
        this.execute(new RedisCallback<Object>(){

            @Override
            public Object doIt(Session session) {
                session.quit();
                return null;
            }
        });
    }

    @Override
    public Boolean exists(final String key) {
        return this.execute(new RedisCallback<Boolean>(){

            @Override
            public Boolean doIt(Session session) {
                return session.exists(key);
            }
        });
    }

    @Override
    public Long del(final String ... keys) {
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doIt(Session session) {
                return session.del(keys);
            }
        });
    }

    @Override
    public String type(final String key) {
        return this.execute(new RedisCallback<String>(){

            @Override
            public String doIt(Session session) {
                return session.type(key);
            }
        });
    }

    @Override
    public String flushDB() {
        return this.execute(new RedisCallback<String>(){

            @Override
            public String doIt(Session session) {
                return session.flushDB();
            }
        });
    }

    @Override
    public Set<String> keys(final String pattern) {
        return this.execute(new RedisCallback<Set<String>>(){

            @Override
            public Set<String> doIt(Session session) {
                return session.keys(pattern);
            }
        });
    }

    @Override
    public String rename(final String key, final String newKey) {
        return this.execute(new RedisCallback<String>(){

            @Override
            public String doIt(Session session) {
                return session.rename(key, newKey);
            }
        });
    }

    @Override
    public Boolean renamenx(final String key, final String newKey) {
        return this.execute(new RedisCallback<Boolean>(){

            @Override
            public Boolean doIt(Session session) {
                return session.renamenx(key, newKey);
            }
        });
    }

    @Override
    public Long dbSize() {
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doIt(Session session) {
                return session.dbSize();
            }
        });
    }

    @Override
    public Boolean expire(final String key, final int seconds) {
        return this.execute(new RedisCallback<Boolean>(){

            @Override
            public Boolean doIt(Session session) {
                return session.expire(key, seconds);
            }
        });
    }

    @Override
    public Boolean expireAt(final String key, final long unixTime) {
        return this.execute(new RedisCallback<Boolean>(){

            @Override
            public Boolean doIt(Session session) {
                return session.expireAt(key, unixTime);
            }
        });
    }

    @Override
    public Long ttl(final String key) {
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doIt(Session session) {
                return session.ttl(key);
            }
        });
    }

    @Override
    public Boolean move(final String key, final int dbIndex) {
        return this.execute(new RedisCallback<Boolean>(){

            @Override
            public Boolean doIt(Session session) {
                return session.move(key, dbIndex);
            }
        });
    }

    @Override
    public String flushAll() {
        return this.execute(new RedisCallback<String>(){

            @Override
            public String doIt(Session session) {
                return session.flushAll();
            }
        });
    }

    @Override
    public String getSet(final String key, final String value) {
        return this.execute(new RedisCallback<String>(){

            @Override
            public String doIt(Session session) {
                return session.getSet(key, value);
            }
        });
    }

    @Override
    public List<String> mget(final String ... keys) {
        return this.execute(new RedisCallback<List<String>>(){

            @Override
            public List<String> doIt(Session session) {
                return session.mget(keys);
            }
        });
    }

    @Override
    public Boolean setnx(final String key, final String value) {
        return this.execute(new RedisCallback<Boolean>(){

            @Override
            public Boolean doIt(Session session) {
                return session.setnx(key, value);
            }
        });
    }

    @Override
    public String setex(final String key, final int seconds, final String value) {
        return this.execute(new RedisCallback<String>(){

            @Override
            public String doIt(Session session) {
                return session.setex(key, seconds, value);
            }
        });
    }

    @Override
    public String mset(final String ... keysvalues) {
        return this.execute(new RedisCallback<String>(){

            @Override
            public String doIt(Session session) {
                return session.mset(keysvalues);
            }
        });
    }

    @Override
    public Boolean msetnx(final String ... keysvalues) {
        return this.execute(new RedisCallback<Boolean>(){

            @Override
            public Boolean doIt(Session session) {
                return session.msetnx(keysvalues);
            }
        });
    }

    @Override
    public Long decrBy(final String key, final int value) {
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doIt(Session session) {
                return session.decrBy(key, value);
            }
        });
    }

    @Override
    public Long decr(final String key) {
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doIt(Session session) {
                return session.decr(key);
            }
        });
    }

    @Override
    public Long incrBy(final String key, final int value) {
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doIt(Session session) {
                return session.incrBy(key, value);
            }
        });
    }

    @Override
    public Long incr(final String key) {
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doIt(Session session) {
                return session.incr(key);
            }
        });
    }

    @Override
    public Long append(final String key, final String value) {
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doIt(Session session) {
                return session.append(key, value);
            }
        });
    }

    @Override
    public String getRange(final String key, final int start, final int end) {
        return this.execute(new RedisCallback<String>(){

            @Override
            public String doIt(Session session) {
                return session.getRange(key, start, end);
            }
        });
    }

    @Override
    public Long setRange(final String key, final int offset, final String value) {
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doIt(Session session) {
                return session.setRange(key, offset, value);
            }
        });
    }

    @Override
    public Boolean hset(final String key, final String field, final String value) {
        return this.execute(new RedisCallback<Boolean>(){

            @Override
            public Boolean doIt(Session session) {
                return session.hset(key, field, value);
            }
        });
    }

    @Override
    public String hget(final String key, final String field) {
        return this.execute(new RedisCallback<String>(){

            @Override
            public String doIt(Session session) {
                return session.hget(key, field);
            }
        });
    }

    @Override
    public Boolean hsetnx(final String key, final String field, final String value) {
        return this.execute(new RedisCallback<Boolean>(){

            @Override
            public Boolean doIt(Session session) {
                return session.hsetnx(key, field, value);
            }
        });
    }

    @Override
    public String hmset(final String key, final Map<String, String> hash) {
        return this.execute(new RedisCallback<String>(){

            @Override
            public String doIt(Session session) {
                return session.hmset(key, hash);
            }
        });
    }

    @Override
    public List<String> hmget(final String key, final String ... fields) {
        return this.execute(new RedisCallback<List<String>>(){

            @Override
            public List<String> doIt(Session session) {
                return session.hmget(key, fields);
            }
        });
    }

    @Override
    public Long hincrBy(final String key, final String field, final int value) {
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doIt(Session session) {
                return session.hincrBy(key, field, value);
            }
        });
    }

    @Override
    public Boolean hexists(final String key, final String field) {
        return this.execute(new RedisCallback<Boolean>(){

            @Override
            public Boolean doIt(Session session) {
                return session.hexists(key, field);
            }
        });
    }

    @Override
    public Boolean hdel(final String key, final String field) {
        return this.execute(new RedisCallback<Boolean>(){

            @Override
            public Boolean doIt(Session session) {
                return session.hdel(key, field);
            }
        });
    }

    @Override
    public Long hlen(final String key) {
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doIt(Session session) {
                return session.hlen(key);
            }
        });
    }

    @Override
    public Set<String> hkeys(final String key) {
        return this.execute(new RedisCallback<Set<String>>(){

            @Override
            public Set<String> doIt(Session session) {
                return session.hkeys(key);
            }
        });
    }

    @Override
    public List<String> hvals(final String key) {
        return this.execute(new RedisCallback<List<String>>(){

            @Override
            public List<String> doIt(Session session) {
                return session.hvals(key);
            }
        });
    }

    @Override
    public Map<String, String> hgetAll(final String key) {
        return this.execute(new RedisCallback<Map<String, String>>(){

            @Override
            public Map<String, String> doIt(Session session) {
                return session.hgetAll(key);
            }
        });
    }

    @Override
    public Long rpush(final String key, final String value) {
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doIt(Session session) {
                return session.rpush(key, value);
            }
        });
    }

    @Override
    public Long lpush(final String key, final String value) {
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doIt(Session session) {
                return session.lpush(key, value);
            }
        });
    }

    @Override
    public Long llen(final String key) {
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doIt(Session session) {
                return session.llen(key);
            }
        });
    }

    @Override
    public List<String> lrange(final String key, final int start, final int end) {
        return this.execute(new RedisCallback<List<String>>(){

            @Override
            public List<String> doIt(Session session) {
                return session.lrange(key, start, end);
            }
        });
    }

    @Override
    public String ltrim(final String key, final int start, final int end) {
        return this.execute(new RedisCallback<String>(){

            @Override
            public String doIt(Session session) {
                return session.ltrim(key, start, end);
            }
        });
    }

    @Override
    public String lindex(final String key, final int index) {
        return this.execute(new RedisCallback<String>(){

            @Override
            public String doIt(Session session) {
                return session.lindex(key, index);
            }
        });
    }

    @Override
    public String lset(final String key, final int index, final String value) {
        return this.execute(new RedisCallback<String>(){

            @Override
            public String doIt(Session session) {
                return session.lset(key, index, value);
            }
        });
    }

    @Override
    public Long lrem(final String key, final int count, final String value) {
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doIt(Session session) {
                return session.lrem(key, count, value);
            }
        });
    }

    @Override
    public String lpop(final String key) {
        return this.execute(new RedisCallback<String>(){

            @Override
            public String doIt(Session session) {
                return session.lpop(key);
            }
        });
    }

    @Override
    public String rpop(final String key) {
        return this.execute(new RedisCallback<String>(){

            @Override
            public String doIt(Session session) {
                return session.rpop(key);
            }
        });
    }

    @Override
    public String rpoplpush(final String srckey, final String dstkey) {
        return this.execute(new RedisCallback<String>(){

            @Override
            public String doIt(Session session) {
                return session.rpoplpush(srckey, dstkey);
            }
        });
    }

    @Override
    public String brpoplpush(final String source, final String destination, final int timeout) {
        return this.execute(new RedisCallback<String>(){

            @Override
            public String doIt(Session session) {
                return session.brpoplpush(source, destination, timeout);
            }
        });
    }

    @Override
    public Boolean sadd(final String key, final String member) {
        return this.execute(new RedisCallback<Boolean>(){

            @Override
            public Boolean doIt(Session session) {
                return session.sadd(key, member);
            }
        });
    }

    @Override
    public Set<String> smembers(final String key) {
        return this.execute(new RedisCallback<Set<String>>(){

            @Override
            public Set<String> doIt(Session session) {
                return session.smembers(key);
            }
        });
    }

    @Override
    public Boolean srem(final String key, final String member) {
        return this.execute(new RedisCallback<Boolean>(){

            @Override
            public Boolean doIt(Session session) {
                return session.srem(key, member);
            }
        });
    }

    @Override
    public String spop(final String key) {
        return this.execute(new RedisCallback<String>(){

            @Override
            public String doIt(Session session) {
                return session.spop(key);
            }
        });
    }

    @Override
    public Boolean smove(final String srckey, final String dstkey, final String member) {
        return this.execute(new RedisCallback<Boolean>(){

            @Override
            public Boolean doIt(Session session) {
                return session.smove(srckey, dstkey, member);
            }
        });
    }

    @Override
    public Long scard(final String key) {
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doIt(Session session) {
                return session.scard(key);
            }
        });
    }

    @Override
    public Boolean sismember(final String key, final String member) {
        return this.execute(new RedisCallback<Boolean>(){

            @Override
            public Boolean doIt(Session session) {
                return session.sismember(key, member);
            }
        });
    }

    @Override
    public Set<String> sinter(final String ... keys) {
        return this.execute(new RedisCallback<Set<String>>(){

            @Override
            public Set<String> doIt(Session session) {
                return session.sinter(keys);
            }
        });
    }

    @Override
    public Long sinterstore(final String dstkey, final String ... keys) {
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doIt(Session session) {
                return session.sinterstore(dstkey, keys);
            }
        });
    }

    @Override
    public Set<String> sunion(final String ... keys) {
        return this.execute(new RedisCallback<Set<String>>(){

            @Override
            public Set<String> doIt(Session session) {
                return session.sunion(keys);
            }
        });
    }

    @Override
    public Long sunionstore(final String dstkey, final String ... keys) {
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doIt(Session session) {
                return session.sunionstore(dstkey, keys);
            }
        });
    }

    @Override
    public Set<String> sdiff(final String ... keys) {
        return this.execute(new RedisCallback<Set<String>>(){

            @Override
            public Set<String> doIt(Session session) {
                return session.sdiff(keys);
            }
        });
    }

    @Override
    public Long sdiffstore(final String dstkey, final String ... keys) {
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doIt(Session session) {
                return session.sdiffstore(dstkey, keys);
            }
        });
    }

    @Override
    public String srandmember(final String key) {
        return this.execute(new RedisCallback<String>(){

            @Override
            public String doIt(Session session) {
                return session.srandmember(key);
            }
        });
    }

    @Override
    public Boolean zadd(final String key, final Number score, final String member) {
        return this.execute(new RedisCallback<Boolean>(){

            @Override
            public Boolean doIt(Session session) {
                return session.zadd(key, score, member);
            }
        });
    }

    @Override
    public List<String> zrange(final String key, final int start, final int end) {
        return this.execute(new RedisCallback<List<String>>(){

            @Override
            public List<String> doIt(Session session) {
                return session.zrange(key, start, end);
            }
        });
    }

    @Override
    public Boolean zrem(final String key, final String member) {
        return this.execute(new RedisCallback<Boolean>(){

            @Override
            public Boolean doIt(Session session) {
                return session.zrem(key, member);
            }
        });
    }

    @Override
    public String zincrby(final String key, final Number score, final String member) {
        return this.execute(new RedisCallback<String>(){

            @Override
            public String doIt(Session session) {
                return session.zincrby(key, score, member);
            }
        });
    }

    @Override
    public Long zrank(final String key, final String member) {
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doIt(Session session) {
                return session.zrank(key, member);
            }
        });
    }

    @Override
    public Long zrevrank(final String key, final String member) {
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doIt(Session session) {
                return session.zrevrank(key, member);
            }
        });
    }

    @Override
    public List<String> zrevrange(final String key, final int start, final int end) {
        return this.execute(new RedisCallback<List<String>>(){

            @Override
            public List<String> doIt(Session session) {
                return session.zrevrange(key, start, end);
            }
        });
    }

    @Override
    public List<ElementScore> zrangeWithScores(final String key, final int start, final int end) {
        return this.execute(new RedisCallback<List<ElementScore>>(){

            @Override
            public List<ElementScore> doIt(Session session) {
                return session.zrangeWithScores(key, start, end);
            }
        });
    }

    @Override
    public List<ElementScore> zrevrangeWithScores(final String key, final int start, final int end) {
        return this.execute(new RedisCallback<List<ElementScore>>(){

            @Override
            public List<ElementScore> doIt(Session session) {
                return session.zrevrangeWithScores(key, start, end);
            }
        });
    }

    @Override
    public List<String> zrevrangeByScore(final String key, final String max, final String min) {
        return this.execute(new RedisCallback<List<String>>(){

            @Override
            public List<String> doIt(Session session) {
                return session.zrevrangeByScore(key, max, min);
            }
        });
    }

    @Override
    public List<String> zrevrangeByScore(final String key, final String max, final String min, final int offset, final int count) {
        return this.execute(new RedisCallback<List<String>>(){

            @Override
            public List<String> doIt(Session session) {
                return session.zrevrangeByScore(key, max, min, offset, count);
            }
        });
    }

    @Override
    public List<ElementScore> zrevrangeByScoreWithScores(final String key, final String max, final String min) {
        return this.execute(new RedisCallback<List<ElementScore>>(){

            @Override
            public List<ElementScore> doIt(Session session) {
                return session.zrevrangeByScoreWithScores(key, max, min);
            }
        });
    }

    @Override
    public List<ElementScore> zrevrangeByScoreWithScores(final String key, final String max, final String min, final int offset, final int count) {
        return this.execute(new RedisCallback<List<ElementScore>>(){

            @Override
            public List<ElementScore> doIt(Session session) {
                return session.zrevrangeByScoreWithScores(key, max, min, offset, count);
            }
        });
    }

    @Override
    public Long zcard(final String key) {
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doIt(Session session) {
                return session.zcard(key);
            }
        });
    }

    @Override
    public String zscore(final String key, final String member) {
        return this.execute(new RedisCallback<String>(){

            @Override
            public String doIt(Session session) {
                return session.zscore(key, member);
            }
        });
    }

    @Override
    public List<String> sort(final String key) {
        return this.execute(new RedisCallback<List<String>>(){

            @Override
            public List<String> doIt(Session session) {
                return session.sort(key);
            }
        });
    }

    @Override
    public List<String> sort(final String key, final SortingParams sortingParameters) {
        return this.execute(new RedisCallback<List<String>>(){

            @Override
            public List<String> doIt(Session session) {
                return session.sort(key, sortingParameters);
            }
        });
    }

    @Override
    public List<String> blpop(final int timeout, final String ... keys) {
        return this.execute(new RedisCallback<List<String>>(){

            @Override
            public List<String> doIt(Session session) {
                return session.blpop(timeout, keys);
            }
        });
    }

    @Override
    public Long sort(final String key, final SortingParams sortingParameters, final String dstkey) {
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doIt(Session session) {
                return session.sort(key, sortingParameters, dstkey);
            }
        });
    }

    @Override
    public Long sort(final String key, final String dstkey) {
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doIt(Session session) {
                return session.sort(key, dstkey);
            }
        });
    }

    @Override
    public List<String> brpop(final int timeout, final String ... keys) {
        return this.execute(new RedisCallback<List<String>>(){

            @Override
            public List<String> doIt(Session session) {
                return session.brpop(timeout, keys);
            }
        });
    }

    @Override
    public String auth(final String password) {
        return this.execute(new RedisCallback<String>(){

            @Override
            public String doIt(Session session) {
                return session.auth(password);
            }
        });
    }

    @Override
    public List<Object> pipeline(final Pipeline pipeline) {
        return this.execute(new RedisCallback<List<Object>>(){

            @Override
            public List<Object> doIt(Session session) {
                return session.pipeline(pipeline);
            }
        });
    }

    @Override
    public Long publish(final String channel, final String message) {
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doIt(Session session) {
                return session.publish(channel, message);
            }
        });
    }

    @Override
    public Long getBit(final String key, final int offset) {
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doIt(Session session) {
                return session.getBit(key, offset);
            }
        });
    }

    @Override
    public Long setBit(final String key, final int offset, final String value) {
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doIt(Session session) {
                return session.setBit(key, offset, value);
            }
        });
    }

    @Override
    public Long zcount(final String key, final Number min, final Number max) {
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doIt(Session session) {
                return session.zcount(key, min, max);
            }
        });
    }

    @Override
    public List<String> zrangeByScore(final String key, final String min, final String max) {
        return this.execute(new RedisCallback<List<String>>(){

            @Override
            public List<String> doIt(Session session) {
                return session.zrangeByScore(key, min, max);
            }
        });
    }

    @Override
    public List<String> zrangeByScore(final String key, final String min, final String max, final int offset, final int count) {
        return this.execute(new RedisCallback<List<String>>(){

            @Override
            public List<String> doIt(Session session) {
                return session.zrangeByScore(key, min, max, offset, count);
            }
        });
    }

    @Override
    public List<ElementScore> zrangeByScoreWithScores(final String key, final String min, final String max) {
        return this.execute(new RedisCallback<List<ElementScore>>(){

            @Override
            public List<ElementScore> doIt(Session session) {
                return session.zrangeByScoreWithScores(key, min, max);
            }
        });
    }

    @Override
    public List<ElementScore> zrangeByScoreWithScores(final String key, final String min, final String max, final int offset, final int count) {
        return this.execute(new RedisCallback<List<ElementScore>>(){

            @Override
            public List<ElementScore> doIt(Session session) {
                return session.zrangeByScoreWithScores(key, min, max, offset, count);
            }
        });
    }

    @Override
    public Long zremrangeByRank(final String key, final int start, final int end) {
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doIt(Session session) {
                return session.zremrangeByRank(key, start, end);
            }
        });
    }

    @Override
    public Long zremrangeByScore(final String key, final String min, final String max) {
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doIt(Session session) {
                return session.zremrangeByScore(key, min, max);
            }
        });
    }

    @Override
    public Long zunionstore(final String dstkey, final String ... sets) {
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doIt(Session session) {
                return session.zunionstore(dstkey, sets);
            }
        });
    }

    @Override
    public Long zunionstore(final String dstkey, final ZParams params, final String ... sets) {
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doIt(Session session) {
                return session.zunionstore(dstkey, params, sets);
            }
        });
    }

    @Override
    public Long zinterstore(final String dstkey, final String ... sets) {
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doIt(Session session) {
                return session.zinterstore(dstkey, sets);
            }
        });
    }

    @Override
    public Long zinterstore(final String dstkey, final ZParams params, final String ... sets) {
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doIt(Session session) {
                return session.zinterstore(dstkey, params, sets);
            }
        });
    }

    @Override
    public String save() {
        return this.execute(new RedisCallback<String>(){

            @Override
            public String doIt(Session session) {
                return session.save();
            }
        });
    }

    @Override
    public String bgsave() {
        return this.execute(new RedisCallback<String>(){

            @Override
            public String doIt(Session session) {
                return session.bgsave();
            }
        });
    }

    @Override
    public String bgrewriteaof() {
        return this.execute(new RedisCallback<String>(){

            @Override
            public String doIt(Session session) {
                return session.bgrewriteaof();
            }
        });
    }

    @Override
    public Long lastsave() {
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doIt(Session session) {
                return session.lastsave();
            }
        });
    }

    @Override
    public String shutdown() {
        return this.execute(new RedisCallback<String>(){

            @Override
            public String doIt(Session session) {
                return session.shutdown();
            }
        });
    }

    @Override
    public String info() {
        return this.execute(new RedisCallback<String>(){

            @Override
            public String doIt(Session session) {
                return session.info();
            }
        });
    }

    @Override
    public void monitor(final RedisMonitor redisMonitor) {
        this.execute(new RedisCallback<String>(){

            @Override
            public String doIt(Session session) {
                session.monitor(redisMonitor);
                return null;
            }
        });
    }

    @Override
    public String slaveof(final String host, final int port) {
        return this.execute(new RedisCallback<String>(){

            @Override
            public String doIt(Session session) {
                return session.slaveof(host, port);
            }
        });
    }

    @Override
    public String slaveofNoOne() {
        return this.execute(new RedisCallback<String>(){

            @Override
            public String doIt(Session session) {
                return session.slaveofNoOne();
            }
        });
    }

    @Override
    public List<String> configGet(final String pattern) {
        return this.execute(new RedisCallback<List<String>>(){

            @Override
            public List<String> doIt(Session session) {
                return session.configGet(pattern);
            }
        });
    }

    @Override
    public String configSet(final String parameter, final String value) {
        return this.execute(new RedisCallback<String>(){

            @Override
            public String doIt(Session session) {
                return session.configSet(parameter, value);
            }
        });
    }

    @Override
    public Long strlen(final String key) {
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doIt(Session session) {
                return session.strlen(key);
            }
        });
    }

    @Override
    public void sync() {
        this.execute(new RedisCallback<String>(){

            @Override
            public String doIt(Session session) {
                session.sync();
                return null;
            }
        });
    }

    @Override
    public Long lpushx(final String key, final String value) {
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doIt(Session session) {
                return session.lpushx(key, value);
            }
        });
    }

    @Override
    public Boolean persist(final String key) {
        return this.execute(new RedisCallback<Boolean>(){

            @Override
            public Boolean doIt(Session session) {
                return session.persist(key);
            }
        });
    }

    @Override
    public Long rpushx(final String key, final String value) {
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doIt(Session session) {
                return session.rpushx(key, value);
            }
        });
    }

    @Override
    public String echo(final String string) {
        return this.execute(new RedisCallback<String>(){

            @Override
            public String doIt(Session session) {
                return session.echo(string);
            }
        });
    }

    @Override
    public Long linsert(final String key, final ListPosition where, final String pivot, final String value) {
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doIt(Session session) {
                return session.linsert(key, where, pivot, value);
            }
        });
    }

    @Override
    public String debug(final DebugParams params) {
        return this.execute(new RedisCallback<String>(){

            @Override
            public String doIt(Session session) {
                return session.debug(params);
            }
        });
    }

    private <R> R execute(RedisCallback<R> cmd) {
        return this.template.execute(cmd);
    }
}

