/*
 * Decompiled with CFR 0.152.
 */
package org.idevlab.rjc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.idevlab.rjc.DebugParams;
import org.idevlab.rjc.ElementScore;
import org.idevlab.rjc.ListPosition;
import org.idevlab.rjc.Pipeline;
import org.idevlab.rjc.RedisClient;
import org.idevlab.rjc.RedisClientImpl;
import org.idevlab.rjc.RedisException;
import org.idevlab.rjc.RedisMonitor;
import org.idevlab.rjc.Session;
import org.idevlab.rjc.SortingParams;
import org.idevlab.rjc.ZParams;
import org.idevlab.rjc.ds.RedisConnection;
import org.idevlab.rjc.protocol.RedisCommand;
import org.idevlab.rjc.protocol.RedisKeyword;
import org.idevlab.rjc.util.KeyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedisSessionImpl
implements Session {
    private final RedisClientImpl client;

    public RedisSessionImpl(RedisConnection connection) {
        this.client = new RedisClientImpl(connection);
    }

    @Override
    public String set(String key, String value) {
        return this.client.getStatusReply(RedisCommand.SET, key, value);
    }

    @Override
    public String get(String key) {
        return this.client.getBulkReply(RedisCommand.GET, key);
    }

    @Override
    public void quit() {
        this.client.noReply(RedisCommand.QUIT);
    }

    @Override
    public Boolean exists(String key) {
        return this.integerReplayToBoolean(this.client.getIntegerReply(RedisCommand.EXISTS, key));
    }

    @Override
    public Long del(String ... keys) {
        return this.client.getIntegerReply(RedisCommand.DEL, keys);
    }

    @Override
    public String type(String key) {
        return this.client.getStatusReply(RedisCommand.TYPE, key);
    }

    @Override
    public String flushDB() {
        return this.client.getStatusReply(RedisCommand.FLUSHDB);
    }

    @Override
    public Set<String> keys(String pattern) {
        return new HashSet<String>(this.client.getStringMultiBulkReply(RedisCommand.KEYS, pattern));
    }

    @Override
    public String randomKey() {
        return this.client.getBulkReply(RedisCommand.RANDOMKEY);
    }

    @Override
    public String rename(String key, String newKey) {
        return this.client.getStatusReply(RedisCommand.RENAME, key, newKey);
    }

    @Override
    public Boolean renamenx(String key, String newKey) {
        return this.integerReplayToBoolean(this.client.getIntegerReply(RedisCommand.RENAMENX, key, newKey));
    }

    @Override
    public Long dbSize() {
        return this.client.getIntegerReply(RedisCommand.DBSIZE);
    }

    @Override
    public Boolean expire(String key, int seconds) {
        return this.integerReplayToBoolean(this.client.getIntegerReply(RedisCommand.EXPIRE, key, String.valueOf(seconds)));
    }

    @Override
    public Boolean expireAt(String key, long unixTime) {
        return this.integerReplayToBoolean(this.client.getIntegerReply(RedisCommand.EXPIREAT, key, String.valueOf(unixTime)));
    }

    @Override
    public Long ttl(String key) {
        return this.client.getIntegerReply(RedisCommand.TTL, key);
    }

    @Override
    public String select(int index) {
        return this.client.getStatusReply(RedisCommand.SELECT, String.valueOf(index));
    }

    @Override
    public Boolean move(String key, int dbIndex) {
        return this.integerReplayToBoolean(this.client.getIntegerReply(RedisCommand.MOVE, key, String.valueOf(dbIndex)));
    }

    @Override
    public String flushAll() {
        return this.client.getStatusReply(RedisCommand.FLUSHALL);
    }

    @Override
    public String getSet(String key, String value) {
        return this.client.getBulkReply(RedisCommand.GETSET, key, value);
    }

    @Override
    public List<String> mget(String ... keys) {
        return this.client.getStringMultiBulkReply(RedisCommand.MGET, keys);
    }

    @Override
    public Boolean setnx(String key, String value) {
        return this.integerReplayToBoolean(this.client.getIntegerReply(RedisCommand.SETNX, key, value));
    }

    @Override
    public String setex(String key, int seconds, String value) {
        return this.client.getStatusReply(RedisCommand.SETEX, key, String.valueOf(seconds), value);
    }

    @Override
    public String mset(String ... keysvalues) {
        return this.client.getStatusReply(RedisCommand.MSET, keysvalues);
    }

    @Override
    public Boolean msetnx(String ... keysvalues) {
        return this.integerReplayToBoolean(this.client.getIntegerReply(RedisCommand.MSETNX, keysvalues));
    }

    @Override
    public Long decrBy(String key, int value) {
        return this.client.getIntegerReply(RedisCommand.DECRBY, key, String.valueOf(value));
    }

    @Override
    public Long decr(String key) {
        return this.client.getIntegerReply(RedisCommand.DECR, key);
    }

    @Override
    public Long incrBy(String key, int value) {
        return this.client.getIntegerReply(RedisCommand.INCRBY, key, String.valueOf(value));
    }

    @Override
    public Long incr(String key) {
        return this.client.getIntegerReply(RedisCommand.INCR, key);
    }

    @Override
    public Long append(String key, String value) {
        return this.client.getIntegerReply(RedisCommand.APPEND, key, value);
    }

    @Override
    public String getRange(String key, int start, int end) {
        return this.client.getBulkReply(RedisCommand.GETRANGE, key, String.valueOf(start), String.valueOf(end));
    }

    @Override
    public Long setRange(String key, int offset, String value) {
        return this.client.getIntegerReply(RedisCommand.SETRANGE, key, String.valueOf(offset), value);
    }

    @Override
    public Boolean hset(String key, String field, String value) {
        return this.integerReplayToBoolean(this.client.getIntegerReply(RedisCommand.HSET, key, field, value));
    }

    @Override
    public String hget(String key, String field) {
        return this.client.getBulkReply(RedisCommand.HGET, key, field);
    }

    @Override
    public Boolean hsetnx(String key, String field, String value) {
        return this.integerReplayToBoolean(this.client.getIntegerReply(RedisCommand.HSETNX, key, field, value));
    }

    @Override
    public String hmset(String key, Map<String, String> hash) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(key);
        for (String field : hash.keySet()) {
            params.add(field);
            params.add(hash.get(field));
        }
        String[] args = params.toArray(new String[params.size()]);
        return this.client.getStatusReply(RedisCommand.HMSET, args);
    }

    @Override
    public List<String> hmget(String key, String ... fields) {
        String[] params = new String[fields.length + 1];
        params[0] = key;
        System.arraycopy(fields, 0, params, 1, fields.length);
        return this.client.getStringMultiBulkReply(RedisCommand.HMGET, params);
    }

    @Override
    public Long hincrBy(String key, String field, int value) {
        return this.client.getIntegerReply(RedisCommand.HINCRBY, key, field, String.valueOf(value));
    }

    @Override
    public Boolean hexists(String key, String field) {
        return this.integerReplayToBoolean(this.client.getIntegerReply(RedisCommand.HEXISTS, key, field));
    }

    @Override
    public Boolean hdel(String key, String field) {
        return this.integerReplayToBoolean(this.client.getIntegerReply(RedisCommand.HDEL, key, field));
    }

    @Override
    public Long hlen(String key) {
        return this.client.getIntegerReply(RedisCommand.HLEN, key);
    }

    @Override
    public Set<String> hkeys(String key) {
        return new HashSet<String>(this.client.getStringMultiBulkReply(RedisCommand.HKEYS, key));
    }

    @Override
    public List<String> hvals(String key) {
        return this.client.getStringMultiBulkReply(RedisCommand.HVALS, key);
    }

    @Override
    public Map<String, String> hgetAll(String key) {
        List<String> flatHash = this.client.getStringMultiBulkReply(RedisCommand.HGETALL, key);
        HashMap<String, String> hash = new HashMap<String, String>();
        Iterator<String> iterator = flatHash.iterator();
        while (iterator.hasNext()) {
            hash.put(iterator.next(), iterator.next());
        }
        return hash;
    }

    @Override
    public Long rpush(String key, String value) {
        return this.client.getIntegerReply(RedisCommand.RPUSH, key, value);
    }

    @Override
    public Long lpush(String key, String value) {
        return this.client.getIntegerReply(RedisCommand.LPUSH, key, value);
    }

    @Override
    public Long llen(String key) {
        return this.client.getIntegerReply(RedisCommand.LLEN, key);
    }

    @Override
    public List<String> lrange(String key, int start, int end) {
        return this.client.getStringMultiBulkReply(RedisCommand.LRANGE, key, String.valueOf(start), String.valueOf(end));
    }

    @Override
    public String ltrim(String key, int start, int end) {
        return this.client.getStatusReply(RedisCommand.LTRIM, key, String.valueOf(start), String.valueOf(end));
    }

    @Override
    public String lindex(String key, int index) {
        return this.client.getBulkReply(RedisCommand.LINDEX, key, String.valueOf(index));
    }

    @Override
    public String lset(String key, int index, String value) {
        return this.client.getStatusReply(RedisCommand.LSET, key, String.valueOf(index), value);
    }

    @Override
    public Long lrem(String key, int count, String value) {
        return this.client.getIntegerReply(RedisCommand.LREM, key, String.valueOf(count), value);
    }

    @Override
    public String lpop(String key) {
        return this.client.getBulkReply(RedisCommand.LPOP, key);
    }

    @Override
    public String rpop(String key) {
        return this.client.getBulkReply(RedisCommand.RPOP, key);
    }

    @Override
    public String rpoplpush(String srckey, String dstkey) {
        return this.client.getBulkReply(RedisCommand.RPOPLPUSH, srckey, dstkey);
    }

    @Override
    public Boolean sadd(String key, String member) {
        return this.integerReplayToBoolean(this.client.getIntegerReply(RedisCommand.SADD, key, member));
    }

    @Override
    public Set<String> smembers(String key) {
        return new LinkedHashSet<String>(this.client.getStringMultiBulkReply(RedisCommand.SMEMBERS, key));
    }

    @Override
    public Boolean srem(String key, String member) {
        return this.integerReplayToBoolean(this.client.getIntegerReply(RedisCommand.SREM, key, member));
    }

    @Override
    public String spop(String key) {
        return this.client.getBulkReply(RedisCommand.SPOP, key);
    }

    @Override
    public Boolean smove(String srckey, String dstkey, String member) {
        return this.integerReplayToBoolean(this.client.getIntegerReply(RedisCommand.SMOVE, srckey, dstkey, member));
    }

    @Override
    public Long scard(String key) {
        return this.client.getIntegerReply(RedisCommand.SCARD, key);
    }

    @Override
    public Boolean sismember(String key, String member) {
        return this.integerReplayToBoolean(this.client.getIntegerReply(RedisCommand.SISMEMBER, key, member));
    }

    @Override
    public Set<String> sinter(String ... keys) {
        return new LinkedHashSet<String>(this.client.getStringMultiBulkReply(RedisCommand.SINTER, keys));
    }

    @Override
    public Long sinterstore(String dstkey, String ... keys) {
        return this.client.getIntegerReply(RedisCommand.SINTERSTORE, KeyUtil.joinParams(dstkey, keys));
    }

    @Override
    public Set<String> sunion(String ... keys) {
        return new LinkedHashSet<String>(this.client.getStringMultiBulkReply(RedisCommand.SUNION, keys));
    }

    @Override
    public Long sunionstore(String dstkey, String ... keys) {
        return this.client.getIntegerReply(RedisCommand.SUNIONSTORE, KeyUtil.joinParams(dstkey, keys));
    }

    @Override
    public Set<String> sdiff(String ... keys) {
        return new LinkedHashSet<String>(this.client.getStringMultiBulkReply(RedisCommand.SDIFF, keys));
    }

    @Override
    public Long sdiffstore(String dstkey, String ... keys) {
        return this.client.getIntegerReply(RedisCommand.SDIFFSTORE, KeyUtil.joinParams(dstkey, keys));
    }

    @Override
    public String srandmember(String key) {
        return this.client.getBulkReply(RedisCommand.SRANDMEMBER, key);
    }

    @Override
    public Boolean zadd(String key, Number score, String member) {
        return this.integerReplayToBoolean(this.client.getIntegerReply(RedisCommand.ZADD, key, String.valueOf(score), member));
    }

    @Override
    public List<String> zrange(String key, int start, int end) {
        return this.client.getStringMultiBulkReply(RedisCommand.ZRANGE, key, String.valueOf(start), String.valueOf(end));
    }

    @Override
    public Boolean zrem(String key, String member) {
        return this.integerReplayToBoolean(this.client.getIntegerReply(RedisCommand.ZREM, key, member));
    }

    @Override
    public Long zrank(String key, String member) {
        return this.client.getIntegerReply(RedisCommand.ZRANK, key, member);
    }

    @Override
    public Long zrevrank(String key, String member) {
        return this.client.getIntegerReply(RedisCommand.ZREVRANK, key, member);
    }

    @Override
    public List<String> zrevrange(String key, int start, int end) {
        return this.client.getStringMultiBulkReply(RedisCommand.ZREVRANGE, key, String.valueOf(start), String.valueOf(end));
    }

    @Override
    public List<ElementScore> zrangeWithScores(String key, int start, int end) {
        return this.getReplyAsElementScoreSet(this.client.getStringMultiBulkReply(RedisCommand.ZRANGE, key, String.valueOf(start), String.valueOf(end), RedisKeyword.WITHSCORES.str));
    }

    @Override
    public List<ElementScore> zrevrangeWithScores(String key, int start, int end) {
        return this.getReplyAsElementScoreSet(this.client.getStringMultiBulkReply(RedisCommand.ZREVRANGE, key, String.valueOf(start), String.valueOf(end), RedisKeyword.WITHSCORES.str));
    }

    @Override
    public List<String> zrevrangeByScore(String key, String max, String min) {
        return this.client.getStringMultiBulkReply(RedisCommand.ZREVRANGEBYSCORE, key, max, min);
    }

    @Override
    public List<String> zrevrangeByScore(String key, String max, String min, int offset, int count) {
        return this.client.getStringMultiBulkReply(RedisCommand.ZREVRANGEBYSCORE, key, max, min, RedisKeyword.LIMIT.str, String.valueOf(offset), String.valueOf(count));
    }

    @Override
    public List<ElementScore> zrevrangeByScoreWithScores(String key, String max, String min) {
        return this.getReplyAsElementScoreSet(this.client.getStringMultiBulkReply(RedisCommand.ZREVRANGEBYSCORE, key, max, min, RedisKeyword.WITHSCORES.str));
    }

    @Override
    public List<ElementScore> zrevrangeByScoreWithScores(String key, String max, String min, int offset, int count) {
        return this.getReplyAsElementScoreSet(this.client.getStringMultiBulkReply(RedisCommand.ZREVRANGEBYSCORE, key, max, min, RedisKeyword.LIMIT.str, String.valueOf(offset), String.valueOf(count), RedisKeyword.WITHSCORES.str));
    }

    @Override
    public Long zcard(String key) {
        return this.client.getIntegerReply(RedisCommand.ZCARD, key);
    }

    @Override
    public String zscore(String key, String member) {
        return this.client.getBulkReply(RedisCommand.ZSCORE, key, member);
    }

    @Override
    public String watch(String ... keys) {
        return this.client.getStatusReply(RedisCommand.WATCH, keys);
    }

    @Override
    public String unwatch() {
        return this.client.getStatusReply(RedisCommand.UNWATCH);
    }

    @Override
    public List<Object> exec() {
        return this.client.getMultiBulkReply(RedisCommand.EXEC);
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public List<String> sort(String key) {
        return this.client.getStringMultiBulkReply(RedisCommand.SORT, key);
    }

    @Override
    public List<String> sort(String key, SortingParams sortingParameters) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(key);
        args.addAll(sortingParameters.getParams());
        String[] args1 = args.toArray(new String[args.size()]);
        return this.client.getStringMultiBulkReply(RedisCommand.SORT, args1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> blpop(int timeout, String ... keys) {
        List<String> result;
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(Arrays.asList(keys));
        args.add(String.valueOf(timeout));
        this.client.setTimeoutInfinite();
        try {
            result = this.client.getStringMultiBulkReply(RedisCommand.BLPOP, args.toArray(new String[args.size()]));
        }
        finally {
            this.client.rollbackTimeout();
        }
        return result;
    }

    @Override
    public Long sort(String key, SortingParams sortingParameters, String dstkey) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(key);
        args.addAll(sortingParameters.getParams());
        args.add(RedisKeyword.STORE.str);
        args.add(dstkey);
        String[] args1 = args.toArray(new String[args.size()]);
        return this.client.getIntegerReply(RedisCommand.SORT, args1);
    }

    @Override
    public Long sort(String key, String dstkey) {
        return this.client.getIntegerReply(RedisCommand.SORT, key, RedisKeyword.STORE.str, dstkey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> brpop(int timeout, String ... keys) {
        List<String> result;
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(Arrays.asList(keys));
        args.add(String.valueOf(timeout));
        this.client.setTimeoutInfinite();
        try {
            result = this.client.getStringMultiBulkReply(RedisCommand.BRPOP, args.toArray(new String[args.size()]));
        }
        finally {
            this.client.rollbackTimeout();
        }
        return result;
    }

    @Override
    public String auth(String password) {
        return this.client.getStatusReply(RedisCommand.AUTH, password);
    }

    @Override
    public Long publish(String channel, String message) {
        return this.client.getIntegerReply(RedisCommand.PUBLISH, channel, message);
    }

    @Override
    public Long zcount(String key, Number min, Number max) {
        return this.client.getIntegerReply(RedisCommand.ZCOUNT, key, String.valueOf(min), String.valueOf(max));
    }

    @Override
    public List<String> zrangeByScore(String key, String min, String max) {
        return this.client.getStringMultiBulkReply(RedisCommand.ZRANGEBYSCORE, key, min, max);
    }

    @Override
    public List<String> zrangeByScore(String key, String min, String max, int offset, int count) {
        return this.client.getStringMultiBulkReply(RedisCommand.ZRANGEBYSCORE, key, min, max, RedisKeyword.LIMIT.str, String.valueOf(offset), String.valueOf(count));
    }

    @Override
    public List<ElementScore> zrangeByScoreWithScores(String key, String min, String max) {
        return this.getReplyAsElementScoreSet(this.client.getStringMultiBulkReply(RedisCommand.ZRANGEBYSCORE, key, min, max, RedisKeyword.WITHSCORES.str));
    }

    @Override
    public List<ElementScore> zrangeByScoreWithScores(String key, String min, String max, int offset, int count) {
        return this.getReplyAsElementScoreSet(this.client.getStringMultiBulkReply(RedisCommand.ZRANGEBYSCORE, key, min, max, RedisKeyword.LIMIT.str, String.valueOf(offset), String.valueOf(count), RedisKeyword.WITHSCORES.str));
    }

    @Override
    public Long zremrangeByRank(String key, int start, int end) {
        return this.client.getIntegerReply(RedisCommand.ZREMRANGEBYRANK, key, String.valueOf(start), String.valueOf(end));
    }

    @Override
    public Long zunionstore(String dstkey, String ... sets) {
        String[] params = new String[sets.length + 2];
        params[0] = dstkey;
        params[1] = String.valueOf(sets.length);
        System.arraycopy(sets, 0, params, 2, sets.length);
        return this.client.getIntegerReply(RedisCommand.ZUNIONSTORE, params);
    }

    @Override
    public Long zunionstore(String dstkey, ZParams params, String ... sets) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(dstkey);
        args.add(String.valueOf(sets.length));
        args.addAll(Arrays.asList(sets));
        args.addAll(params.getParams());
        String[] args1 = args.toArray(new String[args.size()]);
        return this.client.getIntegerReply(RedisCommand.ZUNIONSTORE, args1);
    }

    @Override
    public Long zinterstore(String dstkey, String ... sets) {
        String[] params = new String[sets.length + 2];
        params[0] = dstkey;
        params[1] = String.valueOf(sets.length);
        System.arraycopy(sets, 0, params, 2, sets.length);
        return this.client.getIntegerReply(RedisCommand.ZINTERSTORE, params);
    }

    @Override
    public Long zinterstore(String dstkey, ZParams params, String ... sets) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(dstkey);
        args.add(String.valueOf(sets.length));
        args.addAll(Arrays.asList(sets));
        args.addAll(params.getParams());
        String[] args1 = args.toArray(new String[args.size()]);
        return this.client.getIntegerReply(RedisCommand.ZINTERSTORE, args1);
    }

    @Override
    public Long strlen(String key) {
        return this.client.getIntegerReply(RedisCommand.STRLEN, key);
    }

    @Override
    public Long lpushx(String key, String value) {
        return this.client.getIntegerReply(RedisCommand.LPUSHX, key, value);
    }

    @Override
    public Boolean persist(String key) {
        return this.integerReplayToBoolean(this.client.getIntegerReply(RedisCommand.PERSIST, key));
    }

    @Override
    public Long rpushx(String key, String value) {
        return this.client.getIntegerReply(RedisCommand.RPUSHX, key, value);
    }

    @Override
    public String echo(String string) {
        return this.client.getBulkReply(RedisCommand.ECHO, string);
    }

    @Override
    public Long linsert(String key, ListPosition where, String pivot, String value) {
        return this.client.getIntegerReply(RedisCommand.LINSERT, key, where.name(), pivot, value);
    }

    @Override
    public String brpoplpush(String source, String destination, int timeout) {
        return this.client.getBulkReply(RedisCommand.BRPOPLPUSH, source, destination, String.valueOf(timeout));
    }

    @Override
    public Long setBit(String key, int offset, String value) {
        return this.client.getIntegerReply(RedisCommand.SETBIT, key, String.valueOf(offset), value);
    }

    @Override
    public Long getBit(String key, int offset) {
        return this.client.getIntegerReply(RedisCommand.GETBIT, key, String.valueOf(offset));
    }

    @Override
    public String ping() {
        return this.client.getStatusReply(RedisCommand.PING);
    }

    @Override
    public String zincrby(String key, Number score, String member) {
        return this.client.getBulkReply(RedisCommand.ZINCRBY, key, String.valueOf(score), member);
    }

    @Override
    public RedisClient multi() {
        this.client.getStatusReply(RedisCommand.MULTI);
        return this.client;
    }

    @Override
    public String discard() {
        return this.client.getStatusReply(RedisCommand.DISCARD);
    }

    @Override
    public List<Object> pipeline(Pipeline pipeline) {
        pipeline.execute(this.client);
        return this.client.getAll();
    }

    @Override
    public Long zremrangeByScore(String key, String min, String max) {
        return this.client.getIntegerReply(RedisCommand.ZREMRANGEBYSCORE, key, min, max);
    }

    @Override
    public String save() {
        return this.client.getStatusReply(RedisCommand.SAVE);
    }

    @Override
    public String bgsave() {
        return this.client.getStatusReply(RedisCommand.BGSAVE);
    }

    @Override
    public String bgrewriteaof() {
        return this.client.getStatusReply(RedisCommand.BGREWRITEAOF);
    }

    @Override
    public Long lastsave() {
        return this.client.getIntegerReply(RedisCommand.LASTSAVE);
    }

    @Override
    public String shutdown() {
        String status;
        try {
            status = this.client.getStatusReply(RedisCommand.SHUTDOWN);
        }
        catch (RedisException ex) {
            status = null;
        }
        return status;
    }

    @Override
    public String info() {
        return this.client.getBulkReply(RedisCommand.INFO);
    }

    @Override
    public void monitor(RedisMonitor redisMonitor) {
        this.client.noReply(RedisCommand.MONITOR);
        do {
            String command = this.client.getBulkReply();
            redisMonitor.onCommand(command);
        } while (this.client.isConnected());
    }

    @Override
    public String slaveof(String host, int port) {
        return this.client.getStatusReply(RedisCommand.SLAVEOF, host, String.valueOf(port));
    }

    @Override
    public String slaveofNoOne() {
        return this.client.getStatusReply(RedisCommand.SLAVEOF, RedisKeyword.NO.str, RedisKeyword.ONE.str);
    }

    @Override
    public List<String> configGet(String pattern) {
        return this.client.getStringMultiBulkReply(RedisCommand.CONFIG, RedisKeyword.GET.str, pattern);
    }

    @Override
    public String configSet(String parameter, String value) {
        return this.client.getStatusReply(RedisCommand.CONFIG, RedisKeyword.SET.str, parameter, value);
    }

    @Override
    public void sync() {
        this.client.noReply(RedisCommand.SYNC);
    }

    @Override
    public String debug(DebugParams params) {
        return this.client.getStatusReply(RedisCommand.DEBUG, params.getCommand());
    }

    private Boolean integerReplayToBoolean(Long replay) {
        if (replay == null) {
            return null;
        }
        return replay == 1L;
    }

    private List<ElementScore> getReplyAsElementScoreSet(List<String> membersWithScores) {
        ArrayList<ElementScore> result = new ArrayList<ElementScore>();
        Iterator<String> iterator = membersWithScores.iterator();
        while (iterator.hasNext()) {
            result.add(new ElementScore(iterator.next(), iterator.next()));
        }
        return result;
    }
}

