/*
 * Decompiled with CFR 0.152.
 */
package org.idevlab.rjc.ds;

import org.idevlab.rjc.RedisException;
import org.idevlab.rjc.ds.ConnectionFactory;
import org.idevlab.rjc.ds.RedisConnection;
import org.idevlab.rjc.ds.RedisConnectionImpl;
import org.idevlab.rjc.protocol.RedisCommand;

class ConnectionFactoryImpl
implements ConnectionFactory {
    private final String host;
    private final int port;
    private final int timeout;
    private final String password;

    public ConnectionFactoryImpl(String host, int port, int timeout, String password) {
        this.host = host;
        this.port = port;
        this.timeout = timeout > 0 ? timeout : -1;
        this.password = password;
    }

    public RedisConnection create() throws Exception {
        RedisConnectionImpl redis = new RedisConnectionImpl(this.host, this.port);
        if (this.timeout > 0) {
            redis.setTimeout(this.timeout);
        }
        redis.connect();
        if (null != this.password) {
            redis.sendCommand(RedisCommand.AUTH);
            if (!"OK".equals(redis.getStatusCodeReply())) {
                throw new RedisException("Authentication failed");
            }
        }
        return redis;
    }
}

