/*
 * Decompiled with CFR 0.152.
 */
package org.idevlab.rjc.ds;

import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.idevlab.rjc.RedisException;
import org.idevlab.rjc.ds.ConnectionFactory;
import org.idevlab.rjc.ds.ConnectionFactoryImpl;
import org.idevlab.rjc.ds.DataSource;
import org.idevlab.rjc.ds.PoolableRedisConnection;
import org.idevlab.rjc.ds.RedisConnection;
import org.idevlab.rjc.protocol.RedisCommand;

public class PoolableDataSource
implements DataSource {
    private volatile GenericObjectPool connectionPool;
    private String host;
    private int port = 6379;
    private int timeout = 2000;
    private String password;
    protected boolean closed;
    protected int maxActive = 8;
    protected int maxIdle = 8;
    protected int minIdle = 0;
    protected int initialSize = 0;
    protected long maxWait = -1L;
    protected boolean testOnBorrow = true;
    protected boolean testOnReturn = false;
    protected long timeBetweenEvictionRunsMillis = -1L;
    protected int numTestsPerEvictionRun = 3;
    protected long minEvictableIdleTimeMillis = 1800000L;
    protected boolean testWhileIdle = false;

    public RedisConnection getConnection() {
        try {
            return (RedisConnection)this.createPool().borrowObject();
        }
        catch (Exception e) {
            throw new RedisException("Cannot get a connection", e);
        }
    }

    public void init() {
        this.getConnection().close();
    }

    private synchronized GenericObjectPool createPool() {
        if (this.closed) {
            throw new RedisException("Data source is closed");
        }
        if (this.connectionPool == null) {
            GenericObjectPool gop = new GenericObjectPool();
            gop.setMaxActive(this.maxActive);
            gop.setMaxIdle(this.maxIdle);
            gop.setMinIdle(this.minIdle);
            gop.setMaxWait(this.maxWait);
            gop.setTestOnBorrow(this.testOnBorrow);
            gop.setTestOnReturn(this.testOnReturn);
            gop.setTimeBetweenEvictionRunsMillis(this.timeBetweenEvictionRunsMillis);
            gop.setNumTestsPerEvictionRun(this.numTestsPerEvictionRun);
            gop.setMinEvictableIdleTimeMillis(this.minEvictableIdleTimeMillis);
            gop.setTestWhileIdle(this.testWhileIdle);
            this.connectionPool = gop;
            this.createConnectionFactory();
            try {
                for (int i = 0; i < this.initialSize; ++i) {
                    this.connectionPool.addObject();
                }
            }
            catch (Exception e) {
                throw new RedisException("Error preloading the connection pool", e);
            }
        }
        return this.connectionPool;
    }

    private void createConnectionFactory() {
        PoolableConnectionFactory connectionFactory = new PoolableConnectionFactory(this.host, this.port, this.timeout, this.password, (ObjectPool)this.connectionPool);
        try {
            PoolableDataSource.validateConnectionFactory(connectionFactory);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RedisException("Cannot create PoolableConnectionFactory", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void validateConnectionFactory(PoolableConnectionFactory connectionFactory) throws Exception {
        PoolableRedisConnection conn = null;
        try {
            conn = (PoolableRedisConnection)connectionFactory.makeObject();
            connectionFactory.validateObject(conn);
        }
        finally {
            connectionFactory.destroyObject(conn);
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public synchronized void close() {
        this.closed = true;
        GenericObjectPool oldPool = this.connectionPool;
        this.connectionPool = null;
        try {
            if (oldPool != null) {
                oldPool.close();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RedisException("Cannot close connection pool", e);
        }
    }

    public synchronized int getMaxActive() {
        return this.maxActive;
    }

    public synchronized void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
        if (this.connectionPool != null) {
            this.connectionPool.setMaxActive(maxActive);
        }
    }

    public synchronized int getMaxIdle() {
        return this.maxIdle;
    }

    public synchronized void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
        if (this.connectionPool != null) {
            this.connectionPool.setMaxIdle(maxIdle);
        }
    }

    public synchronized int getMinIdle() {
        return this.minIdle;
    }

    public synchronized void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
        if (this.connectionPool != null) {
            this.connectionPool.setMinIdle(minIdle);
        }
    }

    public synchronized int getInitialSize() {
        return this.initialSize;
    }

    public synchronized void setInitialSize(int initialSize) {
        this.initialSize = initialSize;
    }

    public synchronized long getMaxWait() {
        return this.maxWait;
    }

    public synchronized void setMaxWait(long maxWait) {
        this.maxWait = maxWait;
        if (this.connectionPool != null) {
            this.connectionPool.setMaxWait(maxWait);
        }
    }

    public synchronized boolean getTestOnBorrow() {
        return this.testOnBorrow;
    }

    public synchronized void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
        if (this.connectionPool != null) {
            this.connectionPool.setTestOnBorrow(testOnBorrow);
        }
    }

    public synchronized boolean getTestOnReturn() {
        return this.testOnReturn;
    }

    public synchronized void setTestOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
        if (this.connectionPool != null) {
            this.connectionPool.setTestOnReturn(testOnReturn);
        }
    }

    public synchronized long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public synchronized void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
        if (this.connectionPool != null) {
            this.connectionPool.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis);
        }
    }

    public synchronized int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    public synchronized void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.numTestsPerEvictionRun = numTestsPerEvictionRun;
        if (this.connectionPool != null) {
            this.connectionPool.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
        }
    }

    public synchronized long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public synchronized void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
        if (this.connectionPool != null) {
            this.connectionPool.setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis);
        }
    }

    public synchronized boolean getTestWhileIdle() {
        return this.testWhileIdle;
    }

    public synchronized void setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
        if (this.connectionPool != null) {
            this.connectionPool.setTestWhileIdle(testWhileIdle);
        }
    }

    public synchronized int getNumActive() {
        if (this.connectionPool != null) {
            return this.connectionPool.getNumActive();
        }
        return 0;
    }

    public synchronized int getNumIdle() {
        if (this.connectionPool != null) {
            return this.connectionPool.getNumIdle();
        }
        return 0;
    }

    private static class PoolableConnectionFactory
    extends BasePoolableObjectFactory {
        private final ObjectPool pool;
        private final ConnectionFactory connectionFactory;

        public PoolableConnectionFactory(String host, int port, int timeout, String password, ObjectPool pool) {
            this.connectionFactory = new ConnectionFactoryImpl(host, port, timeout, password);
            this.pool = pool;
            pool.setFactory((PoolableObjectFactory)this);
        }

        public Object makeObject() throws Exception {
            return new PoolableRedisConnection(this.connectionFactory.create(), this.pool);
        }

        public void destroyObject(Object obj) throws Exception {
            PoolableRedisConnection redis;
            if (obj instanceof PoolableRedisConnection && (redis = (PoolableRedisConnection)obj).isConnected()) {
                try {
                    redis.sendCommand(RedisCommand.QUIT);
                    redis.reallyDisconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public boolean validateObject(Object obj) {
            if (obj instanceof RedisConnection) {
                RedisConnection redis = (RedisConnection)obj;
                try {
                    if (redis.isConnected()) {
                        redis.sendCommand(RedisCommand.PING);
                        return "PONG".equals(redis.getStatusCodeReply());
                    }
                }
                catch (Exception e) {
                    return false;
                }
            }
            return false;
        }
    }
}

