/*
 * Decompiled with CFR 0.152.
 */
package org.idevlab.rjc.ds;

import org.idevlab.rjc.ds.DataSource;
import org.idevlab.rjc.ds.DataSourceFactory;
import org.idevlab.rjc.ds.PoolableDataSource;

public class PoolableDataSourceFactory
implements DataSourceFactory {
    private int timeout = 2000;
    private String password;
    private boolean initAfterCreation = false;
    protected int maxActive = 8;
    protected int maxIdle = 8;
    protected int minIdle = 0;
    protected int initialSize = 0;
    protected long maxWait = -1L;
    protected boolean testOnBorrow = true;
    protected boolean testOnReturn = false;
    protected long timeBetweenEvictionRunsMillis = -1L;
    protected int numTestsPerEvictionRun = 3;
    protected long minEvictableIdleTimeMillis = 1800000L;
    protected boolean testWhileIdle = false;

    public synchronized DataSource create(String host, int port) {
        PoolableDataSource dataSource = new PoolableDataSource();
        dataSource.setInitialSize(this.initialSize);
        dataSource.setPort(port);
        dataSource.setHost(host);
        dataSource.setMaxActive(this.maxActive);
        dataSource.setMaxIdle(this.maxIdle);
        dataSource.setMaxWait(this.maxWait);
        dataSource.setMinEvictableIdleTimeMillis(this.minEvictableIdleTimeMillis);
        dataSource.setMinIdle(this.minIdle);
        dataSource.setNumTestsPerEvictionRun(this.numTestsPerEvictionRun);
        dataSource.setPassword(this.password);
        dataSource.setTestOnBorrow(this.testOnBorrow);
        dataSource.setTestOnReturn(this.testOnReturn);
        dataSource.setTestWhileIdle(this.testWhileIdle);
        dataSource.setTimeBetweenEvictionRunsMillis(this.timeBetweenEvictionRunsMillis);
        dataSource.setTimeout(this.timeout);
        if (this.initAfterCreation) {
            dataSource.init();
        }
        return dataSource;
    }

    public boolean isInitAfterCreation() {
        return this.initAfterCreation;
    }

    public void setInitAfterCreation(boolean initAfterCreation) {
        this.initAfterCreation = initAfterCreation;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public synchronized int getMaxActive() {
        return this.maxActive;
    }

    public synchronized void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    public synchronized int getMaxIdle() {
        return this.maxIdle;
    }

    public synchronized void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public synchronized int getMinIdle() {
        return this.minIdle;
    }

    public synchronized void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public synchronized int getInitialSize() {
        return this.initialSize;
    }

    public synchronized void setInitialSize(int initialSize) {
        this.initialSize = initialSize;
    }

    public synchronized long getMaxWait() {
        return this.maxWait;
    }

    public synchronized void setMaxWait(long maxWait) {
        this.maxWait = maxWait;
    }

    public synchronized boolean getTestOnBorrow() {
        return this.testOnBorrow;
    }

    public synchronized void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
    }

    public synchronized boolean getTestOnReturn() {
        return this.testOnReturn;
    }

    public synchronized void setTestOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
    }

    public synchronized long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public synchronized void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public synchronized int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    public synchronized void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.numTestsPerEvictionRun = numTestsPerEvictionRun;
    }

    public synchronized long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public synchronized void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public synchronized boolean getTestWhileIdle() {
        return this.testWhileIdle;
    }

    public synchronized void setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
    }
}

