/*
 * Decompiled with CFR 0.152.
 */
package org.idevlab.rjc.message;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.idevlab.rjc.RedisClientImpl;
import org.idevlab.rjc.RedisException;
import org.idevlab.rjc.ds.DataSource;
import org.idevlab.rjc.message.MessageListener;
import org.idevlab.rjc.message.PMessageListener;
import org.idevlab.rjc.message.SubscribeListener;
import org.idevlab.rjc.protocol.RedisCommand;
import org.idevlab.rjc.protocol.RedisKeyword;
import org.idevlab.rjc.util.SafeEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisNodeSubscriber {
    private static final Logger LOG = LoggerFactory.getLogger(RedisNodeSubscriber.class);
    private DataSource dataSource;
    private MessageListener messageListener;
    private PMessageListener pMessageListener;
    private Set<String> patterns = Collections.synchronizedSet(new HashSet());
    private Set<String> channels = Collections.synchronizedSet(new HashSet());
    private SubscribeListener subscribeListener;
    private RedisClientImpl client;
    private volatile boolean connected = false;

    public RedisNodeSubscriber() {
    }

    public RedisNodeSubscriber(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public MessageListener getMessageListener() {
        return this.messageListener;
    }

    public void setMessageListener(MessageListener messageListener) {
        this.messageListener = messageListener;
    }

    public SubscribeListener getSubscribeListener() {
        return this.subscribeListener;
    }

    public void setSubscribeListener(SubscribeListener subscribeListener) {
        this.subscribeListener = subscribeListener;
    }

    public PMessageListener getPMessageListener() {
        return this.pMessageListener;
    }

    public void setPMessageListener(PMessageListener pMessageListener) {
        this.pMessageListener = pMessageListener;
    }

    public void subscribe(String ... channels) {
        if (channels != null) {
            this.channels.addAll(Arrays.asList(channels));
            if (this.connected) {
                this.client.noReply(RedisCommand.SUBSCRIBE, channels);
            }
        }
    }

    public void psubscribe(String ... patterns) {
        if (patterns != null) {
            this.patterns.addAll(Arrays.asList(patterns));
            if (this.connected) {
                this.client.noReply(RedisCommand.PSUBSCRIBE, patterns);
            }
        }
    }

    public void unsubscribe(String ... channels) {
        if (channels != null) {
            this.channels.removeAll(Arrays.asList(channels));
            if (this.connected) {
                this.client.noReply(RedisCommand.UNSUBSCRIBE, channels);
            }
        }
    }

    public void unsubscribe() {
        this.channels.clear();
        if (this.connected) {
            this.client.noReply(RedisCommand.UNSUBSCRIBE);
        }
    }

    public void punsubscribe(String ... pattern) {
        if (this.patterns != null) {
            this.patterns.removeAll(Arrays.asList(this.patterns));
            if (this.connected) {
                this.client.noReply(RedisCommand.PUNSUBSCRIBE, pattern);
            }
        }
    }

    public void punsubscribe() {
        this.patterns.clear();
        if (this.connected) {
            this.client.noReply(RedisCommand.PSUBSCRIBE);
        }
    }

    public void runSubscription() {
        Long subscribedChannels;
        this.close();
        this.client = new RedisClientImpl(this.dataSource.getConnection());
        this.client.setTimeoutInfinite();
        this.connected = true;
        if (this.channels != null && !this.channels.isEmpty()) {
            this.client.noReply(RedisCommand.SUBSCRIBE, this.channels.toArray(new String[this.channels.size()]));
        }
        if (this.patterns != null && !this.patterns.isEmpty()) {
            this.client.noReply(RedisCommand.PSUBSCRIBE, this.patterns.toArray(new String[this.patterns.size()]));
        }
        block10: do {
            List<Object> reply;
            try {
                reply = this.client.getMultiBulkReply();
            }
            catch (Exception e) {
                break;
            }
            Object firstObj = reply.get(0);
            if (!(firstObj instanceof String)) {
                throw new RedisException("Unknown message type: " + firstObj);
            }
            RedisKeyword keyword = RedisKeyword.find((String)firstObj);
            if (keyword == null) {
                throw new RedisException("Unknown pub/sub message: " + firstObj);
            }
            subscribedChannels = null;
            switch (keyword) {
                case MESSAGE: {
                    String channel = (String)reply.get(1);
                    String message = (String)reply.get(2);
                    if (this.messageListener == null) continue block10;
                    this.messageListener.onMessage(channel, message);
                    break;
                }
                case PMESSAGE: {
                    String pattern = (String)reply.get(1);
                    String channel = (String)reply.get(2);
                    String message = (String)reply.get(3);
                    if (this.pMessageListener == null) continue block10;
                    this.pMessageListener.onMessage(pattern, channel, message);
                    break;
                }
                case SUBSCRIBE: {
                    String channel = (String)reply.get(1);
                    subscribedChannels = (Long)reply.get(2);
                    if (this.subscribeListener == null) continue block10;
                    this.subscribeListener.onSubscribe(channel, subscribedChannels);
                    break;
                }
                case UNSUBSCRIBE: {
                    String channel = (String)reply.get(1);
                    subscribedChannels = (Long)reply.get(2);
                    if (this.subscribeListener == null) continue block10;
                    this.subscribeListener.onUnsubscribe(channel, subscribedChannels);
                    break;
                }
                case PSUBSCRIBE: {
                    String pattern = (String)reply.get(1);
                    subscribedChannels = (Long)reply.get(2);
                    if (this.subscribeListener == null) continue block10;
                    this.subscribeListener.onPSubscribe(pattern, subscribedChannels);
                    break;
                }
                case PUNSUBSCRIBE: {
                    String pattern = (String)reply.get(1);
                    subscribedChannels = (Long)reply.get(2);
                    if (this.subscribeListener == null) continue block10;
                    this.subscribeListener.onPUnsubscribe(pattern, subscribedChannels);
                    break;
                }
                default: {
                    LOG.warn("Unknown message: {}", (Object)keyword.toString());
                }
            }
        } while (subscribedChannels == null || subscribedChannels != 0L);
        LOG.debug("Subscriber is going out");
        this.close();
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void close() {
        if (this.connected) {
            this.unsubscribe();
            this.punsubscribe();
            this.client.rollbackTimeout();
            this.client.close();
            LOG.debug("Subscriber is  closed");
        }
        this.connected = false;
    }

    private String byteToStr(byte[] bytes) {
        return bytes == null ? null : SafeEncoder.encode(bytes);
    }
}

