/*
 * Decompiled with CFR 0.152.
 */
package org.idevlab.rjc.protocol;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.idevlab.rjc.RedisException;
import org.idevlab.rjc.protocol.RedisCommand;
import org.idevlab.rjc.protocol.RedisInputStream;
import org.idevlab.rjc.protocol.RedisOutputStream;
import org.idevlab.rjc.util.SafeEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Protocol {
    public static final int DEFAULT_PORT = 6379;
    public static final int DEFAULT_TIMEOUT = 2000;
    public static final String CHARSET = "UTF-8";
    public static final byte DOLLAR_BYTE = 36;
    public static final byte ASTERISK_BYTE = 42;
    public static final byte PLUS_BYTE = 43;
    public static final byte MINUS_BYTE = 45;
    public static final byte COLON_BYTE = 58;

    public void sendCommand(RedisOutputStream os, RedisCommand command, byte[] ... args) {
        this.sendCommand(os, command.raw, args);
    }

    private void sendCommand(RedisOutputStream os, byte[] command, byte[] ... args) {
        try {
            os.write((byte)42);
            os.writeIntCrLf(args.length + 1);
            os.write((byte)36);
            os.writeIntCrLf(command.length);
            os.write(command);
            os.writeCrLf();
            for (byte[] arg : args) {
                os.write((byte)36);
                os.writeIntCrLf(arg.length);
                os.write(arg);
                os.writeCrLf();
            }
            os.flush();
        }
        catch (IOException e) {
            throw new RedisException(e);
        }
    }

    private void processError(RedisInputStream is) {
        String message = is.readLine();
        throw new RedisException(message);
    }

    private Object process(RedisInputStream is, boolean stringsOnly) {
        try {
            byte b = is.readByte();
            if (b != 45) {
                if (b == 42) {
                    return this.processMultiBulkReply(is, stringsOnly);
                }
                if (b == 58) {
                    return this.processInteger(is);
                }
                if (b == 36) {
                    if (stringsOnly) {
                        return this.processBulkReply(is);
                    }
                    return this.processBinaryBulkReply(is);
                }
                if (b == 43) {
                    return this.processStatusCodeReply(is);
                }
                throw new RedisException("Unknown reply: " + (char)b);
            }
            this.processError(is);
        }
        catch (IOException e) {
            throw new RedisException(e);
        }
        return null;
    }

    private String processStatusCodeReply(RedisInputStream is) {
        return is.readLine();
    }

    private String processBulkReply(RedisInputStream is) {
        byte[] result = this.processBinaryBulkReply(is);
        if (result == null) {
            return null;
        }
        return SafeEncoder.encode(result);
    }

    private byte[] processBinaryBulkReply(RedisInputStream is) {
        int len = Integer.parseInt(is.readLine());
        if (len == -1) {
            return null;
        }
        byte[] read = new byte[len];
        try {
            for (int offset = 0; offset < len; offset += is.read(read, offset, len - offset)) {
            }
            is.readByte();
            is.readByte();
        }
        catch (IOException e) {
            throw new RedisException(e);
        }
        return read;
    }

    private Long processInteger(RedisInputStream is) {
        String num = is.readLine();
        return Long.valueOf(num);
    }

    private List<Object> processMultiBulkReply(RedisInputStream is, boolean stringsOnly) {
        int num = Integer.parseInt(is.readLine());
        if (num == -1) {
            return null;
        }
        ArrayList<Object> ret = new ArrayList<Object>(num);
        for (int i = 0; i < num; ++i) {
            ret.add(this.process(is, stringsOnly));
        }
        return ret;
    }

    public Object read(RedisInputStream is) {
        return this.read(is, true);
    }

    public Object read(RedisInputStream is, boolean stringsOnly) {
        return this.process(is, stringsOnly);
    }

    public static byte[] toByteArray(int value) {
        return SafeEncoder.encode(String.valueOf(value));
    }

    public static byte[] toByteArray(long value) {
        return SafeEncoder.encode(String.valueOf(value));
    }

    public static byte[] toByteArray(double value) {
        return SafeEncoder.encode(String.valueOf(value));
    }
}

