/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.source.async;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.minidns.MiniDnsException;
import org.minidns.MiniDnsFuture;
import org.minidns.dnsmessage.DnsMessage;
import org.minidns.dnsqueryresult.DnsQueryResult;
import org.minidns.dnsqueryresult.StandardDnsQueryResult;
import org.minidns.source.AbstractDnsDataSource;
import org.minidns.source.DnsDataSource;
import org.minidns.source.async.AsyncNetworkDataSource;
import org.minidns.source.async.ChannelSelectedHandler;
import org.minidns.util.MultipleIoException;

public class AsyncDnsRequest {
    private static final Logger LOGGER = Logger.getLogger(AsyncDnsRequest.class.getName());
    private final MiniDnsFuture.InternalMiniDnsFuture<DnsQueryResult, IOException> future = new MiniDnsFuture.InternalMiniDnsFuture<DnsQueryResult, IOException>(){

        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean res = super.cancel(mayInterruptIfRunning);
            AsyncDnsRequest.this.cancelAsyncDnsRequest();
            return res;
        }
    };
    private final DnsMessage request;
    private final int udpPayloadSize;
    private final InetSocketAddress socketAddress;
    private final AsyncNetworkDataSource asyncNds;
    private final DnsDataSource.OnResponseCallback onResponseCallback;
    private final boolean skipUdp;
    private ByteBuffer writeBuffer;
    private List<IOException> exceptions;
    private SelectionKey selectionKey;
    final long deadline;

    AsyncDnsRequest(DnsMessage request, InetAddress inetAddress, int port, int udpPayloadSize, AsyncNetworkDataSource asyncNds, DnsDataSource.OnResponseCallback onResponseCallback) {
        this.request = request;
        this.udpPayloadSize = udpPayloadSize;
        this.asyncNds = asyncNds;
        this.onResponseCallback = onResponseCallback;
        AbstractDnsDataSource.QueryMode queryMode = asyncNds.getQueryMode();
        switch (queryMode) {
            case dontCare: 
            case udpTcp: {
                this.skipUdp = false;
                break;
            }
            case tcp: {
                this.skipUdp = true;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported query mode: " + String.valueOf(queryMode));
            }
        }
        this.deadline = System.currentTimeMillis() + (long)asyncNds.getTimeout();
        this.socketAddress = new InetSocketAddress(inetAddress, port);
    }

    private void ensureWriteBufferIsInitialized() {
        if (this.writeBuffer != null) {
            if (!this.writeBuffer.hasRemaining()) {
                ((Buffer)this.writeBuffer).rewind();
            }
            return;
        }
        this.writeBuffer = this.request.getInByteBuffer();
    }

    private synchronized void cancelAsyncDnsRequest() {
        if (this.selectionKey != null) {
            this.selectionKey.cancel();
        }
        this.asyncNds.cancelled(this);
    }

    private synchronized void registerWithSelector(SelectableChannel channel, int ops, ChannelSelectedHandler handler) throws ClosedChannelException {
        if (this.future.isCancelled()) {
            return;
        }
        this.selectionKey = this.asyncNds.registerWithSelector(channel, ops, handler);
    }

    private void addException(IOException e) {
        if (this.exceptions == null) {
            this.exceptions = new ArrayList<IOException>(4);
        }
        this.exceptions.add(e);
    }

    private void gotResult(DnsQueryResult result) {
        if (this.onResponseCallback != null) {
            this.onResponseCallback.onResponse(this.request, result);
        }
        this.asyncNds.finished(this);
        this.future.setResult((Object)result);
    }

    MiniDnsFuture<DnsQueryResult, IOException> getFuture() {
        return this.future;
    }

    boolean wasDeadlineMissedAndFutureNotified() {
        if (System.currentTimeMillis() < this.deadline) {
            return false;
        }
        this.future.setException((Exception)new IOException("Timeout"));
        return true;
    }

    void startHandling() {
        if (!this.skipUdp) {
            this.startUdpRequest();
        } else {
            this.startTcpRequest();
        }
    }

    private void abortRequestAndCleanup(Channel channel, String errorMessage, IOException exception) {
        if (exception == null) {
            LOGGER.info("Exception was null in abortRequestAndCleanup()");
            exception = new IOException(errorMessage);
        }
        LOGGER.log(Level.SEVERE, "Error connecting " + String.valueOf(channel) + ": " + errorMessage, exception);
        this.addException(exception);
        if (this.selectionKey != null) {
            this.selectionKey.cancel();
        }
        if (channel != null && channel.isOpen()) {
            try {
                channel.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Exception closing socket channel", e);
                this.addException(e);
            }
        }
    }

    private void abortUdpRequestAndCleanup(DatagramChannel datagramChannel, String errorMessage, IOException exception) {
        this.abortRequestAndCleanup(datagramChannel, errorMessage, exception);
        this.startTcpRequest();
    }

    private void startUdpRequest() {
        DatagramChannel datagramChannel;
        if (this.future.isCancelled()) {
            return;
        }
        try {
            datagramChannel = DatagramChannel.open();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Exception opening datagram channel", e);
            this.addException(e);
            this.startTcpRequest();
            return;
        }
        try {
            datagramChannel.configureBlocking(false);
        }
        catch (IOException e) {
            this.abortUdpRequestAndCleanup(datagramChannel, "Exception configuring datagram channel", e);
            return;
        }
        try {
            datagramChannel.connect(this.socketAddress);
        }
        catch (IOException e) {
            this.abortUdpRequestAndCleanup(datagramChannel, "Exception connecting datagram channel to " + String.valueOf(this.socketAddress), e);
            return;
        }
        try {
            this.registerWithSelector(datagramChannel, 4, new UdpWritableChannelSelectedHandler((Future<?>)this.future));
        }
        catch (ClosedChannelException e) {
            this.abortUdpRequestAndCleanup(datagramChannel, "Exception registering datagram channel for OP_WRITE", e);
            return;
        }
    }

    private void abortTcpRequestAndCleanup(SocketChannel socketChannel, String errorMessage, IOException exception) {
        this.abortRequestAndCleanup(socketChannel, errorMessage, exception);
        this.future.setException((Exception)MultipleIoException.toIOException(this.exceptions));
    }

    private void startTcpRequest() {
        SocketChannel socketChannel = null;
        try {
            socketChannel = SocketChannel.open();
        }
        catch (IOException e) {
            this.abortTcpRequestAndCleanup(socketChannel, "Exception opening socket channel", e);
            return;
        }
        try {
            socketChannel.configureBlocking(false);
        }
        catch (IOException e) {
            this.abortTcpRequestAndCleanup(socketChannel, "Exception configuring socket channel", e);
            return;
        }
        try {
            this.registerWithSelector(socketChannel, 8, new TcpConnectedChannelSelectedHandler((Future<?>)this.future));
        }
        catch (ClosedChannelException e) {
            this.abortTcpRequestAndCleanup(socketChannel, "Exception registering socket channel", e);
            return;
        }
        try {
            socketChannel.connect(this.socketAddress);
        }
        catch (IOException e) {
            this.abortTcpRequestAndCleanup(socketChannel, "Exception connecting socket channel to " + String.valueOf(this.socketAddress), e);
            return;
        }
    }

    class UdpWritableChannelSelectedHandler
    extends ChannelSelectedHandler {
        UdpWritableChannelSelectedHandler(Future<?> future) {
            super(future);
        }

        @Override
        public void handleChannelSelectedAndNotCancelled(SelectableChannel channel, SelectionKey selectionKey) {
            DatagramChannel datagramChannel = (DatagramChannel)channel;
            AsyncDnsRequest.this.ensureWriteBufferIsInitialized();
            try {
                datagramChannel.write(AsyncDnsRequest.this.writeBuffer);
            }
            catch (IOException e) {
                AsyncDnsRequest.this.abortUdpRequestAndCleanup(datagramChannel, "Exception writing to datagram channel", e);
                return;
            }
            if (AsyncDnsRequest.this.writeBuffer.hasRemaining()) {
                try {
                    AsyncDnsRequest.this.registerWithSelector(datagramChannel, 4, this);
                }
                catch (ClosedChannelException e) {
                    AsyncDnsRequest.this.abortUdpRequestAndCleanup(datagramChannel, "Exception registering datagram channel for OP_WRITE", e);
                }
                return;
            }
            try {
                AsyncDnsRequest.this.registerWithSelector(datagramChannel, 1, new UdpReadableChannelSelectedHandler(this.future));
            }
            catch (ClosedChannelException e) {
                AsyncDnsRequest.this.abortUdpRequestAndCleanup(datagramChannel, "Exception registering datagram channel for OP_READ", e);
                return;
            }
        }
    }

    class TcpConnectedChannelSelectedHandler
    extends ChannelSelectedHandler {
        TcpConnectedChannelSelectedHandler(Future<?> future) {
            super(future);
        }

        @Override
        public void handleChannelSelectedAndNotCancelled(SelectableChannel channel, SelectionKey selectionKey) {
            boolean connected;
            SocketChannel socketChannel = (SocketChannel)channel;
            try {
                connected = socketChannel.finishConnect();
            }
            catch (IOException e) {
                AsyncDnsRequest.this.abortTcpRequestAndCleanup(socketChannel, "Exception finish connecting socket channel", e);
                return;
            }
            assert (connected);
            try {
                AsyncDnsRequest.this.registerWithSelector(socketChannel, 4, new TcpWritableChannelSelectedHandler(this.future));
            }
            catch (ClosedChannelException e) {
                AsyncDnsRequest.this.abortTcpRequestAndCleanup(socketChannel, "Exception registering socket channel for OP_WRITE", e);
                return;
            }
        }
    }

    class TcpReadableChannelSelectedHandler
    extends ChannelSelectedHandler {
        final ByteBuffer messageLengthByteBuffer;
        ByteBuffer byteBuffer;

        TcpReadableChannelSelectedHandler(Future<?> future) {
            super(future);
            this.messageLengthByteBuffer = ByteBuffer.allocate(2);
        }

        @Override
        public void handleChannelSelectedAndNotCancelled(SelectableChannel channel, SelectionKey selectionKey) {
            DnsMessage response;
            int bytesRead;
            SocketChannel socketChannel = (SocketChannel)channel;
            if (this.byteBuffer == null) {
                try {
                    bytesRead = socketChannel.read(this.messageLengthByteBuffer);
                }
                catch (IOException e) {
                    AsyncDnsRequest.this.abortTcpRequestAndCleanup(socketChannel, "Exception reading from socket channel", e);
                    return;
                }
                if (bytesRead < 0) {
                    AsyncDnsRequest.this.abortTcpRequestAndCleanup(socketChannel, "Socket closed by remote host " + String.valueOf(AsyncDnsRequest.this.socketAddress), null);
                    return;
                }
                if (this.messageLengthByteBuffer.hasRemaining()) {
                    try {
                        AsyncDnsRequest.this.registerWithSelector(socketChannel, 1, this);
                    }
                    catch (ClosedChannelException e) {
                        AsyncDnsRequest.this.abortTcpRequestAndCleanup(socketChannel, "Exception registering socket channel for OP_READ", e);
                    }
                    return;
                }
                ((Buffer)this.messageLengthByteBuffer).rewind();
                short messageLengthSignedShort = this.messageLengthByteBuffer.getShort();
                int messageLength = messageLengthSignedShort & 0xFFFF;
                this.byteBuffer = ByteBuffer.allocate(messageLength);
            }
            try {
                bytesRead = socketChannel.read(this.byteBuffer);
            }
            catch (IOException e) {
                throw new Error(e);
            }
            if (bytesRead < 0) {
                AsyncDnsRequest.this.abortTcpRequestAndCleanup(socketChannel, "Socket closed by remote host " + String.valueOf(AsyncDnsRequest.this.socketAddress), null);
                return;
            }
            if (this.byteBuffer.hasRemaining()) {
                try {
                    AsyncDnsRequest.this.registerWithSelector(socketChannel, 1, this);
                }
                catch (ClosedChannelException e) {
                    AsyncDnsRequest.this.abortTcpRequestAndCleanup(socketChannel, "Exception registering socket channel for OP_READ", e);
                }
                return;
            }
            selectionKey.cancel();
            try {
                socketChannel.close();
            }
            catch (IOException e) {
                AsyncDnsRequest.this.addException(e);
            }
            try {
                response = new DnsMessage(this.byteBuffer.array());
            }
            catch (IOException e) {
                AsyncDnsRequest.this.abortTcpRequestAndCleanup(socketChannel, "Exception creating DNS message form socket channel bytes", e);
                return;
            }
            if (AsyncDnsRequest.this.request.id != response.id) {
                MiniDnsException.IdMismatch idMismatchException = new MiniDnsException.IdMismatch(AsyncDnsRequest.this.request, response);
                AsyncDnsRequest.this.addException((IOException)idMismatchException);
                AsyncDnsRequest.this.future.setException((Exception)MultipleIoException.toIOException(AsyncDnsRequest.this.exceptions));
                return;
            }
            StandardDnsQueryResult result = new StandardDnsQueryResult(AsyncDnsRequest.this.socketAddress.getAddress(), AsyncDnsRequest.this.socketAddress.getPort(), DnsQueryResult.QueryMethod.asyncTcp, AsyncDnsRequest.this.request, response);
            AsyncDnsRequest.this.gotResult((DnsQueryResult)result);
        }
    }

    class TcpWritableChannelSelectedHandler
    extends ChannelSelectedHandler {
        private ByteBuffer[] writeBuffers;

        TcpWritableChannelSelectedHandler(Future<?> future) {
            super(future);
        }

        @Override
        public void handleChannelSelectedAndNotCancelled(SelectableChannel channel, SelectionKey selectionKey) {
            SocketChannel socketChannel = (SocketChannel)channel;
            if (this.writeBuffers == null) {
                AsyncDnsRequest.this.ensureWriteBufferIsInitialized();
                ByteBuffer messageLengthByteBuffer = ByteBuffer.allocate(2);
                int messageLength = AsyncDnsRequest.this.writeBuffer.capacity();
                assert (messageLength <= Short.MAX_VALUE);
                messageLengthByteBuffer.putShort((short)(messageLength & 0xFFFF));
                ((Buffer)messageLengthByteBuffer).rewind();
                this.writeBuffers = new ByteBuffer[2];
                this.writeBuffers[0] = messageLengthByteBuffer;
                this.writeBuffers[1] = AsyncDnsRequest.this.writeBuffer;
            }
            try {
                socketChannel.write(this.writeBuffers);
            }
            catch (IOException e) {
                AsyncDnsRequest.this.abortTcpRequestAndCleanup(socketChannel, "Exception writing to socket channel", e);
                return;
            }
            if (this.moreToWrite()) {
                try {
                    AsyncDnsRequest.this.registerWithSelector(socketChannel, 4, this);
                }
                catch (ClosedChannelException e) {
                    AsyncDnsRequest.this.abortTcpRequestAndCleanup(socketChannel, "Exception registering socket channel for OP_WRITE", e);
                }
                return;
            }
            try {
                AsyncDnsRequest.this.registerWithSelector(socketChannel, 1, new TcpReadableChannelSelectedHandler(this.future));
            }
            catch (ClosedChannelException e) {
                AsyncDnsRequest.this.abortTcpRequestAndCleanup(socketChannel, "Exception registering socket channel for OP_READ", e);
                return;
            }
        }

        private boolean moreToWrite() {
            for (int i = 0; i < this.writeBuffers.length; ++i) {
                if (!this.writeBuffers[i].hasRemaining()) continue;
                return true;
            }
            return false;
        }
    }

    class UdpReadableChannelSelectedHandler
    extends ChannelSelectedHandler {
        final ByteBuffer byteBuffer;

        UdpReadableChannelSelectedHandler(Future<?> future) {
            super(future);
            this.byteBuffer = ByteBuffer.allocate(AsyncDnsRequest.this.udpPayloadSize);
        }

        @Override
        public void handleChannelSelectedAndNotCancelled(SelectableChannel channel, SelectionKey selectionKey) {
            DnsMessage response;
            DatagramChannel datagramChannel = (DatagramChannel)channel;
            try {
                datagramChannel.read(this.byteBuffer);
            }
            catch (IOException e) {
                AsyncDnsRequest.this.abortUdpRequestAndCleanup(datagramChannel, "Exception reading from datagram channel", e);
                return;
            }
            selectionKey.cancel();
            try {
                datagramChannel.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Exception closing datagram channel", e);
                AsyncDnsRequest.this.addException(e);
            }
            try {
                response = new DnsMessage(this.byteBuffer.array());
            }
            catch (IOException e) {
                AsyncDnsRequest.this.abortUdpRequestAndCleanup(datagramChannel, "Exception constructing dns message from datagram channel", e);
                return;
            }
            if (response.id != AsyncDnsRequest.this.request.id) {
                AsyncDnsRequest.this.addException((IOException)new MiniDnsException.IdMismatch(AsyncDnsRequest.this.request, response));
                AsyncDnsRequest.this.startTcpRequest();
                return;
            }
            if (response.truncated) {
                AsyncDnsRequest.this.startTcpRequest();
                return;
            }
            StandardDnsQueryResult result = new StandardDnsQueryResult(AsyncDnsRequest.this.socketAddress.getAddress(), AsyncDnsRequest.this.socketAddress.getPort(), DnsQueryResult.QueryMethod.asyncUdp, AsyncDnsRequest.this.request, response);
            AsyncDnsRequest.this.gotResult((DnsQueryResult)result);
        }
    }
}

