/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.source.async;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.minidns.MiniDnsFuture;
import org.minidns.dnsmessage.DnsMessage;
import org.minidns.dnsqueryresult.DnsQueryResult;
import org.minidns.source.AbstractDnsDataSource;
import org.minidns.source.DnsDataSource;
import org.minidns.source.async.AsyncDnsRequest;
import org.minidns.source.async.ChannelSelectedHandler;

public class AsyncNetworkDataSource
extends AbstractDnsDataSource {
    protected static final Logger LOGGER = Logger.getLogger(AsyncNetworkDataSource.class.getName());
    private static final int REACTOR_THREAD_COUNT = 1;
    private static final Queue<AsyncDnsRequest> INCOMING_REQUESTS = new ConcurrentLinkedQueue<AsyncDnsRequest>();
    private static final Selector SELECTOR;
    private static final Lock REGISTRATION_LOCK;
    private static final Queue<SelectionKey> PENDING_SELECTION_KEYS;
    private static final Thread[] REACTOR_THREADS;
    private static final PriorityQueue<AsyncDnsRequest> DEADLINE_QUEUE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MiniDnsFuture<DnsQueryResult, IOException> queryAsync(DnsMessage message, InetAddress address, int port, DnsDataSource.OnResponseCallback onResponseCallback) {
        AsyncDnsRequest asyncDnsRequest = new AsyncDnsRequest(message, address, port, this.udpPayloadSize, this, onResponseCallback);
        INCOMING_REQUESTS.add(asyncDnsRequest);
        PriorityQueue<AsyncDnsRequest> priorityQueue = DEADLINE_QUEUE;
        synchronized (priorityQueue) {
            DEADLINE_QUEUE.add(asyncDnsRequest);
        }
        SELECTOR.wakeup();
        return asyncDnsRequest.getFuture();
    }

    public DnsQueryResult query(DnsMessage message, InetAddress address, int port) throws IOException {
        MiniDnsFuture<DnsQueryResult, IOException> future = this.queryAsync(message, address, port, null);
        try {
            return (DnsQueryResult)future.get();
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        catch (ExecutionException e) {
            Throwable wrappedThrowable = e.getCause();
            if (wrappedThrowable instanceof IOException) {
                throw (IOException)wrappedThrowable;
            }
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SelectionKey registerWithSelector(SelectableChannel channel, int ops, Object attachment) throws ClosedChannelException {
        REGISTRATION_LOCK.lock();
        try {
            SELECTOR.wakeup();
            SelectionKey selectionKey = channel.register(SELECTOR, ops, attachment);
            return selectionKey;
        }
        finally {
            REGISTRATION_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finished(AsyncDnsRequest asyncDnsRequest) {
        PriorityQueue<AsyncDnsRequest> priorityQueue = DEADLINE_QUEUE;
        synchronized (priorityQueue) {
            DEADLINE_QUEUE.remove(asyncDnsRequest);
        }
    }

    void cancelled(AsyncDnsRequest asyncDnsRequest) {
        this.finished(asyncDnsRequest);
        SELECTOR.wakeup();
    }

    static {
        REGISTRATION_LOCK = new ReentrantLock();
        PENDING_SELECTION_KEYS = new ConcurrentLinkedQueue<SelectionKey>();
        REACTOR_THREADS = new Thread[1];
        DEADLINE_QUEUE = new PriorityQueue<AsyncDnsRequest>(16, new Comparator<AsyncDnsRequest>(){

            @Override
            public int compare(AsyncDnsRequest o1, AsyncDnsRequest o2) {
                if (o1.deadline > o2.deadline) {
                    return 1;
                }
                if (o1.deadline < o2.deadline) {
                    return -1;
                }
                return 0;
            }
        });
        try {
            SELECTOR = Selector.open();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        for (int i = 0; i < 1; ++i) {
            Thread reactorThread = new Thread(new Reactor());
            reactorThread.setDaemon(true);
            reactorThread.setName("MiniDNS Reactor Thread #" + i);
            reactorThread.start();
            AsyncNetworkDataSource.REACTOR_THREADS[i] = reactorThread;
        }
    }

    private static final class Reactor
    implements Runnable {
        private Reactor() {
        }

        @Override
        public void run() {
            while (!Thread.interrupted()) {
                Collection<SelectionKey> mySelectedKeys = Reactor.performSelect();
                Reactor.handleSelectedKeys(mySelectedKeys);
                Reactor.handlePendingSelectionKeys();
                Reactor.handleIncomingRequests();
            }
        }

        private static void handleSelectedKeys(Collection<SelectionKey> selectedKeys) {
            for (SelectionKey selectionKey : selectedKeys) {
                ChannelSelectedHandler channelSelectedHandler = (ChannelSelectedHandler)selectionKey.attachment();
                SelectableChannel channel = selectionKey.channel();
                channelSelectedHandler.handleChannelSelected(channel, selectionKey);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Collection<SelectionKey> performSelect() {
            ArrayList<SelectionKey> selectedKeys;
            int newSelectedKeysCount;
            long selectWait;
            AsyncDnsRequest nextInQueue;
            AsyncDnsRequest nearestDeadline = null;
            PriorityQueue<AsyncDnsRequest> priorityQueue = DEADLINE_QUEUE;
            synchronized (priorityQueue) {
                while ((nextInQueue = DEADLINE_QUEUE.peek()) != null) {
                    if (nextInQueue.wasDeadlineMissedAndFutureNotified()) {
                        DEADLINE_QUEUE.poll();
                        continue;
                    }
                    nearestDeadline = nextInQueue;
                    break;
                }
            }
            if (nearestDeadline == null) {
                selectWait = 0L;
            } else {
                selectWait = nextInQueue.deadline - System.currentTimeMillis();
                if (selectWait < 0L) {
                    return Collections.emptyList();
                }
            }
            Selector selector = SELECTOR;
            synchronized (selector) {
                REGISTRATION_LOCK.lock();
                REGISTRATION_LOCK.unlock();
                try {
                    newSelectedKeysCount = SELECTOR.select(selectWait);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "IOException while using select()", e);
                    return Collections.emptyList();
                }
                if (newSelectedKeysCount == 0) {
                    return Collections.emptyList();
                }
                Set<SelectionKey> selectedKeySet = SELECTOR.selectedKeys();
                for (SelectionKey selectionKey : selectedKeySet) {
                    selectionKey.interestOps(0);
                }
                selectedKeys = new ArrayList<SelectionKey>(selectedKeySet.size());
                selectedKeys.addAll(selectedKeySet);
                selectedKeySet.clear();
            }
            int selectedKeysCount = selectedKeys.size();
            Level LOG_LEVEL = Level.FINER;
            if (LOGGER.isLoggable(LOG_LEVEL)) {
                LOGGER.log(LOG_LEVEL, "New selected key count: " + newSelectedKeysCount + ". Total selected key count " + selectedKeysCount);
            }
            int myKeyCount = selectedKeysCount / 1;
            ArrayList<SelectionKey> mySelectedKeys = new ArrayList<SelectionKey>(myKeyCount);
            Iterator it = selectedKeys.iterator();
            for (int i = 0; i < myKeyCount; ++i) {
                SelectionKey selectionKey = (SelectionKey)it.next();
                mySelectedKeys.add(selectionKey);
            }
            while (it.hasNext()) {
                SelectionKey selectionKey = (SelectionKey)it.next();
                PENDING_SELECTION_KEYS.add(selectionKey);
            }
            return mySelectedKeys;
        }

        private static void handlePendingSelectionKeys() {
            SelectionKey selectionKey;
            int pendingSelectionKeysSize = PENDING_SELECTION_KEYS.size();
            if (pendingSelectionKeysSize == 0) {
                return;
            }
            int myKeyCount = pendingSelectionKeysSize / 1;
            ArrayList<SelectionKey> selectedKeys = new ArrayList<SelectionKey>(myKeyCount);
            for (int i = 0; i < myKeyCount && (selectionKey = PENDING_SELECTION_KEYS.poll()) != null; ++i) {
                selectedKeys.add(selectionKey);
            }
            if (!PENDING_SELECTION_KEYS.isEmpty()) {
                SELECTOR.wakeup();
            }
            Reactor.handleSelectedKeys(selectedKeys);
        }

        private static void handleIncomingRequests() {
            AsyncDnsRequest asyncDnsRequest2;
            int incomingRequestsSize = INCOMING_REQUESTS.size();
            if (incomingRequestsSize == 0) {
                return;
            }
            int myRequestsCount = incomingRequestsSize / 1;
            if (myRequestsCount == 0) {
                myRequestsCount = 1;
            }
            ArrayList<AsyncDnsRequest> requests = new ArrayList<AsyncDnsRequest>(myRequestsCount);
            for (int i = 0; i < myRequestsCount && (asyncDnsRequest2 = INCOMING_REQUESTS.poll()) != null; ++i) {
                requests.add(asyncDnsRequest2);
            }
            if (!INCOMING_REQUESTS.isEmpty()) {
                SELECTOR.wakeup();
            }
            for (AsyncDnsRequest asyncDnsRequest2 : requests) {
                asyncDnsRequest2.startHandling();
            }
        }
    }
}

