/*
 * Decompiled with CFR 0.152.
 */
package org.minidns;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.minidns.AbstractDnsClient;
import org.minidns.DnsCache;
import org.minidns.DnsClient;
import org.minidns.DnsWorld;
import org.minidns.cache.LruCache;
import org.minidns.dnsmessage.DnsMessage;
import org.minidns.dnsqueryresult.DnsQueryResult;
import org.minidns.dnsqueryresult.TestWorldDnsQueryResult;
import org.minidns.dnsserverlookup.AbstractDnsServerLookupMechanism;
import org.minidns.dnsserverlookup.AndroidUsingExec;
import org.minidns.dnsserverlookup.AndroidUsingReflection;
import org.minidns.dnsserverlookup.DnsServerLookupMechanism;
import org.minidns.record.A;
import org.minidns.record.Record;
import org.minidns.source.AbstractDnsDataSource;
import org.minidns.source.DnsDataSource;

public class DnsClientTest {
    @Test
    public void testLookupMechanismOrder() {
        DnsClient.addDnsServerLookupMechanism((DnsServerLookupMechanism)new TestDnsServerLookupMechanism(AndroidUsingExec.INSTANCE));
        DnsClient.addDnsServerLookupMechanism((DnsServerLookupMechanism)new TestDnsServerLookupMechanism(AndroidUsingReflection.INSTANCE));
        ArrayList<DnsServerLookupMechanism> expectedOrder = new ArrayList<DnsServerLookupMechanism>();
        expectedOrder.add(0, AndroidUsingExec.INSTANCE);
        expectedOrder.add(1, AndroidUsingReflection.INSTANCE);
        for (DnsServerLookupMechanism mechanism : DnsClient.LOOKUP_MECHANISMS) {
            if (expectedOrder.isEmpty()) break;
            DnsServerLookupMechanism shouldBeRemovedNext = (DnsServerLookupMechanism)expectedOrder.get(0);
            if (!mechanism.getName().equals(shouldBeRemovedNext.getName())) continue;
            expectedOrder.remove(0);
        }
        Assertions.assertTrue((boolean)expectedOrder.isEmpty());
    }

    @Test
    public void testSingleRecordQuery() throws IOException {
        DnsClient client = new DnsClient((DnsCache)new LruCache(0));
        DnsWorld.applyStubRecords((AbstractDnsClient)client, DnsWorld.record("www.example.com", DnsWorld.a("127.0.0.1")));
        DnsQueryResult result = client.query((CharSequence)"www.example.com", Record.TYPE.A);
        DnsMessage response = result.response;
        Assertions.assertNotNull((Object)response);
        Assertions.assertEquals((int)1, (int)response.answerSection.size());
        Assertions.assertEquals((Object)Record.TYPE.A, (Object)((Record)response.answerSection.get((int)0)).type);
        Assertions.assertArrayEquals((byte[])new byte[]{127, 0, 0, 1}, (byte[])((A)((Record)response.answerSection.get((int)0)).payloadData).getIp());
        result = client.query((CharSequence)"www2.example.com", Record.TYPE.A);
        Assertions.assertEquals((Object)DnsMessage.RESPONSE_CODE.NX_DOMAIN, (Object)result.response.responseCode);
        result = client.query((CharSequence)"www.example.com", Record.TYPE.CNAME);
        Assertions.assertEquals((Object)DnsMessage.RESPONSE_CODE.NX_DOMAIN, (Object)result.response.responseCode);
    }

    @Test
    public void testReturnNullSource() throws IOException {
        DnsClient client = new DnsClient((DnsCache)new LruCache(0));
        class NullSource
        extends AbstractDnsDataSource {
            boolean queried = false;

            NullSource() {
            }

            public DnsQueryResult query(DnsMessage message, InetAddress address, int port) {
                this.queried = true;
                DnsMessage response = message.getResponseBuilder(DnsMessage.RESPONSE_CODE.NO_ERROR).setRecursionAvailable(true).build();
                return new TestWorldDnsQueryResult(message, response);
            }
        }
        NullSource source = new NullSource();
        client.setDataSource((DnsDataSource)source);
        DnsQueryResult message = client.query((CharSequence)"www.example.com", Record.TYPE.A);
        Assertions.assertTrue((boolean)source.queried);
        Assertions.assertNotNull((Object)message);
    }

    private static class TestDnsServerLookupMechanism
    extends AbstractDnsServerLookupMechanism {
        protected TestDnsServerLookupMechanism(DnsServerLookupMechanism lookupMechanism) {
            super(lookupMechanism.getName(), lookupMechanism.getPriority());
        }

        public boolean isAvailable() {
            return true;
        }

        public List<String> getDnsServerAddresses() {
            return null;
        }
    }
}

