/*
 * Decompiled with CFR 0.152.
 */
package org.minidns;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.minidns.AbstractDnsClient;
import org.minidns.RrSet;
import org.minidns.constants.DnsRootServer;
import org.minidns.constants.DnssecConstants;
import org.minidns.dnsmessage.DnsMessage;
import org.minidns.dnsmessage.Question;
import org.minidns.dnsname.DnsName;
import org.minidns.dnsqueryresult.DnsQueryResult;
import org.minidns.dnsqueryresult.TestWorldDnsQueryResult;
import org.minidns.record.A;
import org.minidns.record.AAAA;
import org.minidns.record.CNAME;
import org.minidns.record.DLV;
import org.minidns.record.DNSKEY;
import org.minidns.record.DS;
import org.minidns.record.Data;
import org.minidns.record.MX;
import org.minidns.record.NS;
import org.minidns.record.NSEC;
import org.minidns.record.NSEC3;
import org.minidns.record.RRSIG;
import org.minidns.record.Record;
import org.minidns.record.SOA;
import org.minidns.record.SRV;
import org.minidns.source.AbstractDnsDataSource;
import org.minidns.source.DnsDataSource;
import org.minidns.util.InetAddressUtil;

public class DnsWorld
extends AbstractDnsDataSource {
    private List<PreparedResponse> answers = new ArrayList<PreparedResponse>();
    private final Map<DnsName, Map<Record.TYPE, RrSet>> worldData = new HashMap<DnsName, Map<Record.TYPE, RrSet>>();

    public DnsQueryResult query(DnsMessage message, InetAddress address, int port) {
        Assertions.assertNotNull((Object)message);
        Assertions.assertNotNull((Object)address);
        Assertions.assertEquals((int)53, (int)port);
        for (PreparedResponse answer : this.answers) {
            if (!answer.isResponse(message, address)) continue;
            DnsMessage.Builder response = answer.getResponse().asBuilder();
            response.setId(message.id);
            response.setQuestions(message.questions);
            return new TestWorldDnsQueryResult(message, response.build(), answer);
        }
        DnsMessage nxDomainResponse = message.getResponseBuilder(DnsMessage.RESPONSE_CODE.NX_DOMAIN).setRecursionAvailable(true).setAuthoritativeAnswer(true).build();
        return new TestWorldDnsQueryResult(message, nxDomainResponse);
    }

    public void addPreparedResponse(PreparedResponse answer) {
        this.answers.add(answer);
    }

    public static DnsWorld applyZones(AbstractDnsClient client, Zone ... zones) {
        DnsWorld world = new DnsWorld();
        client.setDataSource((DnsDataSource)world);
        for (Zone zone : zones) {
            for (RrSet rrSet : zone.getRRSets()) {
                DnsName zoneName = rrSet.name;
                Map<Record.TYPE, RrSet> zoneData = world.worldData.get(zoneName);
                if (zoneData == null) {
                    zoneData = new HashMap<Record.TYPE, RrSet>();
                    world.worldData.put(zoneName, zoneData);
                }
                zoneData.put(rrSet.type, rrSet);
                DnsMessage.Builder req = client.buildMessage(new Question(rrSet.name, rrSet.type, rrSet.clazz));
                DnsMessage.Builder resp = DnsMessage.builder();
                resp.setAnswers((Collection)rrSet.records);
                resp.setAuthoritativeAnswer(true);
                DnsWorld.attachGlues(resp, rrSet.records, zone.records);
                DnsWorld.attachSignatures(resp, zone.records);
                DnsMessage request = req.build();
                DnsMessage response = resp.build();
                if (zone.isRootZone()) {
                    world.addPreparedResponse(new RootAnswerResponse(request, response));
                } else {
                    world.addPreparedResponse(new AddressedAnswerResponse(zone.address, request, response));
                }
                if (rrSet.type != Record.TYPE.NS) continue;
                DnsMessage.Builder hintsResp = DnsMessage.builder();
                hintsResp.setNameserverRecords((Collection)rrSet.records);
                hintsResp.setAdditionalResourceRecords((Collection)response.additionalSection);
                DnsMessage hintsResponse = hintsResp.build();
                if (zone.isRootZone()) {
                    world.addPreparedResponse(new RootHintsResponse(rrSet.name, hintsResponse));
                    continue;
                }
                world.addPreparedResponse(new AddressedHintsResponse(zone.address, rrSet.name, hintsResponse));
            }
        }
        return world;
    }

    static void attachSignatures(DnsMessage.Builder response, List<Record<? extends Data>> records) {
        ArrayList<Record<? extends Data>> recordList = new ArrayList<Record<? extends Data>>(records.size());
        for (Record record : response.getAnswers()) {
            for (Record<? extends Data> r : records) {
                if (!r.name.equals((Object)record.name) || r.type != Record.TYPE.RRSIG || ((RRSIG)r.payloadData).typeCovered != record.type) continue;
                recordList.add(r);
            }
        }
        response.addAnswers(recordList);
        recordList.clear();
        for (Record record : response.getAdditionalResourceRecords()) {
            for (Record<? extends Data> r : records) {
                if (!r.name.equals((Object)record.name) || r.type != Record.TYPE.RRSIG || ((RRSIG)r.payloadData).typeCovered != record.type) continue;
                recordList.add(r);
            }
        }
        response.addAdditionalResourceRecords(recordList);
    }

    static void attachGlues(DnsMessage.Builder response, Collection<Record<? extends Data>> answers, List<Record<? extends Data>> records) {
        ArrayList<Record<? extends Data>> glues = new ArrayList<Record<? extends Data>>();
        for (Record<? extends Data> record : answers) {
            if (record.type == Record.TYPE.CNAME) {
                glues.addAll(DnsWorld.findGlues(((CNAME)record.payloadData).target, records));
                continue;
            }
            if (record.type == Record.TYPE.NS) {
                glues.addAll(DnsWorld.findGlues(((NS)record.payloadData).target, records));
                continue;
            }
            if (record.type != Record.TYPE.SRV) continue;
            glues.addAll(DnsWorld.findGlues(((SRV)record.payloadData).target, records));
        }
        if (!glues.isEmpty()) {
            response.setAdditionalResourceRecords(glues);
        }
    }

    private static List<Record<? extends Data>> findGlues(DnsName name, List<Record<? extends Data>> records) {
        ArrayList<Record<? extends Data>> glues = new ArrayList<Record<? extends Data>>();
        for (Record<? extends Data> record : records) {
            if (!record.name.equals((Object)name)) continue;
            if (record.type == Record.TYPE.CNAME) {
                glues.addAll(DnsWorld.findGlues(((CNAME)record.payloadData).target, records));
                continue;
            }
            if (record.type != Record.TYPE.A && record.type != Record.TYPE.AAAA) continue;
            glues.add(record);
        }
        return glues;
    }

    @SafeVarargs
    public static DnsWorld applyStubRecords(AbstractDnsClient client, Record<? extends Data> ... records) {
        DnsWorld world = new DnsWorld();
        client.setDataSource((DnsDataSource)world);
        for (Record<? extends Data> record : records) {
            DnsMessage.Builder request = client.buildMessage(new Question(record.name, record.type, record.clazz, record.unicastQuery));
            request.setRecursionDesired(true);
            DnsMessage.Builder response = DnsMessage.builder();
            response.addAnswer(record);
            response.setRecursionAvailable(true);
            world.addPreparedResponse(new AnswerResponse(request.build(), response.build()));
        }
        return world;
    }

    @SafeVarargs
    public static Zone rootZone(Record<? extends Data> ... records) {
        ArrayList<Record<? extends Data>> listOfRecords = new ArrayList<Record<? extends Data>>(records.length);
        for (Record<? extends Data> record : records) {
            listOfRecords.add(record);
        }
        return DnsWorld.rootZone(listOfRecords);
    }

    public static Zone rootZone(List<Record<? extends Data>> records) {
        return new Zone("", null, records);
    }

    @SafeVarargs
    public static Zone zone(String zoneName, String nsName, String nsIp, Record<? extends Data> ... records) {
        ArrayList<Record<? extends Data>> listOfRecords = new ArrayList<Record<? extends Data>>(records.length);
        for (Record<? extends Data> record : records) {
            listOfRecords.add(record);
        }
        return DnsWorld.zone(zoneName, nsName, nsIp, listOfRecords);
    }

    public static Zone zone(String zoneName, String nsName, String nsIp, List<Record<? extends Data>> records) {
        Inet4Address inet4Address = InetAddressUtil.ipv4From((CharSequence)nsIp);
        try {
            return DnsWorld.zone(zoneName, InetAddress.getByAddress(nsName, inet4Address.getAddress()), records);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public static Zone zone(String zoneName, InetAddress address, List<Record<? extends Data>> records) {
        return new Zone(zoneName, address, records);
    }

    public static <D extends Data> Record<D> record(String name, long ttl, D data) {
        return new Record(name, data.getType(), Record.CLASS.IN, ttl, data, false);
    }

    public static <D extends Data> Record<D> record(DnsName name, long ttl, D data) {
        return new Record(name, data.getType(), Record.CLASS.IN, ttl, data, false);
    }

    public static <D extends Data> Record<D> record(String name, D data) {
        return DnsWorld.record(name, 3600L, data);
    }

    public static <D extends Data> Record<D> record(DnsName name, D data) {
        return DnsWorld.record(name, 3600L, data);
    }

    public static A a(byte[] ip) {
        return new A(ip);
    }

    public static A a(CharSequence ipCharSequence) {
        return new A(ipCharSequence);
    }

    public static AAAA aaaa(byte[] ip) {
        return new AAAA(ip);
    }

    public static AAAA CharSequence(CharSequence ipCharSequence) {
        return new AAAA(ipCharSequence);
    }

    public static CNAME cname(String name) {
        return DnsWorld.cname(DnsName.from((String)name));
    }

    public static CNAME cname(DnsName name) {
        return new CNAME(name);
    }

    public static DNSKEY dnskey(int flags, int protocol, DnssecConstants.SignatureAlgorithm algorithm, byte[] key) {
        return new DNSKEY((short)flags, (byte)protocol, algorithm, key);
    }

    public static DNSKEY dnskey(int flags, DnssecConstants.SignatureAlgorithm algorithm, byte[] key) {
        return DnsWorld.dnskey(flags, 3, algorithm, key);
    }

    public static DS ds(int keyTag, DnssecConstants.SignatureAlgorithm algorithm, DnssecConstants.DigestAlgorithm digestType, byte[] digest) {
        return new DS(keyTag, algorithm, digestType, digest);
    }

    public static DS ds(int keyTag, DnssecConstants.SignatureAlgorithm algorithm, byte digestType, byte[] digest) {
        return new DS(keyTag, algorithm, digestType, digest);
    }

    public static DLV dlv(int keyTag, DnssecConstants.SignatureAlgorithm algorithm, DnssecConstants.DigestAlgorithm digestType, byte[] digest) {
        return new DLV(keyTag, algorithm, digestType, digest);
    }

    public static MX mx(int priority, String name) {
        return DnsWorld.mx(priority, DnsName.from((String)name));
    }

    public static MX mx(int priority, DnsName name) {
        return new MX(priority, name);
    }

    public static MX mx(String name) {
        return DnsWorld.mx(10, name);
    }

    public static NS ns(String name) {
        return DnsWorld.ns(DnsName.from((String)name));
    }

    public static NS ns(DnsName name) {
        return new NS(name);
    }

    public static NSEC nsec(String next, Record.TYPE ... types) {
        return DnsWorld.nsec(DnsName.from((String)next), types);
    }

    public static NSEC nsec(DnsName next, Record.TYPE ... types) {
        List<Record.TYPE> typesList = Arrays.asList(types);
        return new NSEC(next, typesList);
    }

    public static NSEC3 nsec3(byte hashAlgorithm, byte flags, int iterations, byte[] salt, byte[] nextHashed, Record.TYPE ... types) {
        List<Record.TYPE> typesList = Arrays.asList(types);
        return new NSEC3(hashAlgorithm, flags, iterations, salt, nextHashed, typesList);
    }

    public static RRSIG rrsig(Record.TYPE typeCovered, DnssecConstants.SignatureAlgorithm algorithm, int labels, long originalTtl, Date signatureExpiration, Date signatureInception, int keyTag, String signerName, byte[] signature) {
        return DnsWorld.rrsig(typeCovered, algorithm, (int)((byte)labels), originalTtl, signatureExpiration, signatureInception, keyTag, DnsName.from((String)signerName), signature);
    }

    public static RRSIG rrsig(Record.TYPE typeCovered, DnssecConstants.SignatureAlgorithm algorithm, int labels, long originalTtl, Date signatureExpiration, Date signatureInception, int keyTag, DnsName signerName, byte[] signature) {
        return new RRSIG(typeCovered, algorithm, (byte)labels, originalTtl, signatureExpiration, signatureInception, keyTag, signerName, signature);
    }

    public static RRSIG rrsig(Record.TYPE typeCovered, int algorithm, int labels, long originalTtl, Date signatureExpiration, Date signatureInception, int keyTag, String signerName, byte[] signature) {
        return DnsWorld.rrsig(typeCovered, algorithm, (int)((byte)labels), originalTtl, signatureExpiration, signatureInception, keyTag, DnsName.from((String)signerName), signature);
    }

    public static RRSIG rrsig(Record.TYPE typeCovered, int algorithm, int labels, long originalTtl, Date signatureExpiration, Date signatureInception, int keyTag, DnsName signerName, byte[] signature) {
        return new RRSIG(typeCovered, algorithm, (byte)labels, originalTtl, signatureExpiration, signatureInception, keyTag, signerName, signature);
    }

    public static SOA soa(String mname, String rname, long serial, int refresh, int retry, int expire, long minimum) {
        return DnsWorld.soa(DnsName.from((String)mname), DnsName.from((String)rname), serial, refresh, retry, expire, minimum);
    }

    public static SOA soa(DnsName mname, DnsName rname, long serial, int refresh, int retry, int expire, long minimum) {
        return new SOA(mname, rname, serial, refresh, retry, expire, minimum);
    }

    public static SRV srv(int priority, int weight, int port, String name) {
        return DnsWorld.srv(priority, weight, port, DnsName.from((String)name));
    }

    public static SRV srv(int priority, int weight, int port, DnsName name) {
        return new SRV(priority, weight, port, name);
    }

    public static SRV srv(int port, String name) {
        return DnsWorld.srv(10, 10, port, name);
    }

    public RrSet lookupRrSetFor(DnsName name, Record.TYPE type) {
        Map<Record.TYPE, RrSet> zoneData = this.worldData.get(name);
        if (zoneData == null) {
            return null;
        }
        return zoneData.get(type);
    }

    public InetAddress lookupSingleAuthoritativeNameserverForZone(DnsName zone) {
        if (zone.isRootLabel()) {
            return DnsRootServer.getIpv4RootServerById((char)'a');
        }
        RrSet nsRrSet = this.lookupRrSetFor(zone, Record.TYPE.NS);
        if (nsRrSet == null) {
            throw new IllegalStateException();
        }
        Record nsRecord = (Record)nsRrSet.records.iterator().next();
        RrSet aRrSet = this.lookupRrSetFor(nsRecord.name, Record.TYPE.A);
        if (aRrSet == null) {
            throw new IllegalStateException();
        }
        Record aRecord = (Record)aRrSet.records.iterator().next();
        try {
            return InetAddress.getByAddress(nsRecord.name.toString(), ((A)aRecord.payloadData).getIp());
        }
        catch (UnknownHostException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static interface PreparedResponse {
        public boolean isResponse(DnsMessage var1, InetAddress var2);

        public DnsMessage getResponse();
    }

    public static class Zone {
        String zoneName;
        InetAddress address;
        List<Record<? extends Data>> records;

        public Zone(String zoneName, InetAddress address, List<Record<? extends Data>> records) {
            this.zoneName = zoneName;
            this.address = address;
            this.records = records;
        }

        public List<RrSet> getRRSets() {
            ArrayList<RrSet.Builder> rrSetBuilders = new ArrayList<RrSet.Builder>();
            block0: for (Record<? extends Data> record : this.records) {
                for (RrSet.Builder builder : rrSetBuilders) {
                    if (!builder.addIfPossible(record)) continue;
                    continue block0;
                }
                rrSetBuilders.add(RrSet.builder().addRecord(record));
            }
            ArrayList<RrSet> rrSets = new ArrayList<RrSet>(rrSetBuilders.size());
            for (RrSet.Builder builder : rrSetBuilders) {
                rrSets.add(builder.build());
            }
            return rrSets;
        }

        boolean isRootZone() {
            return (this.zoneName == null || this.zoneName.isEmpty()) && this.address == null;
        }
    }

    public static class RootAnswerResponse
    extends AnswerResponse {
        public RootAnswerResponse(DnsMessage request, DnsMessage response) {
            super(request, response);
        }

        @Override
        public boolean isResponse(DnsMessage request, InetAddress address) {
            return address.getHostName().endsWith(".root-servers.net") && super.isResponse(request, address);
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "\n" + super.toString();
        }
    }

    public static class AddressedAnswerResponse
    extends AnswerResponse {
        final InetAddress address;

        public AddressedAnswerResponse(InetAddress address, DnsMessage request, DnsMessage response) {
            super(request, response);
            this.address = address;
        }

        @Override
        public boolean isResponse(DnsMessage request, InetAddress address) {
            return address.equals(this.address) && super.isResponse(request, address);
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + ": " + String.valueOf(this.address) + "\n" + super.toString();
        }
    }

    public static class RootHintsResponse
    extends HintsResponse {
        public RootHintsResponse(DnsName ending, DnsMessage response) {
            super(ending, response);
        }

        @Override
        public boolean isResponse(DnsMessage request, InetAddress address) {
            if (request.getQuestion().type == Record.TYPE.DS) {
                return false;
            }
            return address.getHostName().endsWith(".root-servers.net") && this.questionHintable(request);
        }
    }

    public static class AddressedHintsResponse
    extends HintsResponse {
        final InetAddress address;

        public AddressedHintsResponse(InetAddress address, DnsName ending, DnsMessage response) {
            super(ending, response);
            this.address = address;
        }

        @Override
        public boolean isResponse(DnsMessage request, InetAddress address) {
            return address.equals(this.address) && this.questionHintable(request);
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + ": " + String.valueOf(this.address) + "\n" + String.valueOf(this.response);
        }
    }

    public static class AnswerResponse
    implements PreparedResponse {
        final DnsMessage request;
        final DnsMessage response;

        public AnswerResponse(DnsMessage request, DnsMessage response) {
            this.request = request;
            this.response = response;
        }

        @Override
        public boolean isResponse(DnsMessage request, InetAddress address) {
            List questions = this.request.copyQuestions();
            for (Question q : request.questions) {
                if (AnswerResponse.hasQuestion(questions, q)) continue;
                return false;
            }
            return questions.isEmpty();
        }

        @Override
        public DnsMessage getResponse() {
            return this.response;
        }

        private static boolean hasQuestion(Collection<Question> questions, Question q) {
            Iterator<Question> iterator = questions.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().equals((Object)q)) continue;
                iterator.remove();
                return true;
            }
            return false;
        }

        public String toString() {
            return "req: " + String.valueOf(this.request) + "\nres: " + String.valueOf(this.response) + "\n";
        }
    }

    public static abstract class HintsResponse
    implements PreparedResponse {
        final DnsName ending;
        final DnsMessage response;

        public HintsResponse(DnsName ending, DnsMessage response) {
            this.ending = ending;
            this.response = response;
        }

        boolean questionHintable(DnsMessage request) {
            for (Question question : request.questions) {
                if (!question.name.isChildOf(this.ending) && !question.name.equals((Object)this.ending)) continue;
                return true;
            }
            return false;
        }

        @Override
        public DnsMessage getResponse() {
            return this.response;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + String.valueOf(this.ending) + "\n" + String.valueOf(this.response);
        }
    }
}

