/*
 * Decompiled with CFR 0.152.
 */
package org.minidns;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.minidns.DnsWorld;
import org.minidns.cache.LruCache;
import org.minidns.dnsmessage.DnsMessage;
import org.minidns.dnsmessage.Question;
import org.minidns.dnsqueryresult.DnsQueryResult;
import org.minidns.dnsqueryresult.TestWorldDnsQueryResult;
import org.minidns.record.Record;

public class LruCacheTest {
    @Test
    public void testOutdatedCacheEntry() {
        LruCache lruCache = new LruCache(5);
        Question q = new Question((CharSequence)"", Record.TYPE.A);
        TestWorldDnsQueryResult result = LruCacheTest.createSampleMessage(q, 1L);
        DnsMessage question = q.asQueryMessage();
        lruCache.put(question, (DnsQueryResult)result);
        Assertions.assertNull((Object)lruCache.get(question));
        Assertions.assertNull((Object)lruCache.get(question));
        Assertions.assertEquals((long)1L, (long)lruCache.getExpireCount());
        Assertions.assertEquals((long)2L, (long)lruCache.getMissCount());
    }

    @Test
    public void testOverfilledCache() {
        LruCache lruCache = new LruCache(5);
        Question firstQuestion = new Question((CharSequence)"", Record.TYPE.A);
        lruCache.put(firstQuestion.asQueryMessage(), (DnsQueryResult)LruCacheTest.createSampleMessage(firstQuestion));
        Assertions.assertNotNull((Object)lruCache.get(firstQuestion.asQueryMessage()));
        Question question = new Question((CharSequence)"1", Record.TYPE.A);
        lruCache.put(question.asQueryMessage(), (DnsQueryResult)LruCacheTest.createSampleMessage(question));
        question = new Question((CharSequence)"2", Record.TYPE.A);
        lruCache.put(question.asQueryMessage(), (DnsQueryResult)LruCacheTest.createSampleMessage(question));
        question = new Question((CharSequence)"3", Record.TYPE.A);
        lruCache.put(question.asQueryMessage(), (DnsQueryResult)LruCacheTest.createSampleMessage(question));
        question = new Question((CharSequence)"4", Record.TYPE.A);
        lruCache.put(question.asQueryMessage(), (DnsQueryResult)LruCacheTest.createSampleMessage(question));
        question = new Question((CharSequence)"5", Record.TYPE.A);
        lruCache.put(question.asQueryMessage(), (DnsQueryResult)LruCacheTest.createSampleMessage(question));
        Assertions.assertNull((Object)lruCache.get(firstQuestion.asQueryMessage()));
        Assertions.assertEquals((long)0L, (long)lruCache.getExpireCount());
        Assertions.assertEquals((long)1L, (long)lruCache.getMissCount());
        Assertions.assertEquals((long)1L, (long)lruCache.getHitCount());
    }

    private static TestWorldDnsQueryResult createSampleMessage(Question question) {
        return LruCacheTest.createSampleMessage(question, System.currentTimeMillis());
    }

    private static TestWorldDnsQueryResult createSampleMessage(Question question, long receiveTimestamp) {
        DnsMessage.Builder message = DnsMessage.builder();
        message.setReceiveTimestamp(receiveTimestamp);
        message.addAnswer(DnsWorld.record("", DnsWorld.ns("a.root-servers.net")));
        message.addAdditionalResourceRecord(DnsWorld.record("a.root-servers.net", DnsWorld.a("127.0.0.1")));
        DnsMessage responseMessage = message.build();
        DnsMessage query = question.asQueryMessage();
        return new TestWorldDnsQueryResult(query, responseMessage);
    }
}

