/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.source;

import java.io.IOException;
import java.net.InetAddress;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.minidns.dnsmessage.DnsMessage;
import org.minidns.dnsqueryresult.StandardDnsQueryResult;
import org.minidns.source.NetworkDataSource;

public class NetworkDataSourceTest {
    @Test
    public void udpTruncatedTcpFallbackTest() throws IOException {
        int tcpResponseId = 42;
        class TestNetworkDataSource
        extends NetworkDataSource {
            boolean lastQueryUdp = false;

            TestNetworkDataSource() {
            }

            protected DnsMessage queryUdp(DnsMessage message, InetAddress address, int port) throws IOException {
                Assertions.assertFalse((boolean)this.lastQueryUdp);
                this.lastQueryUdp = true;
                DnsMessage.Builder msg = DnsMessage.builder();
                msg.setTruncated(true);
                return msg.build();
            }

            protected DnsMessage queryTcp(DnsMessage message, InetAddress address, int port) throws IOException {
                Assertions.assertTrue((boolean)this.lastQueryUdp);
                this.lastQueryUdp = false;
                return DnsMessage.builder().setId(42).build();
            }
        }
        TestNetworkDataSource world = new TestNetworkDataSource();
        StandardDnsQueryResult result = world.query(DnsMessage.builder().build(), null, 53);
        Assertions.assertEquals((int)42, (int)result.response.id);
        Assertions.assertFalse((boolean)world.lastQueryUdp);
    }
}

