/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.source;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.minidns.MiniDnsException;
import org.minidns.dnsmessage.DnsMessage;
import org.minidns.dnsqueryresult.DnsQueryResult;
import org.minidns.dnsqueryresult.StandardDnsQueryResult;
import org.minidns.source.AbstractDnsDataSource;
import org.minidns.util.MultipleIoException;

public class NetworkDataSource
extends AbstractDnsDataSource {
    protected static final Logger LOGGER = Logger.getLogger(NetworkDataSource.class.getName());

    @Override
    public StandardDnsQueryResult query(DnsMessage message, InetAddress address, int port) throws IOException {
        boolean doUdpFirst;
        AbstractDnsDataSource.QueryMode queryMode = this.getQueryMode();
        switch (queryMode) {
            case dontCare: 
            case udpTcp: {
                doUdpFirst = true;
                break;
            }
            case tcp: {
                doUdpFirst = false;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported query mode: " + String.valueOf((Object)queryMode));
            }
        }
        ArrayList<IOException> ioExceptions = new ArrayList<IOException>(2);
        DnsMessage dnsMessage = null;
        if (doUdpFirst) {
            try {
                dnsMessage = this.queryUdp(message, address, port);
            }
            catch (IOException e) {
                ioExceptions.add(e);
            }
            if (dnsMessage != null && !dnsMessage.truncated) {
                return new StandardDnsQueryResult(address, port, DnsQueryResult.QueryMethod.udp, message, dnsMessage);
            }
            assert (dnsMessage == null || dnsMessage.truncated || ioExceptions.size() == 1);
            LOGGER.log(Level.FINE, "Fallback to TCP because {0}", new Object[]{dnsMessage != null ? "response is truncated" : ioExceptions.get(0)});
        }
        try {
            dnsMessage = this.queryTcp(message, address, port);
        }
        catch (IOException e) {
            ioExceptions.add(e);
            MultipleIoException.throwIfRequired(ioExceptions);
        }
        return new StandardDnsQueryResult(address, port, DnsQueryResult.QueryMethod.tcp, message, dnsMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DnsMessage queryUdp(DnsMessage message, InetAddress address, int port) throws IOException {
        DatagramSocket socket = null;
        DatagramPacket packet = message.asDatagram(address, port);
        byte[] buffer = new byte[this.udpPayloadSize];
        try {
            socket = this.createDatagramSocket();
            socket.setSoTimeout(this.timeout);
            socket.send(packet);
            packet = new DatagramPacket(buffer, buffer.length);
            socket.receive(packet);
            DnsMessage dnsMessage = new DnsMessage(packet.getData());
            if (dnsMessage.id != message.id) {
                throw new MiniDnsException.IdMismatch(message, dnsMessage);
            }
            DnsMessage dnsMessage2 = dnsMessage;
            return dnsMessage2;
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DnsMessage queryTcp(DnsMessage message, InetAddress address, int port) throws IOException {
        try (Socket socket = null;){
            socket = this.createSocket();
            InetSocketAddress socketAddress = new InetSocketAddress(address, port);
            socket.connect(socketAddress, this.timeout);
            socket.setSoTimeout(this.timeout);
            DataOutputStream dos = new DataOutputStream(socket.getOutputStream());
            message.writeTo((OutputStream)dos);
            dos.flush();
            DataInputStream dis = new DataInputStream(socket.getInputStream());
            int length = dis.readUnsignedShort();
            byte[] data = new byte[length];
            for (int read = 0; read < length; read += dis.read(data, read, length - read)) {
            }
            DnsMessage dnsMessage = new DnsMessage(data);
            if (dnsMessage.id != message.id) {
                throw new MiniDnsException.IdMismatch(message, dnsMessage);
            }
            DnsMessage dnsMessage2 = dnsMessage;
            return dnsMessage2;
        }
    }

    protected Socket createSocket() {
        return new Socket();
    }

    protected DatagramSocket createDatagramSocket() throws SocketException {
        return new DatagramSocket();
    }
}

