/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.dnssec;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.security.PrivateKey;
import java.util.Date;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.minidns.AbstractDnsClient;
import org.minidns.DnsCache;
import org.minidns.DnsWorld;
import org.minidns.cache.LruCache;
import org.minidns.constants.DnssecConstants;
import org.minidns.dnsmessage.DnsMessage;
import org.minidns.dnsname.DnsName;
import org.minidns.dnssec.DnssecClient;
import org.minidns.dnssec.DnssecQueryResult;
import org.minidns.dnssec.DnssecUnverifiedReason;
import org.minidns.dnssec.DnssecValidationFailedException;
import org.minidns.dnssec.DnssecWorld;
import org.minidns.iterative.ReliableDnsClient;
import org.minidns.record.A;
import org.minidns.record.DNSKEY;
import org.minidns.record.Data;
import org.minidns.record.RRSIG;
import org.minidns.record.Record;

public class DnssecClientTest {
    private static DnssecConstants.SignatureAlgorithm algorithm = DnssecConstants.SignatureAlgorithm.RSASHA256;
    private static DnssecConstants.DigestAlgorithm digestType = DnssecConstants.DigestAlgorithm.SHA1;
    private static PrivateKey rootPrivateKSK;
    private static DNSKEY rootKSK;
    private static PrivateKey rootPrivateZSK;
    private static DNSKEY rootZSK;
    private static DNSKEY comKSK;
    private static DNSKEY comZSK;
    private static PrivateKey comPrivateZSK;
    private static PrivateKey comPrivateKSK;

    public static DnssecClient constructDnssecClient() {
        DnssecClient client = new DnssecClient((DnsCache)new LruCache(0));
        client.addSecureEntryPoint(DnsName.ROOT, rootKSK.getKey());
        client.setMode(ReliableDnsClient.Mode.iterativeOnly);
        return client;
    }

    void checkCorrectExampleMessage(DnsMessage message) {
        List answers = message.answerSection;
        Assertions.assertEquals((int)1, (int)answers.size());
        Assertions.assertEquals((Object)Record.TYPE.A, (Object)((Record)answers.get((int)0)).type);
        Assertions.assertArrayEquals((byte[])new byte[]{1, 1, 1, 2}, (byte[])((A)((Record)answers.get((int)0)).payloadData).getIp());
    }

    @Test
    public void testBasicValid() throws IOException {
        DnssecClient client = DnssecClientTest.constructDnssecClient();
        DnsWorld.applyZones((AbstractDnsClient)client, (DnsWorld.Zone[])new DnsWorld.Zone[]{DnssecWorld.signedRootZone(DnssecWorld.sign(rootKSK, "", rootPrivateKSK, algorithm, DnsWorld.record((String)"", (Data)rootKSK), DnsWorld.record((String)"", (Data)rootZSK)), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"com", (Data)DnssecWorld.ds("com", digestType, comKSK))), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"com", (Data)DnsWorld.ns((String)"ns.com"))), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"ns.com", (Data)DnsWorld.a((CharSequence)"1.1.1.1")))), DnssecWorld.signedZone("com", "ns.com", "1.1.1.1", DnssecWorld.sign(comKSK, "com", comPrivateKSK, algorithm, DnsWorld.record((String)"com", (Data)comKSK), DnsWorld.record((String)"com", (Data)comZSK)), DnssecWorld.sign(comZSK, "com", comPrivateZSK, algorithm, DnsWorld.record((String)"example.com", (Data)DnsWorld.a((CharSequence)"1.1.1.2"))))});
        DnssecQueryResult result = client.queryDnssec((CharSequence)"example.com", Record.TYPE.A);
        Assertions.assertTrue((boolean)result.isAuthenticData());
        DnsMessage message = result.synthesizedResponse;
        this.checkCorrectExampleMessage(message);
    }

    @Test
    public void testNoSEPAtKSK() throws IOException {
        DnssecClient client = DnssecClientTest.constructDnssecClient();
        DNSKEY comKSK = DnsWorld.dnskey((int)256, (DnssecConstants.SignatureAlgorithm)algorithm, (byte[])DnssecWorld.publicKey(algorithm, comPrivateKSK));
        DnsWorld.applyZones((AbstractDnsClient)client, (DnsWorld.Zone[])new DnsWorld.Zone[]{DnssecWorld.signedRootZone(DnssecWorld.sign(rootKSK, "", rootPrivateKSK, algorithm, DnsWorld.record((String)"", (Data)rootKSK), DnsWorld.record((String)"", (Data)rootZSK)), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"com", (Data)DnssecWorld.ds("com", digestType, comKSK))), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"com", (Data)DnsWorld.ns((String)"ns.com"))), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"ns.com", (Data)DnsWorld.a((CharSequence)"1.1.1.1")))), DnssecWorld.signedZone("com", "ns.com", "1.1.1.1", DnssecWorld.sign(comKSK, "com", comPrivateKSK, algorithm, DnsWorld.record((String)"com", (Data)comKSK), DnsWorld.record((String)"com", (Data)comZSK)), DnssecWorld.sign(comZSK, "com", comPrivateZSK, algorithm, DnsWorld.record((String)"example.com", (Data)DnsWorld.a((CharSequence)"1.1.1.2"))))});
        DnssecQueryResult result = client.queryDnssec((CharSequence)"example.com", Record.TYPE.A);
        Assertions.assertTrue((boolean)result.isAuthenticData());
        DnsMessage message = result.synthesizedResponse;
        this.checkCorrectExampleMessage(message);
    }

    @Test
    public void testSingleZSK() throws IOException {
        DnssecClient client = DnssecClientTest.constructDnssecClient();
        DnsWorld.applyZones((AbstractDnsClient)client, (DnsWorld.Zone[])new DnsWorld.Zone[]{DnssecWorld.signedRootZone(DnssecWorld.sign(rootKSK, "", rootPrivateKSK, algorithm, DnsWorld.record((String)"", (Data)rootKSK), DnsWorld.record((String)"", (Data)rootZSK)), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"com", (Data)DnssecWorld.ds("com", digestType, comKSK))), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"com", (Data)DnsWorld.ns((String)"ns.com"))), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"ns.com", (Data)DnsWorld.a((CharSequence)"1.1.1.1")))), DnssecWorld.signedZone("com", "ns.com", "1.1.1.1", DnssecWorld.sign(comKSK, "com", comPrivateKSK, algorithm, DnsWorld.record((String)"com", (Data)comKSK)), DnssecWorld.sign(comKSK, "com", comPrivateKSK, algorithm, DnsWorld.record((String)"example.com", (Data)DnsWorld.a((CharSequence)"1.1.1.2"))))});
        DnssecQueryResult result = client.queryDnssec((CharSequence)"example.com", Record.TYPE.A);
        Assertions.assertTrue((boolean)result.isAuthenticData());
        DnsMessage message = result.synthesizedResponse;
        this.checkCorrectExampleMessage(message);
    }

    @Test
    public void testMissingDelegation() throws IOException {
        DnssecClient client = DnssecClientTest.constructDnssecClient();
        DnsWorld.applyZones((AbstractDnsClient)client, (DnsWorld.Zone[])new DnsWorld.Zone[]{DnssecWorld.signedRootZone(DnssecWorld.sign(rootKSK, "", rootPrivateKSK, algorithm, DnsWorld.record((String)"", (Data)rootKSK), DnsWorld.record((String)"", (Data)rootZSK)), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"com", (Data)DnsWorld.ns((String)"ns.com"))), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"ns.com", (Data)DnsWorld.a((CharSequence)"1.1.1.1")))), DnssecWorld.signedZone("com", "ns.com", "1.1.1.1", DnssecWorld.sign(comKSK, "com", comPrivateKSK, algorithm, DnsWorld.record((String)"com", (Data)comKSK), DnsWorld.record((String)"com", (Data)comZSK)), DnssecWorld.sign(comZSK, "com", comPrivateZSK, algorithm, DnsWorld.record((String)"example.com", (Data)DnsWorld.a((CharSequence)"1.1.1.2"))))});
        Assertions.assertThrows(DnssecValidationFailedException.AuthorityDoesNotContainSoa.class, () -> client.queryDnssec((CharSequence)"example.com", Record.TYPE.A));
    }

    @Test
    public void testUnsignedRoot() throws IOException {
        DnssecClient client = DnssecClientTest.constructDnssecClient();
        DnsWorld.applyZones((AbstractDnsClient)client, (DnsWorld.Zone[])new DnsWorld.Zone[]{DnsWorld.rootZone((Record[])new Record[]{DnsWorld.record((String)"com", (Data)DnssecWorld.ds("com", digestType, comKSK)), DnsWorld.record((String)"com", (Data)DnsWorld.ns((String)"ns.com")), DnsWorld.record((String)"ns.com", (Data)DnsWorld.a((CharSequence)"1.1.1.1"))}), DnssecWorld.signedZone("com", "ns.com", "1.1.1.1", DnssecWorld.sign(comKSK, "com", comPrivateKSK, algorithm, DnsWorld.record((String)"com", (Data)comKSK), DnsWorld.record((String)"com", (Data)comZSK)), DnssecWorld.sign(comZSK, "com", comPrivateZSK, algorithm, DnsWorld.record((String)"example.com", (Data)DnsWorld.a((CharSequence)"1.1.1.2"))))});
        DnssecQueryResult result = client.queryDnssec((CharSequence)"example.com", Record.TYPE.A);
        Assertions.assertFalse((boolean)result.isAuthenticData());
        DnsMessage message = result.synthesizedResponse;
        this.checkCorrectExampleMessage(message);
    }

    @Test
    public void testNoRootSecureEntryPoint() throws IOException {
        DnssecClient client = DnssecClientTest.constructDnssecClient();
        client.clearSecureEntryPoints();
        DnsWorld.applyZones((AbstractDnsClient)client, (DnsWorld.Zone[])new DnsWorld.Zone[]{DnssecWorld.signedRootZone(DnssecWorld.sign(rootKSK, "", rootPrivateKSK, algorithm, DnsWorld.record((String)"", (Data)rootKSK), DnsWorld.record((String)"", (Data)rootZSK)), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"com", (Data)DnssecWorld.ds("com", digestType, comKSK))), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"com", (Data)DnsWorld.ns((String)"ns.com"))), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"ns.com", (Data)DnsWorld.a((CharSequence)"1.1.1.1")))), DnssecWorld.signedZone("com", "ns.com", "1.1.1.1", DnssecWorld.sign(comKSK, "com", comPrivateKSK, algorithm, DnsWorld.record((String)"com", (Data)comKSK), DnsWorld.record((String)"com", (Data)comZSK)), DnssecWorld.sign(comZSK, "com", comPrivateZSK, algorithm, DnsWorld.record((String)"example.com", (Data)DnsWorld.a((CharSequence)"1.1.1.2"))))});
        DnssecQueryResult result = client.queryDnssec((CharSequence)"example.com", Record.TYPE.A);
        Assertions.assertFalse((boolean)result.isAuthenticData());
        DnsMessage message = result.synthesizedResponse;
        this.checkCorrectExampleMessage(message);
        Assertions.assertEquals((int)1, (int)result.getUnverifiedReasons().size());
        Assertions.assertTrue((boolean)(result.getUnverifiedReasons().iterator().next() instanceof DnssecUnverifiedReason.NoRootSecureEntryPointReason));
    }

    @Test
    public void testUnsignedZone() throws IOException {
        DnssecClient client = DnssecClientTest.constructDnssecClient();
        DnsWorld.applyZones((AbstractDnsClient)client, (DnsWorld.Zone[])new DnsWorld.Zone[]{DnssecWorld.signedRootZone(DnssecWorld.sign(rootKSK, "", rootPrivateKSK, algorithm, DnsWorld.record((String)"", (Data)rootKSK), DnsWorld.record((String)"", (Data)rootZSK)), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"com", (Data)DnssecWorld.ds("com", digestType, comKSK))), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"com", (Data)DnsWorld.ns((String)"ns.com"))), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"ns.com", (Data)DnsWorld.a((CharSequence)"1.1.1.1")))), DnsWorld.zone((String)"com", (String)"ns.com", (String)"1.1.1.1", (Record[])new Record[]{DnsWorld.record((String)"example.com", (Data)DnsWorld.a((CharSequence)"1.1.1.2"))})});
        DnssecQueryResult result = client.queryDnssec((CharSequence)"example.com", Record.TYPE.A);
        Assertions.assertFalse((boolean)result.isAuthenticData());
        DnsMessage message = result.dnsQueryResult.response;
        this.checkCorrectExampleMessage(message);
    }

    @Test
    public void testInvalidDNSKEY() throws IOException {
        DnssecClient client = DnssecClientTest.constructDnssecClient();
        DnsWorld.applyZones((AbstractDnsClient)client, (DnsWorld.Zone[])new DnsWorld.Zone[]{DnssecWorld.signedRootZone(DnssecWorld.sign(rootKSK, "", rootPrivateKSK, algorithm, DnsWorld.record((String)"", (Data)rootKSK), DnsWorld.record((String)"", (Data)rootZSK)), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"com", (Data)DnssecWorld.ds("com", digestType, comKSK))), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"com", (Data)DnsWorld.ns((String)"ns.com"))), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"ns.com", (Data)DnsWorld.a((CharSequence)"1.1.1.1")))), DnssecWorld.signedZone("com", "ns.com", "1.1.1.1", DnssecWorld.sign(comKSK, "com", comPrivateKSK, algorithm, DnsWorld.record((String)"com", (Data)comKSK)), DnssecWorld.sign(comZSK, "com", comPrivateZSK, algorithm, DnsWorld.record((String)"example.com", (Data)DnsWorld.a((CharSequence)"1.1.1.2"))))});
        Assertions.assertThrows(DnssecValidationFailedException.class, () -> client.query((CharSequence)"example.com", Record.TYPE.A));
    }

    @Test
    public void testNoDNSKEY() throws IOException {
        DnssecClient client = DnssecClientTest.constructDnssecClient();
        DnsWorld.applyZones((AbstractDnsClient)client, (DnsWorld.Zone[])new DnsWorld.Zone[]{DnssecWorld.signedRootZone(DnssecWorld.sign(rootKSK, "", rootPrivateKSK, algorithm, DnsWorld.record((String)"", (Data)rootKSK), DnsWorld.record((String)"", (Data)rootZSK)), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"com", (Data)DnssecWorld.ds("com", digestType, comKSK))), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"com", (Data)DnsWorld.ns((String)"ns.com"))), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"ns.com", (Data)DnsWorld.a((CharSequence)"1.1.1.1")))), DnssecWorld.signedZone("com", "ns.com", "1.1.1.1", DnssecWorld.sign(comZSK, "com", comPrivateZSK, algorithm, DnsWorld.record((String)"example.com", (Data)DnsWorld.a((CharSequence)"1.1.1.2"))))});
        Assertions.assertThrows(DnssecValidationFailedException.class, () -> client.query((CharSequence)"example.com", Record.TYPE.A));
    }

    @Test
    public void testInvalidRRSIG() throws IOException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        DnssecClient client = DnssecClientTest.constructDnssecClient();
        Record<RRSIG> invalidRrSig = DnssecWorld.rrsigRecord(comZSK, "com", comPrivateZSK, algorithm, DnsWorld.record((String)"example.com", (Data)DnsWorld.a((CharSequence)"1.1.1.2")));
        RRSIG soonToBeInvalidRrSig = (RRSIG)invalidRrSig.payloadData;
        Field signature = soonToBeInvalidRrSig.getClass().getDeclaredField("signature");
        signature.setAccessible(true);
        byte[] signatureMod = (byte[])signature.get(soonToBeInvalidRrSig);
        int n = signatureMod.length / 2;
        signatureMod[n] = (byte)(signatureMod[n] + 1);
        DnsWorld.applyZones((AbstractDnsClient)client, (DnsWorld.Zone[])new DnsWorld.Zone[]{DnssecWorld.signedRootZone(DnssecWorld.sign(rootKSK, "", rootPrivateKSK, algorithm, DnsWorld.record((String)"", (Data)rootKSK), DnsWorld.record((String)"", (Data)rootZSK)), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"com", (Data)DnssecWorld.ds("com", digestType, comKSK))), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"com", (Data)DnsWorld.ns((String)"ns.com"))), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"ns.com", (Data)DnsWorld.a((CharSequence)"1.1.1.1")))), DnsWorld.zone((String)"com", (String)"ns.com", (String)"1.1.1.1", (Record[])new Record[]{DnsWorld.record((String)"com", (Data)comKSK), DnsWorld.record((String)"com", (Data)comZSK), DnsWorld.record((String)"example.com", (Data)DnsWorld.a((CharSequence)"1.1.1.2")), invalidRrSig})});
        Assertions.assertThrows(DnssecValidationFailedException.class, () -> client.query((CharSequence)"example.com", Record.TYPE.A));
    }

    @Test
    public void testUnknownAlgorithm() throws IOException {
        DnssecClient client = DnssecClientTest.constructDnssecClient();
        Date signatureExpiration = new Date(System.currentTimeMillis() + 1209600000L);
        Date signatureInception = new Date(System.currentTimeMillis() - 1209600000L);
        RRSIG unknownRrsig = DnsWorld.rrsig((Record.TYPE)Record.TYPE.A, (int)213, (int)2, (long)3600L, (Date)signatureExpiration, (Date)signatureInception, (int)comZSK.getKeyTag(), (String)"com", (byte[])new byte[0]);
        DnsWorld.applyZones((AbstractDnsClient)client, (DnsWorld.Zone[])new DnsWorld.Zone[]{DnssecWorld.signedRootZone(DnssecWorld.sign(rootKSK, "", rootPrivateKSK, algorithm, DnsWorld.record((String)"", (Data)rootKSK), DnsWorld.record((String)"", (Data)rootZSK)), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"com", (Data)DnssecWorld.ds("com", digestType, comKSK))), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"com", (Data)DnsWorld.ns((String)"ns.com"))), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"ns.com", (Data)DnsWorld.a((CharSequence)"1.1.1.1")))), DnsWorld.zone((String)"com", (String)"ns.com", (String)"1.1.1.1", (Record[])new Record[]{DnsWorld.record((String)"com", (Data)comKSK), DnsWorld.record((String)"com", (Data)comZSK), DnsWorld.record((String)"example.com", (Data)DnsWorld.a((CharSequence)"1.1.1.2")), DnsWorld.record((String)"example.com", (Data)unknownRrsig)})});
        DnssecQueryResult result = client.queryDnssec((CharSequence)"example.com", Record.TYPE.A);
        Assertions.assertFalse((boolean)result.isAuthenticData());
        DnsMessage message = result.synthesizedResponse;
        this.checkCorrectExampleMessage(message);
    }

    @Test
    public void testInvalidDelegation() throws IOException {
        DnssecClient client = DnssecClientTest.constructDnssecClient();
        DnsWorld.applyZones((AbstractDnsClient)client, (DnsWorld.Zone[])new DnsWorld.Zone[]{DnssecWorld.signedRootZone(DnssecWorld.sign(rootKSK, "", rootPrivateKSK, algorithm, DnsWorld.record((String)"", (Data)rootKSK), DnsWorld.record((String)"", (Data)rootZSK)), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"com", (Data)DnssecWorld.ds((int)comKSK.getKeyTag(), (DnssecConstants.SignatureAlgorithm)algorithm, (DnssecConstants.DigestAlgorithm)digestType, (byte[])new byte[0]))), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"com", (Data)DnsWorld.ns((String)"ns.com"))), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"ns.com", (Data)DnsWorld.a((CharSequence)"1.1.1.1")))), DnssecWorld.signedZone("com", "ns.com", "1.1.1.1", DnssecWorld.sign(comKSK, "com", comPrivateKSK, algorithm, DnsWorld.record((String)"com", (Data)comKSK), DnsWorld.record((String)"com", (Data)comZSK)), DnssecWorld.sign(comZSK, "com", comPrivateZSK, algorithm, DnsWorld.record((String)"example.com", (Data)DnsWorld.a((CharSequence)"1.1.1.2"))))});
        Assertions.assertThrows(DnssecValidationFailedException.class, () -> client.query((CharSequence)"example.com", Record.TYPE.A));
    }

    @Test
    public void testUnknownDelegationDigestType() throws IOException {
        DnssecClient client = DnssecClientTest.constructDnssecClient();
        DnsWorld.applyZones((AbstractDnsClient)client, (DnsWorld.Zone[])new DnsWorld.Zone[]{DnssecWorld.signedRootZone(DnssecWorld.sign(rootKSK, "", rootPrivateKSK, algorithm, DnsWorld.record((String)"", (Data)rootKSK), DnsWorld.record((String)"", (Data)rootZSK)), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"com", (Data)DnssecWorld.ds((int)comKSK.getKeyTag(), (DnssecConstants.SignatureAlgorithm)algorithm, (byte)-43, (byte[])new byte[0]))), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"com", (Data)DnsWorld.ns((String)"ns.com"))), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"ns.com", (Data)DnsWorld.a((CharSequence)"1.1.1.1")))), DnssecWorld.signedZone("com", "ns.com", "1.1.1.1", DnssecWorld.sign(comKSK, "com", comPrivateKSK, algorithm, DnsWorld.record((String)"com", (Data)comKSK), DnsWorld.record((String)"com", (Data)comZSK)), DnssecWorld.sign(comZSK, "com", comPrivateZSK, algorithm, DnsWorld.record((String)"example.com", (Data)DnsWorld.a((CharSequence)"1.1.1.2"))))});
        DnssecQueryResult result = client.queryDnssec((CharSequence)"example.com", Record.TYPE.A);
        Assertions.assertFalse((boolean)result.isAuthenticData());
        DnsMessage message = result.synthesizedResponse;
        this.checkCorrectExampleMessage(message);
    }

    @Test
    public void testSignatureOutOfDate() throws IOException {
        DnssecClient client = DnssecClientTest.constructDnssecClient();
        Date signatureExpiration = new Date(System.currentTimeMillis() - 1209600000L);
        Date signatureInception = new Date(System.currentTimeMillis() - 2419200000L);
        RRSIG outOfDateSig = DnsWorld.rrsig((Record.TYPE)Record.TYPE.A, (DnssecConstants.SignatureAlgorithm)algorithm, (int)2, (long)3600L, (Date)signatureExpiration, (Date)signatureInception, (int)comZSK.getKeyTag(), (String)"com", (byte[])new byte[0]);
        DnsWorld.applyZones((AbstractDnsClient)client, (DnsWorld.Zone[])new DnsWorld.Zone[]{DnssecWorld.signedRootZone(DnssecWorld.sign(rootKSK, "", rootPrivateKSK, algorithm, DnsWorld.record((String)"", (Data)rootKSK), DnsWorld.record((String)"", (Data)rootZSK)), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"com", (Data)DnssecWorld.ds("com", digestType, comKSK))), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"com", (Data)DnsWorld.ns((String)"ns.com"))), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"ns.com", (Data)DnsWorld.a((CharSequence)"1.1.1.1")))), DnssecWorld.signedZone("com", "ns.com", "1.1.1.1", DnssecWorld.sign(comKSK, "com", comPrivateKSK, algorithm, DnsWorld.record((String)"com", (Data)comKSK), DnsWorld.record((String)"com", (Data)comZSK)), DnssecWorld.sign(comPrivateZSK, outOfDateSig, DnsWorld.record((String)"example.com", (Data)DnsWorld.a((CharSequence)"1.1.1.2"))))});
        DnssecQueryResult result = client.queryDnssec((CharSequence)"example.com", Record.TYPE.A);
        Assertions.assertFalse((boolean)result.isAuthenticData());
        DnsMessage message = result.synthesizedResponse;
        this.checkCorrectExampleMessage(message);
    }

    @Test
    public void testSignatureInFuture() throws IOException {
        DnssecClient client = DnssecClientTest.constructDnssecClient();
        Date signatureExpiration = new Date(System.currentTimeMillis() + 2419200000L);
        Date signatureInception = new Date(System.currentTimeMillis() + 1209600000L);
        RRSIG outOfDateSig = DnsWorld.rrsig((Record.TYPE)Record.TYPE.A, (DnssecConstants.SignatureAlgorithm)algorithm, (int)2, (long)3600L, (Date)signatureExpiration, (Date)signatureInception, (int)comZSK.getKeyTag(), (String)"com", (byte[])new byte[0]);
        DnsWorld.applyZones((AbstractDnsClient)client, (DnsWorld.Zone[])new DnsWorld.Zone[]{DnssecWorld.signedRootZone(DnssecWorld.sign(rootKSK, "", rootPrivateKSK, algorithm, DnsWorld.record((String)"", (Data)rootKSK), DnsWorld.record((String)"", (Data)rootZSK)), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"com", (Data)DnssecWorld.ds("com", digestType, comKSK))), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"com", (Data)DnsWorld.ns((String)"ns.com"))), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"ns.com", (Data)DnsWorld.a((CharSequence)"1.1.1.1")))), DnssecWorld.signedZone("com", "ns.com", "1.1.1.1", DnssecWorld.sign(comKSK, "com", comPrivateKSK, algorithm, DnsWorld.record((String)"com", (Data)comKSK), DnsWorld.record((String)"com", (Data)comZSK)), DnssecWorld.sign(comPrivateZSK, outOfDateSig, DnsWorld.record((String)"example.com", (Data)DnsWorld.a((CharSequence)"1.1.1.2"))))});
        DnssecQueryResult result = client.queryDnssec((CharSequence)"example.com", Record.TYPE.A);
        Assertions.assertFalse((boolean)result.isAuthenticData());
        DnsMessage message = result.synthesizedResponse;
        this.checkCorrectExampleMessage(message);
    }

    @Test
    public void testValidNSEC() throws Exception {
        DnssecClient client = DnssecClientTest.constructDnssecClient();
        DnsWorld world = DnsWorld.applyZones((AbstractDnsClient)client, (DnsWorld.Zone[])new DnsWorld.Zone[]{DnssecWorld.signedRootZone(DnssecWorld.sign(rootKSK, "", rootPrivateKSK, algorithm, DnsWorld.record((String)"", (Data)rootKSK), DnsWorld.record((String)"", (Data)rootZSK)), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"com", (Data)DnssecWorld.ds("com", digestType, comKSK))), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"com", (Data)DnsWorld.ns((String)"ns.com"))), DnssecWorld.sign(rootZSK, "", rootPrivateZSK, algorithm, DnsWorld.record((String)"ns.com", (Data)DnsWorld.a((CharSequence)"1.1.1.1")))), DnssecWorld.signedZone("com", "ns.com", "1.1.1.1", DnssecWorld.sign(comKSK, "com", comPrivateKSK, algorithm, DnsWorld.record((String)"com", (Data)comKSK), DnsWorld.record((String)"com", (Data)comZSK)), DnssecWorld.sign(comZSK, "com", comPrivateZSK, algorithm, DnsWorld.record((String)"example.com", (Data)DnsWorld.a((CharSequence)"1.1.1.2"))))});
        DnsMessage.Builder nsecMessage = DnsMessage.builder();
        List<Record<? extends Data>> records = DnssecWorld.merge(DnssecWorld.sign(comZSK, "com", comPrivateZSK, algorithm, DnsWorld.record((String)"example.com", (Data)DnsWorld.nsec((String)"www.example.com", (Record.TYPE[])new Record.TYPE[]{Record.TYPE.A}))), DnssecWorld.sign(comZSK, "com", comPrivateZSK, algorithm, DnsWorld.record((String)"example.com", (Data)DnsWorld.soa((String)"sns.dns.icann.org", (String)"noc.dns.icann.org", (long)2015081265L, (int)7200, (int)3600, (int)1209600, (long)3600L))));
        nsecMessage.setNameserverRecords(records);
        nsecMessage.setAuthoritativeAnswer(true);
        world.addPreparedResponse((DnsWorld.PreparedResponse)new DnssecWorld.AddressedNsecResponse(InetAddress.getByAddress("ns.com", new byte[]{1, 1, 1, 1}), nsecMessage.build()));
        DnssecQueryResult result = client.queryDnssec((CharSequence)"nsec.example.com", Record.TYPE.A);
        client.setStripSignatureRecords(false);
        DnsMessage message = result.synthesizedResponse;
        Assertions.assertEquals((int)0, (int)message.answerSection.size());
        Assertions.assertTrue((boolean)message.authenticData);
    }

    @Test
    public void testValidDLV() throws IOException {
        DnssecClient client = DnssecClientTest.constructDnssecClient();
        DnsWorld dnsWorld = DnsWorld.applyZones((AbstractDnsClient)client, (DnsWorld.Zone[])new DnsWorld.Zone[]{DnssecWorld.signedRootZone(DnssecWorld.selfSignDnskeyRrSet(""), DnssecWorld.sign("", DnssecWorld.ds("dlv")), DnssecWorld.sign("", DnsWorld.record((String)"dlv", (Data)DnsWorld.ns((String)"ns.com"))), DnssecWorld.sign("", DnsWorld.record((String)"com", (Data)DnsWorld.ns((String)"ns.com"))), DnssecWorld.sign("", DnsWorld.record((String)"ns.com", (Data)DnsWorld.a((CharSequence)"1.1.1.1")))), DnssecWorld.signedZone("com", "ns.com", "1.1.1.1", DnssecWorld.selfSignDnskeyRrSet("com"), DnssecWorld.sign("com", DnsWorld.record((String)"example.com", (Data)DnsWorld.a((CharSequence)"1.1.1.2")))), DnssecWorld.signedZone("dlv", "ns.com", "1.1.1.1", DnssecWorld.selfSignDnskeyRrSet("dlv"), DnssecWorld.sign("dlv", DnsWorld.record((String)"com.dlv", (Data)DnssecWorld.dlv("com", digestType, comKSK))))});
        DnssecWorld.addNsec(dnsWorld, "", "a.root-servers.net", "com", "dlv", Record.TYPE.NS);
        client.configureLookasideValidation(DnsName.from((String)"dlv"));
        DnssecQueryResult result = client.queryDnssec((CharSequence)"example.com", Record.TYPE.A);
        Assertions.assertTrue((boolean)result.isAuthenticData());
        DnsMessage message = result.synthesizedResponse;
        this.checkCorrectExampleMessage(message);
        client.disableLookasideValidation();
        result = client.queryDnssec((CharSequence)"example.com", Record.TYPE.A);
        Assertions.assertFalse((boolean)result.isAuthenticData());
        message = result.synthesizedResponse;
        this.checkCorrectExampleMessage(message);
    }

    static {
        DnssecWorld.DnssecData rootDnssecData = DnssecWorld.getDnssecDataFor("");
        rootPrivateKSK = rootDnssecData.privateKsk;
        rootKSK = rootDnssecData.ksk;
        rootPrivateZSK = rootDnssecData.privateZsk;
        rootZSK = rootDnssecData.zsk;
        DnssecWorld.DnssecData comDnssecData = DnssecWorld.getDnssecDataFor("com");
        comPrivateKSK = comDnssecData.privateKsk;
        comKSK = comDnssecData.ksk;
        comPrivateZSK = comDnssecData.privateZsk;
        comZSK = comDnssecData.zsk;
    }
}

