/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.dnssec;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.minidns.DnsWorld;
import org.minidns.constants.DnssecConstants;
import org.minidns.dnsmessage.DnsMessage;
import org.minidns.dnsname.DnsName;
import org.minidns.dnssec.DigestCalculator;
import org.minidns.dnssec.Verifier;
import org.minidns.dnssec.algorithms.AlgorithmMap;
import org.minidns.record.DLV;
import org.minidns.record.DNSKEY;
import org.minidns.record.DS;
import org.minidns.record.Data;
import org.minidns.record.NSEC;
import org.minidns.record.RRSIG;
import org.minidns.record.Record;
import org.minidns.util.InetAddressUtil;

public class DnssecWorld
extends DnsWorld {
    public static final DnssecConstants.SignatureAlgorithm DEFAULT_DNSSEC_ALGORITHM = DnssecConstants.SignatureAlgorithm.RSASHA256;
    public static final DnssecConstants.DigestAlgorithm DEFAULT_DIGEST_ALGORITHM = DnssecConstants.DigestAlgorithm.SHA1;
    private static final Map<DnsName, DnssecData> DNSSEC_DATA = new HashMap<DnsName, DnssecData>();

    public static DnssecData getDnssecDataFor(CharSequence zone) {
        return DnssecWorld.getDnssecDataFor(DnsName.from((CharSequence)zone));
    }

    public static DnssecData getDnssecDataFor(DnsName zone) {
        DnssecData dnssecData = DNSSEC_DATA.get(zone);
        if (dnssecData != null) {
            return dnssecData;
        }
        DnssecConstants.SignatureAlgorithm algorithm = DEFAULT_DNSSEC_ALGORITHM;
        PrivateKey privateKsk = DnssecWorld.generatePrivateKey(algorithm, 2048);
        DNSKEY ksk = DnssecWorld.dnskey((int)257, (DnssecConstants.SignatureAlgorithm)algorithm, (byte[])DnssecWorld.publicKey(algorithm, privateKsk));
        PrivateKey privateZsk = DnssecWorld.generatePrivateKey(algorithm, 1024);
        DNSKEY zsk = DnssecWorld.dnskey((int)256, (DnssecConstants.SignatureAlgorithm)algorithm, (byte[])DnssecWorld.publicKey(algorithm, privateZsk));
        dnssecData = new DnssecData(zone, ksk, privateKsk, zsk, privateZsk, algorithm);
        DNSSEC_DATA.put(zone, dnssecData);
        return dnssecData;
    }

    public static DnsWorld.Zone signedRootZone(SignedRRSet ... rrSets) {
        return new DnsWorld.Zone("", null, DnssecWorld.merge(rrSets));
    }

    public static DnsWorld.Zone signedZone(String zoneName, String nsName, String nsIp, SignedRRSet ... records) {
        Inet4Address inet4Address = InetAddressUtil.ipv4From((CharSequence)nsIp);
        try {
            return DnssecWorld.signedZone(zoneName, InetAddress.getByAddress(nsName, inet4Address.getAddress()), records);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public static DnsWorld.Zone signedZone(String zoneName, InetAddress address, SignedRRSet ... rrSets) {
        return new DnsWorld.Zone(zoneName, address, DnssecWorld.merge(rrSets));
    }

    public static List<Record<? extends Data>> merge(SignedRRSet ... rrSets) {
        ArrayList<Record<? extends Data>> recordList = new ArrayList<Record<? extends Data>>();
        for (SignedRRSet rrSet : rrSets) {
            recordList.add(rrSet.signature);
            recordList.addAll(Arrays.asList(rrSet.records));
        }
        return recordList;
    }

    @SafeVarargs
    public static SignedRRSet sign(DNSKEY key, String signerName, PrivateKey privateKey, DnssecConstants.SignatureAlgorithm algorithm, Record<? extends Data> ... records) {
        return new SignedRRSet(records, DnssecWorld.rrsigRecord(key, signerName, privateKey, algorithm, records));
    }

    @SafeVarargs
    public static SignedRRSet sign(DNSKEY key, DnsName signerName, PrivateKey privateKey, DnssecConstants.SignatureAlgorithm algorithm, Record<? extends Data> ... records) {
        return new SignedRRSet(records, DnssecWorld.rrsigRecord(key, signerName, privateKey, algorithm, records));
    }

    @SafeVarargs
    public static SignedRRSet sign(PrivateKey privateKey, RRSIG rrsig, Record<? extends Data> ... records) {
        return new SignedRRSet(records, DnssecWorld.rrsigRecord(privateKey, rrsig, records));
    }

    @SafeVarargs
    public static SignedRRSet sign(CharSequence signerName, Record<? extends Data> ... records) {
        return DnssecWorld.sign(DnsName.from((CharSequence)signerName), records);
    }

    @SafeVarargs
    public static SignedRRSet sign(DnsName signerName, Record<? extends Data> ... records) {
        PrivateKey privateKey;
        DNSKEY dnskey;
        DnssecData dnssecData = DnssecWorld.getDnssecDataFor(signerName);
        Record.TYPE typeToSign = records[0].type;
        switch (typeToSign) {
            case DNSKEY: {
                dnskey = dnssecData.ksk;
                privateKey = dnssecData.privateKsk;
                break;
            }
            default: {
                dnskey = dnssecData.zsk;
                privateKey = dnssecData.privateZsk;
            }
        }
        return new SignedRRSet(records, DnssecWorld.rrsigRecord(dnskey, signerName, privateKey, dnssecData.signatureAlgorithm, records));
    }

    public static SignedRRSet selfSignDnskeyRrSet(CharSequence zone) {
        return DnssecWorld.selfSignDnskeyRrSet(DnsName.from((CharSequence)zone));
    }

    public static SignedRRSet selfSignDnskeyRrSet(DnsName zone) {
        DnssecData dnssecData = DnssecWorld.getDnssecDataFor(zone);
        return DnssecWorld.sign(zone, DnssecWorld.record((DnsName)zone, (Data)dnssecData.ksk), DnssecWorld.record((DnsName)zone, (Data)dnssecData.zsk));
    }

    @SafeVarargs
    public static Record<RRSIG> rrsigRecord(DNSKEY key, String signerName, PrivateKey privateKey, DnssecConstants.SignatureAlgorithm algorithm, Record<? extends Data> ... records) {
        return DnssecWorld.rrsigRecord(key, DnsName.from((String)signerName), privateKey, algorithm, records);
    }

    public static Record<RRSIG> rrsigRecord(DNSKEY key, DnsName signerName, PrivateKey privateKey, DnssecConstants.SignatureAlgorithm algorithm, Record<? extends Data> ... records) {
        Record.TYPE typeCovered = records[0].type;
        int labels = records[0].name.getLabelCount();
        long originalTtl = records[0].ttl;
        Date signatureExpiration = new Date(System.currentTimeMillis() + 1209600000L);
        Date signatureInception = new Date(System.currentTimeMillis() - 1209600000L);
        RRSIG rrsig = DnssecWorld.rrsig((Record.TYPE)typeCovered, (DnssecConstants.SignatureAlgorithm)algorithm, (int)labels, (long)originalTtl, (Date)signatureExpiration, (Date)signatureInception, (int)key.getKeyTag(), (DnsName)signerName, (byte[])new byte[0]);
        return DnssecWorld.rrsigRecord(privateKey, rrsig, records);
    }

    public static Record<RRSIG> rrsigRecord(PrivateKey privateKey, RRSIG rrsig, Record<? extends Data> ... records) {
        byte[] bytes = Verifier.combine((RRSIG)rrsig, Arrays.asList(records));
        return DnssecWorld.record((DnsName)records[0].name, (long)rrsig.originalTtl, (Data)DnssecWorld.rrsig((Record.TYPE)rrsig.typeCovered, (DnssecConstants.SignatureAlgorithm)rrsig.algorithm, (int)rrsig.labels, (long)rrsig.originalTtl, (Date)rrsig.signatureExpiration, (Date)rrsig.signatureInception, (int)rrsig.keyTag, (DnsName)rrsig.signerName, (byte[])DnssecWorld.sign(privateKey, rrsig.algorithm, bytes))).as(RRSIG.class);
    }

    public static Record<DS> ds(CharSequence zone) {
        return DnssecWorld.ds(DnsName.from((CharSequence)zone));
    }

    public static Record<DS> ds(DnsName zone) {
        DnssecData dnssecData = DnssecWorld.getDnssecDataFor(zone);
        return DnssecWorld.record((DnsName)zone, (Data)DnssecWorld.ds(zone, DEFAULT_DIGEST_ALGORITHM, dnssecData.ksk));
    }

    public static DS ds(String name, DnssecConstants.DigestAlgorithm digestType, DNSKEY dnskey) {
        return DnssecWorld.ds(DnsName.from((String)name), digestType, dnskey);
    }

    public static DS ds(DnsName name, DnssecConstants.DigestAlgorithm digestType, DNSKEY dnskey) {
        return DnssecWorld.ds((int)dnskey.getKeyTag(), (DnssecConstants.SignatureAlgorithm)dnskey.algorithm, (DnssecConstants.DigestAlgorithm)digestType, (byte[])DnssecWorld.calculateDsDigest(name, digestType, dnskey));
    }

    public static DLV dlv(String name, DnssecConstants.DigestAlgorithm digestType, DNSKEY dnskey) {
        return DnssecWorld.dlv(DnsName.from((String)name), digestType, dnskey);
    }

    public static DLV dlv(DnsName name, DnssecConstants.DigestAlgorithm digestType, DNSKEY dnskey) {
        return DnssecWorld.dlv((int)dnskey.getKeyTag(), (DnssecConstants.SignatureAlgorithm)dnskey.algorithm, (DnssecConstants.DigestAlgorithm)digestType, (byte[])DnssecWorld.calculateDsDigest(name, digestType, dnskey));
    }

    public static byte[] calculateDsDigest(DnsName name, DnssecConstants.DigestAlgorithm digestType, DNSKEY dnskey) {
        DigestCalculator digestCalculator = AlgorithmMap.INSTANCE.getDsDigestCalculator(digestType);
        byte[] dnskeyData = dnskey.toByteArray();
        byte[] dnskeyOwner = name.getBytes();
        byte[] combined = new byte[dnskeyOwner.length + dnskeyData.length];
        System.arraycopy(dnskeyOwner, 0, combined, 0, dnskeyOwner.length);
        System.arraycopy(dnskeyData, 0, combined, dnskeyOwner.length, dnskeyData.length);
        return digestCalculator.digest(combined);
    }

    public static byte[] sign(PrivateKey privateKey, DnssecConstants.SignatureAlgorithm algorithm, byte[] content) {
        try {
            Signature signature;
            switch (algorithm) {
                case RSAMD5: {
                    signature = Signature.getInstance("MD5withRSA");
                    break;
                }
                case RSASHA1: 
                case RSASHA1_NSEC3_SHA1: {
                    signature = Signature.getInstance("SHA1withRSA");
                    break;
                }
                case RSASHA256: {
                    signature = Signature.getInstance("SHA256withRSA");
                    break;
                }
                case RSASHA512: {
                    signature = Signature.getInstance("SHA512withRSA");
                    break;
                }
                case DSA: 
                case DSA_NSEC3_SHA1: {
                    signature = Signature.getInstance("SHA1withDSA");
                    break;
                }
                default: {
                    throw new RuntimeException(String.valueOf(algorithm) + " algorithm not yet supported by DNSSECWorld");
                }
            }
            signature.initSign(privateKey);
            signature.update(content);
            byte[] bytes = signature.sign();
            switch (algorithm) {
                case DSA: 
                case DSA_NSEC3_SHA1: {
                    return DnssecWorld.convertAsn1ToRFC((DSAPrivateKey)privateKey, bytes);
                }
            }
            return bytes;
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] convertAsn1ToRFC(DSAPrivateKey privateKey, byte[] bytes) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeByte(privateKey.getParams().getP().bitLength() / 64 - 8);
        dis.skipBytes(2);
        DnssecWorld.streamAsn1Int(dis, dos, 20);
        DnssecWorld.streamAsn1Int(dis, dos, 20);
        return bos.toByteArray();
    }

    public static void streamAsn1Int(DataInputStream dis, DataOutputStream dos, int targetLength) throws IOException {
        dis.skipBytes(1);
        byte s_pad = (byte)(dis.readByte() - targetLength);
        if (s_pad >= 0) {
            dis.skipBytes(s_pad);
            s_pad = 0;
        } else {
            for (int i = 0; i < 1 - s_pad; ++i) {
                dos.writeByte(0);
            }
        }
        byte[] buf = new byte[targetLength + s_pad];
        int bytesRead = dis.read(buf);
        if (bytesRead != buf.length) {
            throw new IOException();
        }
        dos.write(buf);
    }

    public static PrivateKey generatePrivateKey(DnssecConstants.SignatureAlgorithm algorithm, int length) {
        switch (algorithm) {
            case RSAMD5: 
            case RSASHA1: 
            case RSASHA1_NSEC3_SHA1: 
            case RSASHA256: 
            case RSASHA512: {
                return DnssecWorld.generateRSAPrivateKey(length, RSAKeyGenParameterSpec.F4);
            }
            case DSA: 
            case DSA_NSEC3_SHA1: {
                return DnssecWorld.generateDSAPrivateKey(length);
            }
        }
        throw new RuntimeException(String.valueOf(algorithm) + " algorithm not yet supported by DNSSECWorld");
    }

    public static PrivateKey generateRSAPrivateKey(int length, BigInteger publicExponent) {
        try {
            KeyPairGenerator rsa = KeyPairGenerator.getInstance("RSA");
            rsa.initialize(new RSAKeyGenParameterSpec(length, publicExponent));
            KeyPair keyPair = rsa.generateKeyPair();
            return keyPair.getPrivate();
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static PrivateKey generateDSAPrivateKey(int length) {
        try {
            KeyPairGenerator dsa = KeyPairGenerator.getInstance("DSA");
            dsa.initialize(length);
            KeyPair keyPair = dsa.generateKeyPair();
            return keyPair.getPrivate();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] publicKey(DnssecConstants.SignatureAlgorithm algorithm, PrivateKey privateKey) {
        switch (algorithm) {
            case RSAMD5: 
            case RSASHA1: 
            case RSASHA1_NSEC3_SHA1: 
            case RSASHA256: 
            case RSASHA512: {
                return DnssecWorld.getRSAPublicKey((RSAPrivateCrtKey)privateKey);
            }
            case DSA: 
            case DSA_NSEC3_SHA1: {
                return DnssecWorld.getDSAPublicKey((DSAPrivateKey)privateKey);
            }
        }
        throw new RuntimeException(String.valueOf(algorithm) + " algorithm not yet supported by DNSSECWorld");
    }

    private static byte[] getDSAPublicKey(DSAPrivateKey privateKey) {
        DSAParams params = privateKey.getParams();
        BigInteger g = params.getG();
        BigInteger p = params.getP();
        BigInteger q = params.getQ();
        BigInteger x = privateKey.getX();
        BigInteger y = g.modPow(x, p);
        int t = p.bitLength() / 64 - 8;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeByte(t);
            dos.write(DnssecWorld.toUnsignedByteArray(q, 20));
            dos.write(DnssecWorld.toUnsignedByteArray(p, t * 8 + 64));
            dos.write(DnssecWorld.toUnsignedByteArray(g, t * 8 + 64));
            dos.write(DnssecWorld.toUnsignedByteArray(y, t * 8 + 64));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return baos.toByteArray();
    }

    public static byte[] getRSAPublicKey(RSAPrivateCrtKey privateKey) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            byte[] exponent = DnssecWorld.toUnsignedByteArray(privateKey.getPublicExponent());
            if (exponent.length > 255) {
                dos.writeByte(0);
                dos.writeShort(exponent.length);
            } else {
                dos.writeByte(exponent.length);
            }
            dos.write(exponent);
            dos.write(DnssecWorld.toUnsignedByteArray(privateKey.getModulus()));
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] toUnsignedByteArray(BigInteger bigInteger) {
        byte[] array = bigInteger.toByteArray();
        if (array[0] == 0) {
            byte[] tmp = new byte[array.length - 1];
            System.arraycopy(array, 1, tmp, 0, tmp.length);
            array = tmp;
        }
        return array;
    }

    private static byte[] toUnsignedByteArray(BigInteger bigInteger, int length) {
        byte[] array = bigInteger.toByteArray();
        if (array.length != length) {
            if (array.length == length + 1 && array[0] == 0) {
                byte[] tmp = new byte[array.length - 1];
                System.arraycopy(array, 1, tmp, 0, tmp.length);
                array = tmp;
            } else if (array.length < length) {
                byte[] tmp = new byte[length];
                System.arraycopy(array, 0, tmp, length - array.length, array.length);
                array = tmp;
            }
        }
        return array;
    }

    public static void addNsec(DnsWorld dnsWorld, CharSequence zone, CharSequence zoneSoaNameserver, CharSequence owner, String nextSecure, Record.TYPE ... typesCovered) {
        DnssecWorld.addNsec(dnsWorld, DnsName.from((CharSequence)zone), DnsName.from((CharSequence)zoneSoaNameserver), DnsName.from((CharSequence)owner), DnsName.from((String)nextSecure), typesCovered);
    }

    public static void addNsec(DnsWorld dnsWorld, DnsName zone, DnsName zoneSoaNameserver, DnsName owner, DnsName nextSecure, Record.TYPE ... typesCovered) {
        DnssecData dnssecData = DnssecWorld.getDnssecDataFor(zone);
        PrivateKey privateKey = dnssecData.privateZsk;
        DNSKEY key = dnssecData.zsk;
        DnssecConstants.SignatureAlgorithm signatureAlgorithm = dnssecData.signatureAlgorithm;
        DnsMessage.Builder nsecAnswerBuilder = DnsMessage.builder();
        List<Record<? extends Data>> records = DnssecWorld.merge(DnssecWorld.sign(key, zone, privateKey, signatureAlgorithm, DnssecWorld.record((DnsName)owner, (Data)DnssecWorld.nsec((DnsName)nextSecure, (Record.TYPE[])typesCovered))), DnssecWorld.sign(key, zone, privateKey, signatureAlgorithm, DnssecWorld.record((DnsName)owner, (Data)DnssecWorld.soa((DnsName)zoneSoaNameserver, (DnsName)DnsName.from((String)"mailbox.of.responsible.person"), (long)2015081265L, (int)7200, (int)3600, (int)1209600, (long)3600L))));
        nsecAnswerBuilder.setNameserverRecords(records);
        nsecAnswerBuilder.setAuthoritativeAnswer(true);
        DnsMessage nsecAnswer = nsecAnswerBuilder.build();
        InetAddress authoritativeNameserver = dnsWorld.lookupSingleAuthoritativeNameserverForZone(zone);
        AddressedNsecResponse preparedNsecResponse = new AddressedNsecResponse(authoritativeNameserver, nsecAnswer);
        dnsWorld.addPreparedResponse((DnsWorld.PreparedResponse)preparedNsecResponse);
    }

    public static final class DnssecData {
        public final DnsName zone;
        public final DNSKEY ksk;
        public final PrivateKey privateKsk;
        public final DNSKEY zsk;
        public final PrivateKey privateZsk;
        public final DnssecConstants.SignatureAlgorithm signatureAlgorithm;

        private DnssecData(DnsName zone, DNSKEY ksk, PrivateKey privateKsk, DNSKEY zsk, PrivateKey privateZsk, DnssecConstants.SignatureAlgorithm signatureAlgorithm) {
            this.zone = zone;
            this.ksk = ksk;
            this.privateKsk = privateKsk;
            this.zsk = zsk;
            this.privateZsk = privateZsk;
            this.signatureAlgorithm = signatureAlgorithm;
        }
    }

    public static class SignedRRSet {
        Record<? extends Data>[] records;
        Record<RRSIG> signature;

        public SignedRRSet(Record<? extends Data>[] records, Record<RRSIG> signature) {
            this.records = records;
            this.signature = signature;
        }
    }

    public static class AddressedNsecResponse
    implements DnsWorld.PreparedResponse {
        final InetAddress address;
        final DnsMessage nsecMessage;
        final boolean isRootNameserver;
        final List<Record<NSEC>> nsecRecords;

        public AddressedNsecResponse(InetAddress address, DnsMessage nsecMessage) {
            this.address = address;
            this.nsecMessage = nsecMessage;
            this.isRootNameserver = address.getHostName().endsWith(".root-servers.net");
            this.nsecRecords = nsecMessage.filterAuthoritySectionBy(NSEC.class);
        }

        public boolean isResponse(DnsMessage request, InetAddress address) {
            boolean nameserverMatches = this.isRootNameserver ? address.getHostName().endsWith(".root-servers.net") : address.equals(this.address);
            Record<NSEC> nsecRecord = this.nsecRecords.get(0);
            return nameserverMatches && Verifier.nsecMatches((DnsName)request.getQuestion().name, (DnsName)nsecRecord.name, (DnsName)((NSEC)nsecRecord.payloadData).next);
        }

        public DnsMessage getResponse() {
            return this.nsecMessage;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + String.valueOf(this.address) + "\n" + String.valueOf(this.nsecMessage);
        }
    }
}

