/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.dnssec;

import java.math.BigInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.minidns.DnsWorld;
import org.minidns.dnsmessage.Question;
import org.minidns.dnsname.DnsName;
import org.minidns.dnssec.DigestCalculator;
import org.minidns.dnssec.Verifier;
import org.minidns.dnssec.algorithms.JavaSecDigestCalculator;
import org.minidns.record.Data;
import org.minidns.record.NSEC;
import org.minidns.record.NSEC3;
import org.minidns.record.Record;

public class VerifierTest {
    @Test
    public void testNsecMatches() {
        Assertions.assertTrue((boolean)Verifier.nsecMatches((String)"example.com", (String)"com", (String)"com"));
        Assertions.assertTrue((boolean)Verifier.nsecMatches((String)"example.com", (String)"e.com", (String)"f.com"));
        Assertions.assertTrue((boolean)Verifier.nsecMatches((String)"example.com", (String)"be", (String)"de"));
        Assertions.assertTrue((boolean)Verifier.nsecMatches((String)"nsec.example.com", (String)"example.com", (String)"www.example.com"));
        Assertions.assertFalse((boolean)Verifier.nsecMatches((String)"example.com", (String)"a.com", (String)"example.com"));
        Assertions.assertFalse((boolean)Verifier.nsecMatches((String)"example.com", (String)"example1.com", (String)"example2.com"));
        Assertions.assertFalse((boolean)Verifier.nsecMatches((String)"example.com", (String)"test.com", (String)"xxx.com"));
        Assertions.assertFalse((boolean)Verifier.nsecMatches((String)"example.com", (String)"xxx.com", (String)"test.com"));
        Assertions.assertFalse((boolean)Verifier.nsecMatches((String)"example.com", (String)"aaa.com", (String)"bbb.com"));
        Assertions.assertFalse((boolean)Verifier.nsecMatches((String)"www.example.com", (String)"example2.com", (String)"example3.com"));
        Assertions.assertFalse((boolean)Verifier.nsecMatches((String)"test.nsec.example.com", (String)"nsec.example.com", (String)"a.nsec.example.com"));
        Assertions.assertFalse((boolean)Verifier.nsecMatches((String)"test.nsec.example.com", (String)"test.nsec.example.com", (String)"a.example.com"));
        Assertions.assertFalse((boolean)Verifier.nsecMatches((String)"www.example.com", (String)"example.com", (String)"nsec.example.com"));
        Assertions.assertFalse((boolean)Verifier.nsecMatches((String)"example.com", (String)"nsec.example.com", (String)"www.example.com"));
    }

    @Test
    public void testVerifyNsec() {
        Record nsecRecord = DnsWorld.record((String)"example.com", (Data)DnsWorld.nsec((String)"www.example.com", (Record.TYPE[])new Record.TYPE[]{Record.TYPE.A, Record.TYPE.NS, Record.TYPE.SOA, Record.TYPE.TXT, Record.TYPE.AAAA, Record.TYPE.RRSIG, Record.TYPE.NSEC, Record.TYPE.DNSKEY})).as(NSEC.class);
        Assertions.assertNull((Object)Verifier.verifyNsec((Record)nsecRecord, (Question)new Question((CharSequence)"nsec.example.com", Record.TYPE.A)));
        Assertions.assertNull((Object)Verifier.verifyNsec((Record)nsecRecord, (Question)new Question((CharSequence)"example.com", Record.TYPE.PTR)));
        Assertions.assertNotNull((Object)Verifier.verifyNsec((Record)nsecRecord, (Question)new Question((CharSequence)"www.example.com", Record.TYPE.A)));
        Assertions.assertNotNull((Object)Verifier.verifyNsec((Record)nsecRecord, (Question)new Question((CharSequence)"example.com", Record.TYPE.NS)));
    }

    @Test
    public void testVerifyNsec3() {
        byte[] bytes = new byte[]{63, -79, -48, -86, 39, -30, 95, -38, 64, 117, -110, -107, 90, 28, 127, -104, -37, 91, 121, -111};
        Record nsec3Record = DnsWorld.record((String)"7UO4LIHALHHLNGLJAFT7TBIQ6H1SL1CN.net", (Data)DnsWorld.nsec3((byte)1, (byte)1, (int)0, (byte[])new byte[0], (byte[])bytes, (Record.TYPE[])new Record.TYPE[]{Record.TYPE.NS, Record.TYPE.SOA, Record.TYPE.RRSIG, Record.TYPE.DNSKEY, Record.TYPE.NSEC3PARAM})).as(NSEC3.class);
        DnsName zone = DnsName.from((String)"net");
        Assertions.assertNull((Object)Verifier.verifyNsec3((DnsName)zone, (Record)nsec3Record, (Question)new Question((CharSequence)"x.net", Record.TYPE.A)));
        Assertions.assertNotNull((Object)Verifier.verifyNsec3((DnsName)zone, (Record)nsec3Record, (Question)new Question((CharSequence)"example.net", Record.TYPE.A)));
    }

    @Test
    public void testNsec3hash() throws Exception {
        JavaSecDigestCalculator digestCalculator = new JavaSecDigestCalculator("SHA-1");
        Assertions.assertEquals((Object)"6e8777855bcd60d7b45fc51893776dde75bf6cd4", (Object)new BigInteger(1, Verifier.nsec3hash((DigestCalculator)digestCalculator, (byte[])new byte[]{42}, (byte[])new byte[]{88}, (int)5)).toString(16));
    }
}

