/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.dnssec.algorithms;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.minidns.constants.DnssecConstants;
import org.minidns.dnssec.DigestCalculator;
import org.minidns.dnssec.algorithms.AlgorithmTest;
import org.minidns.record.NSEC3;

public class DigestTest
extends AlgorithmTest {
    @Test
    public void testSha1DsDigest() {
        DigestCalculator dsDigestCalculator = algorithmMap.getDsDigestCalculator(DnssecConstants.DigestAlgorithm.SHA1);
        Assertions.assertEquals((Object)"da39a3ee5e6b4b0d3255bfef95601890afd80709", (Object)DigestTest.digestHexString(dsDigestCalculator, ""));
        Assertions.assertEquals((Object)"a94a8fe5ccb19ba61c4c0873d391e987982fbbd3", (Object)DigestTest.digestHexString(dsDigestCalculator, "test"));
        Assertions.assertEquals((Object)"640ab2bae07bedc4c163f679a746f7ab7fb5d1fa", (Object)DigestTest.digestHexString(dsDigestCalculator, "Test"));
    }

    @Test
    public void testSha256DsDigest() {
        DigestCalculator dsDigestCalculator = algorithmMap.getDsDigestCalculator(DnssecConstants.DigestAlgorithm.SHA256);
        Assertions.assertEquals((Object)"e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855", (Object)DigestTest.digestHexString(dsDigestCalculator, ""));
        Assertions.assertEquals((Object)"9f86d081884c7d659a2feaa0c55ad015a3bf4f1b2b0b822cd15d6c15b0f00a08", (Object)DigestTest.digestHexString(dsDigestCalculator, "test"));
        Assertions.assertEquals((Object)"532eaabd9574880dbf76b9b8cc00832c20a6ec113d682299550d7a6e0f345e25", (Object)DigestTest.digestHexString(dsDigestCalculator, "Test"));
    }

    @Test
    public void testSha1nsec3Digest() {
        DigestCalculator nsecDigestCalculator = algorithmMap.getNsecDigestCalculator(NSEC3.HashAlgorithm.SHA1);
        Assertions.assertEquals((Object)"da39a3ee5e6b4b0d3255bfef95601890afd80709", (Object)DigestTest.digestHexString(nsecDigestCalculator, ""));
        Assertions.assertEquals((Object)"a94a8fe5ccb19ba61c4c0873d391e987982fbbd3", (Object)DigestTest.digestHexString(nsecDigestCalculator, "test"));
        Assertions.assertEquals((Object)"640ab2bae07bedc4c163f679a746f7ab7fb5d1fa", (Object)DigestTest.digestHexString(nsecDigestCalculator, "Test"));
    }

    private static String digestHexString(DigestCalculator digestCalculator, String in) {
        return new BigInteger(1, digestCalculator.digest(in.getBytes(StandardCharsets.UTF_8))).toString(16);
    }
}

