/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.dnssec.algorithms;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.minidns.constants.DnssecConstants;
import org.minidns.dnssec.DnssecValidationFailedException;
import org.minidns.dnssec.DnssecWorld;
import org.minidns.dnssec.algorithms.SignatureVerifierTest;

public class DsaSingatureVerifierTest
extends SignatureVerifierTest {
    private static final DnssecConstants.SignatureAlgorithm ALGORITHM = DnssecConstants.SignatureAlgorithm.DSA;

    @Test
    public void testDSA1024Valid() throws DnssecValidationFailedException {
        this.verifierTest(1024, ALGORITHM);
    }

    @Test
    public void testDSA512Valid() throws DnssecValidationFailedException {
        this.verifierTest(512, ALGORITHM);
    }

    @Test
    public void testDSAIllegalSignature() {
        byte[] sample = new byte[]{0};
        Assertions.assertThrows(DnssecValidationFailedException.DataMalformedException.class, () -> DsaSingatureVerifierTest.assertSignatureValid(DnssecWorld.publicKey(ALGORITHM, DnssecWorld.generatePrivateKey(ALGORITHM, 1024)), ALGORITHM, sample, sample));
    }

    @Test
    public void testDSAIllegalPublicKey() {
        byte[] sample = DsaSingatureVerifierTest.getRandomBytes();
        Assertions.assertThrows(DnssecValidationFailedException.DataMalformedException.class, () -> DsaSingatureVerifierTest.assertSignatureValid(new byte[]{0}, ALGORITHM, DnssecWorld.sign(DnssecWorld.generatePrivateKey(ALGORITHM, 1024), ALGORITHM, sample), sample));
    }

    @Test
    public void testDSAWrongSignature() throws DnssecValidationFailedException {
        byte[] sample = DsaSingatureVerifierTest.getRandomBytes();
        DsaSingatureVerifierTest.assertSignatureInvalid(DnssecWorld.publicKey(ALGORITHM, DnssecWorld.generatePrivateKey(ALGORITHM, 1024)), ALGORITHM, DnssecWorld.sign(DnssecWorld.generatePrivateKey(ALGORITHM, 1024), ALGORITHM, sample), sample);
    }
}

