/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.dnssec.algorithms;

import java.math.BigInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.minidns.constants.DnssecConstants;
import org.minidns.dnssec.DnssecValidationFailedException;
import org.minidns.dnssec.DnssecWorld;
import org.minidns.dnssec.algorithms.SignatureVerifierTest;

public class RsaSignatureVerifierTest
extends SignatureVerifierTest {
    @Test
    public void testShortExponentSHA1RSAValid() throws DnssecValidationFailedException {
        this.verifierTest(DnssecWorld.generateRSAPrivateKey(1024, BigInteger.valueOf(17L)), DnssecConstants.SignatureAlgorithm.RSASHA1);
    }

    @Test
    public void testLongExponentSHA1RSAValid() throws DnssecValidationFailedException {
        this.verifierTest(DnssecWorld.generateRSAPrivateKey(3072, BigInteger.valueOf(256L).pow(256).add(BigInteger.ONE)), DnssecConstants.SignatureAlgorithm.RSASHA1);
    }

    @Test
    public void testSHA1RSAIllegalSignature() throws DnssecValidationFailedException {
        byte[] sample = new byte[]{0};
        Assertions.assertThrows(DnssecValidationFailedException.class, () -> RsaSignatureVerifierTest.assertSignatureValid(DnssecWorld.publicKey(DnssecConstants.SignatureAlgorithm.RSASHA1, DnssecWorld.generatePrivateKey(DnssecConstants.SignatureAlgorithm.RSASHA1, 1024)), DnssecConstants.SignatureAlgorithm.RSASHA1, sample, sample));
    }

    @Test
    public void testSHA1RSAIllegalPublicKey() throws DnssecValidationFailedException {
        byte[] sample = RsaSignatureVerifierTest.getRandomBytes();
        Assertions.assertThrows(DnssecValidationFailedException.DataMalformedException.class, () -> RsaSignatureVerifierTest.assertSignatureValid(new byte[]{0}, DnssecConstants.SignatureAlgorithm.RSASHA1, DnssecWorld.sign(DnssecWorld.generatePrivateKey(DnssecConstants.SignatureAlgorithm.RSASHA1, 1024), DnssecConstants.SignatureAlgorithm.RSASHA1, sample), sample));
    }

    @Test
    public void testSHA1RSAWrongSignature() throws DnssecValidationFailedException {
        byte[] sample = RsaSignatureVerifierTest.getRandomBytes();
        RsaSignatureVerifierTest.assertSignatureInvalid(DnssecWorld.publicKey(DnssecConstants.SignatureAlgorithm.RSASHA1, DnssecWorld.generatePrivateKey(DnssecConstants.SignatureAlgorithm.RSASHA1, 1024)), DnssecConstants.SignatureAlgorithm.RSASHA1, DnssecWorld.sign(DnssecWorld.generatePrivateKey(DnssecConstants.SignatureAlgorithm.RSASHA1, 1024), DnssecConstants.SignatureAlgorithm.RSASHA1, sample), sample);
    }

    @Test
    public void testMD5RSAValid() throws DnssecValidationFailedException {
        this.verifierTest(1024, DnssecConstants.SignatureAlgorithm.RSAMD5);
    }

    @Test
    public void testSHA256RSAValid() throws DnssecValidationFailedException {
        this.verifierTest(1024, DnssecConstants.SignatureAlgorithm.RSASHA256);
    }

    @Test
    public void testSHA512RSAValid() throws DnssecValidationFailedException {
        this.verifierTest(1024, DnssecConstants.SignatureAlgorithm.RSASHA512);
    }
}

