/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.dnssec.algorithms;

import java.security.PrivateKey;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.jupiter.api.Assertions;
import org.minidns.constants.DnssecConstants;
import org.minidns.dnsname.DnsName;
import org.minidns.dnssec.DnssecValidationFailedException;
import org.minidns.dnssec.DnssecWorld;
import org.minidns.dnssec.algorithms.AlgorithmTest;
import org.minidns.record.DNSKEY;
import org.minidns.record.RRSIG;

public class SignatureVerifierTest
extends AlgorithmTest {
    protected void verifierTest(int length, DnssecConstants.SignatureAlgorithm algorithm) throws DnssecValidationFailedException {
        this.verifierTest(DnssecWorld.generatePrivateKey(algorithm, length), algorithm);
    }

    protected void verifierTest(PrivateKey privateKey, DnssecConstants.SignatureAlgorithm algorithm) throws DnssecValidationFailedException {
        byte[] sample = SignatureVerifierTest.getRandomBytes();
        SignatureVerifierTest.assertSignatureValid(DnssecWorld.publicKey(algorithm, privateKey), algorithm, DnssecWorld.sign(privateKey, algorithm, sample), sample);
    }

    protected static void assertSignatureValid(byte[] publicKey, DnssecConstants.SignatureAlgorithm algorithm, byte[] signature, byte[] signedBytes) throws DnssecValidationFailedException {
        Assertions.assertTrue((boolean)SignatureVerifierTest.verify(publicKey, algorithm, signature, signedBytes));
    }

    protected static void assertSignatureInvalid(byte[] publicKey, DnssecConstants.SignatureAlgorithm algorithm, byte[] signature, byte[] signedBytes) throws DnssecValidationFailedException {
        Assertions.assertFalse((boolean)SignatureVerifierTest.verify(publicKey, algorithm, signature, signedBytes));
    }

    private static boolean verify(byte[] publicKey, DnssecConstants.SignatureAlgorithm algorithm, byte[] signature, byte[] signedBytes) throws DnssecValidationFailedException {
        DNSKEY key = new DNSKEY(0, 0, algorithm, publicKey);
        RRSIG rrsig = new RRSIG(null, algorithm, 0, 0L, null, null, 0, DnsName.ROOT, signature);
        boolean res = algorithmMap.getSignatureVerifier(algorithm).verify(signedBytes, rrsig, key);
        return res;
    }

    protected static byte[] getRandomBytes() {
        byte[] randomBytes = new byte[1024];
        ThreadLocalRandom.current().nextBytes(randomBytes);
        return randomBytes;
    }
}

