/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.dnssec;

import java.util.Collections;
import java.util.List;
import org.minidns.constants.DnssecConstants;
import org.minidns.dnsmessage.Question;
import org.minidns.dnsname.DnsName;
import org.minidns.record.DNSKEY;
import org.minidns.record.Data;
import org.minidns.record.RRSIG;
import org.minidns.record.Record;

public abstract class DnssecUnverifiedReason {
    public abstract String getReasonString();

    public String toString() {
        return this.getReasonString();
    }

    public int hashCode() {
        return this.getReasonString().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof DnssecUnverifiedReason && ((DnssecUnverifiedReason)obj).getReasonString().equals(this.getReasonString());
    }

    public static class NSECDoesNotMatchReason
    extends DnssecUnverifiedReason {
        private final Question question;
        private final Record<? extends Data> record;

        public NSECDoesNotMatchReason(Question question, Record<? extends Data> record) {
            this.question = question;
            this.record = record;
        }

        @Override
        public String getReasonString() {
            return "NSEC " + String.valueOf(this.record.name) + " does nat match question for " + String.valueOf(this.question.type) + " at " + String.valueOf(this.question.name);
        }
    }

    public static class NoActiveSignaturesReason
    extends DnssecUnverifiedReason {
        private final Question question;
        private final List<RRSIG> outdatedRrSigs;

        public NoActiveSignaturesReason(Question question, List<RRSIG> outdatedRrSigs) {
            this.question = question;
            assert (!outdatedRrSigs.isEmpty());
            this.outdatedRrSigs = Collections.unmodifiableList(outdatedRrSigs);
        }

        @Override
        public String getReasonString() {
            return "No currently active signatures were attached to answer on question for " + String.valueOf(this.question.type) + " at " + String.valueOf(this.question.name);
        }

        public List<RRSIG> getOutdatedRrSigs() {
            return this.outdatedRrSigs;
        }
    }

    public static class NoSignaturesReason
    extends DnssecUnverifiedReason {
        private final Question question;

        public NoSignaturesReason(Question question) {
            this.question = question;
        }

        @Override
        public String getReasonString() {
            return "No signatures were attached to answer on question for " + String.valueOf(this.question.type) + " at " + String.valueOf(this.question.name);
        }
    }

    public static class NoRootSecureEntryPointReason
    extends DnssecUnverifiedReason {
        @Override
        public String getReasonString() {
            return "No secure entry point was found for the root zone (\"Did you forget to configure a root SEP?\")";
        }
    }

    public static class NoSecureEntryPointReason
    extends DnssecUnverifiedReason {
        private final DnsName zone;

        public NoSecureEntryPointReason(DnsName zone) {
            this.zone = zone;
        }

        @Override
        public String getReasonString() {
            return "No secure entry point was found for zone " + String.valueOf(this.zone);
        }
    }

    public static class NoTrustAnchorReason
    extends DnssecUnverifiedReason {
        private final DnsName zone;

        public NoTrustAnchorReason(DnsName zone) {
            this.zone = zone;
        }

        @Override
        public String getReasonString() {
            return "No trust anchor was found for zone " + String.valueOf(this.zone) + ". Try enabling DLV";
        }
    }

    public static class ConflictsWithSep
    extends DnssecUnverifiedReason {
        private final Record<DNSKEY> record;

        public ConflictsWithSep(Record<DNSKEY> record) {
            this.record = record;
        }

        @Override
        public String getReasonString() {
            return "Zone " + this.record.name.ace + " is in list of known SEPs, but DNSKEY from response mismatches!";
        }
    }

    public static class AlgorithmExceptionThrownReason
    extends DnssecUnverifiedReason {
        private final int algorithmNumber;
        private final String kind;
        private final Exception reason;
        private final Record<? extends Data> record;

        public AlgorithmExceptionThrownReason(DnssecConstants.DigestAlgorithm algorithm, String kind, Record<? extends Data> record, Exception reason) {
            this.algorithmNumber = algorithm.value;
            this.kind = kind;
            this.record = record;
            this.reason = reason;
        }

        @Override
        public String getReasonString() {
            return this.kind + " algorithm " + this.algorithmNumber + " threw exception while verifying " + String.valueOf(this.record.name) + ": " + String.valueOf(this.reason);
        }
    }

    public static class AlgorithmNotSupportedReason
    extends DnssecUnverifiedReason {
        private final String algorithm;
        private final Record.TYPE type;
        private final Record<? extends Data> record;

        public AlgorithmNotSupportedReason(byte algorithm, Record.TYPE type, Record<? extends Data> record) {
            this.algorithm = Integer.toString(algorithm & 0xFF);
            this.type = type;
            this.record = record;
        }

        @Override
        public String getReasonString() {
            return this.type.name() + " algorithm " + this.algorithm + " required to verify " + String.valueOf(this.record.name) + " is unknown or not supported by platform";
        }
    }
}

