/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.hla;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import org.minidns.AbstractDnsClient;
import org.minidns.DnsClient;
import org.minidns.dnslabel.DnsLabel;
import org.minidns.dnsmessage.Question;
import org.minidns.dnsname.DnsName;
import org.minidns.dnsqueryresult.DnsQueryResult;
import org.minidns.hla.ResolverResult;
import org.minidns.hla.SrvResolverResult;
import org.minidns.hla.srv.SrvProto;
import org.minidns.hla.srv.SrvService;
import org.minidns.hla.srv.SrvServiceProto;
import org.minidns.hla.srv.SrvType;
import org.minidns.iterative.ReliableDnsClient;
import org.minidns.record.Data;
import org.minidns.record.PTR;
import org.minidns.record.Record;
import org.minidns.record.SRV;

public class ResolverApi {
    public static final ResolverApi INSTANCE = new ResolverApi((AbstractDnsClient)new ReliableDnsClient());
    private final AbstractDnsClient dnsClient;

    public ResolverApi(AbstractDnsClient dnsClient) {
        this.dnsClient = dnsClient;
    }

    public final <D extends Data> ResolverResult<D> resolve(String name, Class<D> type) throws IOException {
        return this.resolve(DnsName.from((String)name), type);
    }

    public final <D extends Data> ResolverResult<D> resolve(DnsName name, Class<D> type) throws IOException {
        Record.TYPE t = Record.TYPE.getType(type);
        Question q = new Question(name, t);
        return this.resolve(q);
    }

    public <D extends Data> ResolverResult<D> resolve(Question question) throws IOException {
        DnsQueryResult dnsQueryResult = this.dnsClient.query(question);
        return new ResolverResult(question, dnsQueryResult, null);
    }

    public SrvResolverResult resolveSrv(SrvType type, String serviceName) throws IOException {
        return this.resolveSrv(type.service, type.proto, DnsName.from((String)serviceName));
    }

    public SrvResolverResult resolveSrv(SrvType type, DnsName serviceName) throws IOException {
        return this.resolveSrv(type.service, type.proto, serviceName);
    }

    public SrvResolverResult resolveSrv(SrvService service, SrvProto proto, String name) throws IOException {
        return this.resolveSrv(service.dnsLabel, proto.dnsLabel, DnsName.from((String)name));
    }

    public SrvResolverResult resolveSrv(SrvService service, SrvProto proto, DnsName name) throws IOException {
        return this.resolveSrv(service.dnsLabel, proto.dnsLabel, name);
    }

    public SrvResolverResult resolveSrv(DnsLabel service, DnsLabel proto, DnsName name) throws IOException {
        SrvServiceProto srvServiceProto = new SrvServiceProto(service, proto);
        return this.resolveSrv(name, srvServiceProto);
    }

    public SrvResolverResult resolveSrv(String name) throws IOException {
        return this.resolveSrv(DnsName.from((String)name));
    }

    public ResolverResult<PTR> reverseLookup(CharSequence inetAddressCs) throws IOException {
        InetAddress inetAddress = InetAddress.getByName(inetAddressCs.toString());
        return this.reverseLookup(inetAddress);
    }

    public ResolverResult<PTR> reverseLookup(InetAddress inetAddress) throws IOException {
        if (inetAddress instanceof Inet4Address) {
            return this.reverseLookup((Inet4Address)inetAddress);
        }
        if (inetAddress instanceof Inet6Address) {
            return this.reverseLookup((Inet6Address)inetAddress);
        }
        throw new IllegalArgumentException("The given InetAddress '" + String.valueOf(inetAddress) + "' is neither of type Inet4Address or Inet6Address");
    }

    public ResolverResult<PTR> reverseLookup(Inet4Address inet4Address) throws IOException {
        Question question = DnsClient.getReverseIpLookupQuestionFor((Inet4Address)inet4Address);
        return this.resolve(question);
    }

    public ResolverResult<PTR> reverseLookup(Inet6Address inet6Address) throws IOException {
        Question question = DnsClient.getReverseIpLookupQuestionFor((Inet6Address)inet6Address);
        return this.resolve(question);
    }

    public SrvResolverResult resolveSrv(DnsName srvDnsName) throws IOException {
        int labelCount = srvDnsName.getLabelCount();
        if (labelCount < 3) {
            throw new IllegalArgumentException();
        }
        DnsLabel service = srvDnsName.getLabel(labelCount - 1);
        DnsLabel proto = srvDnsName.getLabel(labelCount - 2);
        DnsName name = srvDnsName.stripToLabels(labelCount - 2);
        SrvServiceProto srvServiceProto = new SrvServiceProto(service, proto);
        return this.resolveSrv(name, srvServiceProto);
    }

    public SrvResolverResult resolveSrv(DnsName name, SrvServiceProto srvServiceProto) throws IOException {
        DnsName srvDnsName = DnsName.from((DnsLabel)srvServiceProto.service, (DnsLabel)srvServiceProto.proto, (DnsName)name);
        ResolverResult<SRV> result = this.resolve(srvDnsName, SRV.class);
        return new SrvResolverResult(result, srvServiceProto, this);
    }

    public final AbstractDnsClient getClient() {
        return this.dnsClient;
    }
}

