/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.iterative;

import java.io.IOException;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.minidns.AbstractDnsClient;
import org.minidns.DnsCache;
import org.minidns.DnsWorld;
import org.minidns.cache.LruCache;
import org.minidns.dnsmessage.DnsMessage;
import org.minidns.dnsqueryresult.DnsQueryResult;
import org.minidns.iterative.IterativeClientException;
import org.minidns.iterative.IterativeDnsClient;
import org.minidns.record.A;
import org.minidns.record.Data;
import org.minidns.record.Record;

public class IterativeDnsClientTest {
    @Test
    public void basicIterativeTest() throws IOException {
        IterativeDnsClient client = new IterativeDnsClient((DnsCache)new LruCache(0));
        DnsWorld.applyZones((AbstractDnsClient)client, (DnsWorld.Zone[])new DnsWorld.Zone[]{DnsWorld.rootZone((Record[])new Record[]{DnsWorld.record((String)"com", (Data)DnsWorld.ns((String)"ns.com")), DnsWorld.record((String)"ns.com", (Data)DnsWorld.a((CharSequence)"1.1.1.1"))}), DnsWorld.zone((String)"com", (String)"ns.com", (String)"1.1.1.1", (Record[])new Record[]{DnsWorld.record((String)"example.com", (Data)DnsWorld.ns((String)"ns.example.com")), DnsWorld.record((String)"ns.example.com", (Data)DnsWorld.a((CharSequence)"1.1.1.2"))}), DnsWorld.zone((String)"example.com", (String)"ns.example.com", (String)"1.1.1.2", (Record[])new Record[]{DnsWorld.record((String)"www.example.com", (Data)DnsWorld.a((CharSequence)"1.1.1.3"))})});
        DnsQueryResult result = client.query((CharSequence)"www.example.com", Record.TYPE.A);
        DnsMessage message = result.response;
        List answers = message.answerSection;
        Assertions.assertEquals((int)1, (int)answers.size());
        Assertions.assertEquals((Object)Record.TYPE.A, (Object)((Record)answers.get((int)0)).type);
        Assertions.assertArrayEquals((byte[])new byte[]{1, 1, 1, 3}, (byte[])((A)((Record)answers.get((int)0)).payloadData).getIp());
    }

    @Test
    public void loopIterativeTest() throws IOException {
        IterativeDnsClient client = new IterativeDnsClient((DnsCache)new LruCache(0));
        DnsWorld.applyZones((AbstractDnsClient)client, (DnsWorld.Zone[])new DnsWorld.Zone[]{DnsWorld.rootZone((Record[])new Record[]{DnsWorld.record((String)"a", (Data)DnsWorld.ns((String)"a.ns")), DnsWorld.record((String)"b", (Data)DnsWorld.ns((String)"b.ns")), DnsWorld.record((String)"a.ns", (Data)DnsWorld.a((CharSequence)"1.1.1.1")), DnsWorld.record((String)"b.ns", (Data)DnsWorld.a((CharSequence)"1.1.1.2"))}), DnsWorld.zone((String)"a", (String)"a.ns", (String)"1.1.1.1", (Record[])new Record[]{DnsWorld.record((String)"test.a", (Data)DnsWorld.ns((String)"a.test.b"))}), DnsWorld.zone((String)"b", (String)"b.ns", (String)"1.1.1.2", (Record[])new Record[]{DnsWorld.record((String)"test.b", (Data)DnsWorld.ns((String)"b.test.a"))})});
        Assertions.assertThrows(IterativeClientException.LoopDetected.class, () -> client.query((CharSequence)"www.test.a", Record.TYPE.A));
    }

    @Test
    public void notGluedNsTest() throws IOException {
        IterativeDnsClient client = new IterativeDnsClient((DnsCache)new LruCache(0));
        DnsWorld.applyZones((AbstractDnsClient)client, (DnsWorld.Zone[])new DnsWorld.Zone[]{DnsWorld.rootZone((Record[])new Record[]{DnsWorld.record((String)"com", (Data)DnsWorld.ns((String)"ns.com")), DnsWorld.record((String)"net", (Data)DnsWorld.ns((String)"ns.net")), DnsWorld.record((String)"ns.com", (Data)DnsWorld.a((CharSequence)"1.1.1.1")), DnsWorld.record((String)"ns.net", (Data)DnsWorld.a((CharSequence)"1.1.2.1"))}), DnsWorld.zone((String)"com", (String)"ns.com", (String)"1.1.1.1", (Record[])new Record[]{DnsWorld.record((String)"example.com", (Data)DnsWorld.ns((String)"example.ns.net"))}), DnsWorld.zone((String)"net", (String)"ns.net", (String)"1.1.2.1", (Record[])new Record[]{DnsWorld.record((String)"example.ns.net", (Data)DnsWorld.a((CharSequence)"1.1.2.2"))}), DnsWorld.zone((String)"example.com", (String)"example.ns.net", (String)"1.1.2.2", (Record[])new Record[]{DnsWorld.record((String)"www.example.com", (Data)DnsWorld.a((CharSequence)"1.1.1.3"))})});
        DnsQueryResult result = client.query((CharSequence)"www.example.com", Record.TYPE.A);
        DnsMessage message = result.response;
        List answers = message.answerSection;
        Assertions.assertEquals((int)1, (int)answers.size());
        Assertions.assertEquals((Object)Record.TYPE.A, (Object)((Record)answers.get((int)0)).type);
        Assertions.assertArrayEquals((byte[])new byte[]{1, 1, 1, 3}, (byte[])((A)((Record)answers.get((int)0)).payloadData).getIp());
    }
}

