/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.iterative;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.minidns.AbstractDnsClient;
import org.minidns.DnsCache;
import org.minidns.DnsClient;
import org.minidns.dnsmessage.DnsMessage;
import org.minidns.dnsmessage.Question;
import org.minidns.dnsqueryresult.DnsQueryResult;
import org.minidns.iterative.IterativeDnsClient;
import org.minidns.source.DnsDataSource;
import org.minidns.util.MultipleIoException;

public class ReliableDnsClient
extends AbstractDnsClient {
    private final IterativeDnsClient recursiveDnsClient;
    private final DnsClient dnsClient;
    private Mode mode = Mode.recursiveWithIterativeFallback;

    public ReliableDnsClient(DnsCache dnsCache) {
        super(dnsCache);
        this.recursiveDnsClient = new IterativeDnsClient(dnsCache){

            @Override
            protected DnsMessage.Builder newQuestion(DnsMessage.Builder questionMessage) {
                questionMessage = super.newQuestion(questionMessage);
                return ReliableDnsClient.this.newQuestion(questionMessage);
            }

            @Override
            protected boolean isResponseCacheable(Question q, DnsQueryResult dnsMessage) {
                boolean res = super.isResponseCacheable(q, dnsMessage);
                return ReliableDnsClient.this.isResponseCacheable(q, dnsMessage) && res;
            }
        };
        this.dnsClient = new DnsClient(dnsCache){

            protected DnsMessage.Builder newQuestion(DnsMessage.Builder questionMessage) {
                questionMessage = super.newQuestion(questionMessage);
                return ReliableDnsClient.this.newQuestion(questionMessage);
            }

            protected boolean isResponseCacheable(Question q, DnsQueryResult dnsMessage) {
                boolean res = super.isResponseCacheable(q, dnsMessage);
                return ReliableDnsClient.this.isResponseCacheable(q, dnsMessage) && res;
            }
        };
    }

    public ReliableDnsClient() {
        this((DnsCache)DEFAULT_CACHE);
    }

    protected DnsQueryResult query(DnsMessage.Builder q) throws IOException {
        DnsQueryResult dnsMessage = null;
        String unacceptableReason = null;
        ArrayList<IOException> ioExceptions = new ArrayList<IOException>();
        if (this.mode != Mode.iterativeOnly) {
            try {
                dnsMessage = this.dnsClient.query(q);
                if (dnsMessage != null && (unacceptableReason = this.isResponseAcceptable(dnsMessage.response)) == null) {
                    return dnsMessage;
                }
            }
            catch (IOException ioException) {
                ioExceptions.add(ioException);
            }
        }
        if (this.mode == Mode.recursiveOnly) {
            return dnsMessage;
        }
        Level FALLBACK_LOG_LEVEL = Level.FINE;
        if (LOGGER.isLoggable(FALLBACK_LOG_LEVEL) && this.mode != Mode.iterativeOnly) {
            Object logString = "Resolution fall back to iterative mode because: ";
            if (!ioExceptions.isEmpty()) {
                logString = (String)logString + String.valueOf(ioExceptions.get(0));
            } else if (dnsMessage == null) {
                logString = (String)logString + " DnsClient did not return a response";
            } else if (unacceptableReason != null) {
                logString = (String)logString + unacceptableReason + ". Response:\n" + String.valueOf(dnsMessage);
            } else {
                throw new AssertionError((Object)"This should never been reached");
            }
            LOGGER.log(FALLBACK_LOG_LEVEL, (String)logString);
        }
        try {
            dnsMessage = this.recursiveDnsClient.query(q);
            assert (dnsMessage != null);
        }
        catch (IOException ioException) {
            ioExceptions.add(ioException);
        }
        if (dnsMessage == null) {
            assert (!ioExceptions.isEmpty());
            MultipleIoException.throwIfRequired(ioExceptions);
        }
        return dnsMessage;
    }

    protected DnsMessage.Builder newQuestion(DnsMessage.Builder questionMessage) {
        return questionMessage;
    }

    protected boolean isResponseCacheable(Question q, DnsQueryResult result) {
        return this.isResponseAcceptable(result.response) == null;
    }

    protected String isResponseAcceptable(DnsMessage response) {
        return null;
    }

    public void setDataSource(DnsDataSource dataSource) {
        super.setDataSource(dataSource);
        this.recursiveDnsClient.setDataSource(dataSource);
        this.dnsClient.setDataSource(dataSource);
    }

    public void setMode(Mode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("Mode must not be null.");
        }
        this.mode = mode;
    }

    public void setUseHardcodedDnsServers(boolean useHardcodedDnsServers) {
        this.dnsClient.setUseHardcodedDnsServers(useHardcodedDnsServers);
    }

    public static enum Mode {
        recursiveWithIterativeFallback,
        recursiveOnly,
        iterativeOnly;

    }
}

