/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.minidnsrepl;

import java.io.IOException;
import org.minidns.AbstractDnsClient;
import org.minidns.DnsCache;
import org.minidns.cache.ExtendedLruCache;
import org.minidns.dnsname.DnsName;
import org.minidns.dnssec.DnssecClient;
import org.minidns.dnssec.DnssecQueryResult;
import org.minidns.dnssec.DnssecUnverifiedReason;
import org.minidns.integrationtest.IntegrationTestTools;
import org.minidns.iterative.ReliableDnsClient;
import org.minidns.jul.MiniDnsJul;
import org.minidns.minidnsrepl.MiniDnsStats;
import org.minidns.record.Record;

public class DnssecStats {
    private static final DnsName DOMAIN = DnsName.from((String)"verteiltesysteme.net");
    private static final Record.TYPE RR_TYPE = Record.TYPE.A;

    public static void iterativeDnssecLookupNormalVsExtendedCache() throws IOException {
        DnssecStats.iterativeDnssecLookup(IntegrationTestTools.CacheConfig.extended);
    }

    private static void iterativeDnssecLookup(IntegrationTestTools.CacheConfig cacheConfig) throws IOException {
        DnssecClient client = MiniDnsStats.getClient(cacheConfig);
        client.setMode(ReliableDnsClient.Mode.iterativeOnly);
        DnssecQueryResult secRes = client.queryDnssec((CharSequence)DOMAIN, RR_TYPE);
        StringBuilder stats = MiniDnsStats.getStats((AbstractDnsClient)client);
        stats.append('\n');
        stats.append(secRes);
        stats.append('\n');
        for (DnssecUnverifiedReason r : secRes.getUnverifiedReasons()) {
            stats.append(r);
        }
        stats.append("\n\n");
        System.out.println(stats);
    }

    public static void iterativeDnsssecTest() throws SecurityException, IllegalArgumentException, IOException {
        MiniDnsJul.enableMiniDnsTrace();
        DnssecClient client = new DnssecClient((DnsCache)new ExtendedLruCache());
        client.setMode(ReliableDnsClient.Mode.iterativeOnly);
        DnssecQueryResult secRes = client.queryDnssec((CharSequence)"verteiltesysteme.net", Record.TYPE.A);
        System.out.println(secRes);
    }
}

