/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.minidnsrepl;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import org.minidns.AbstractDnsClient;
import org.minidns.DnsClient;
import org.minidns.cache.LruCache;
import org.minidns.dnsmessage.DnsMessage;
import org.minidns.dnssec.DnssecClient;
import org.minidns.hla.DnssecResolverApi;
import org.minidns.hla.ResolverResult;
import org.minidns.iterative.IterativeDnsClient;
import org.minidns.jul.MiniDnsJul;
import org.minidns.record.A;

public class MiniDnsRepl {
    public static final DnsClient DNSCLIENT = new DnsClient();
    public static final IterativeDnsClient ITERATIVEDNSCLIENT = new IterativeDnsClient();
    public static final DnssecClient DNSSECCLIENT = new DnssecClient();
    public static final LruCache DEFAULT_CACHE;

    public static void init() {
        System.out.println("MiniDNS REPL");
    }

    public static void clearCache() throws SecurityException, IllegalArgumentException {
        DEFAULT_CACHE.clear();
    }

    public static void main(String[] args) throws IOException, SecurityException, IllegalArgumentException {
        MiniDnsJul.enableMiniDnsTrace();
        ResolverResult res = DnssecResolverApi.INSTANCE.resolveDnssecReliable("verteiltesysteme.net", A.class);
        System.out.println(res);
    }

    public static void writeToFile(DnsMessage dnsMessage, String path) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(path);){
            dnsMessage.writeTo((OutputStream)fos, true);
        }
    }

    static {
        LruCache cache = null;
        try {
            Field defaultCacheField = AbstractDnsClient.class.getDeclaredField("DEFAULT_CACHE");
            defaultCacheField.setAccessible(true);
            cache = (LruCache)defaultCacheField.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
            throw new IllegalStateException(e);
        }
        DEFAULT_CACHE = cache;
    }
}

